package com.ejianc.foundation.calibration.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 招标(定标)信息
 * 
 * @author generator
 * 
 */
public class CalibrationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String ysNo; // 系统编号
    private String tenderCode; // 招标编码
    private String name; // 招标名称
    private String organizationSysNo; // 组织机构系统编号
    private String organizationCode; // 组织机构代码
    private String organizationName; // 组织机构名称
    private String contractType; // 合同类型：0=Purchase=采购合同,1=Agreement=协议合同
    private String contractTypeShow; // 合同类型：0=Purchase=采购合同,1=Agreement=协议合同
    private String systemCategoryType; // 品类类型：0=Material=物资,1=Equipment=设备,2=LaborSubcontract =劳务分包,3=SpecialtySubcontract=专业分包,4=SpecialtyService =专业服务5=Lease =租赁
    private String systemCategoryTypeShow; // 品类类型：0=Material=物资,1=Equipment=设备,2=LaborSubcontract =劳务分包,3=SpecialtySubcontract=专业分包,4=SpecialtyService =专业服务5=Lease =租赁
    private BigDecimal amount; // 概算金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date calibrationResultNoticeDate; // 定标结果发布时间
    private String tenderType; // 招标方式：0=Public=公开招标,1=Invitation=邀请招标,2=Inquiry=询价采购,3=Protocol=议标采购——竞争性谈判,4=Sporadic=零星采购——单一来源采购,5=Emergent=紧急采购,6=Compare=询比采购,7=BiddingPrice=竞价采购,8=Negotiations=谈判采购,9=Direct=直接采购
    private String tenderTypeShow; // 招标方式：0=Public=公开招标,1=Invitation=邀请招标,2=Inquiry=询价采购,3=Protocol=议标采购——竞争性谈判,4=Sporadic=零星采购——单一来源采购,5=Emergent=紧急采购,6=Compare=询比采购,7=BiddingPrice=竞价采购,8=Negotiations=谈判采购,9=Direct=直接采购
    private String status; // 状态：0=确认招标概要,10=确认招标清单,20=确认招标供应商,30=确认公告内容,40=发布公告预览,42=待发布公告,45=供应商报名,47=供应商报名截止,50=确认报名信息,60=通知报名结果,65=确认发标清单,85=开标人设置,90=确认招标文件内容,100=发布招标文件预览,105=待发布招标文件,110=回标中,115=回标截止,116=评标设置,117=评标概要汇总,118=评标人设置,119=供应商数据导入,120=开标设置,130=开标中,140=开标结果,145=已设置评标人,150=评标,155=调价中,157=调价结束160=确认定标报告,170=发布定标结果,180=结束

    private String allProject; // 所有项目名称
    private String yzwFileNo; // 云筑网文件编码
    private List<CalibrationProjectVO> calibrationProjectList = new ArrayList<>(); // 招标(定标)信息-项目
    private List<CalibrationSupplierVO> calibrationSupplierList = new ArrayList<>(); // 招标(定标)信息-供应商

    private String projectSysNo; // 项目编号
    private String projectName; // 项目名称
    private Long supplierId; // 供应商编号
    private String supplierSysNo; // 供应商编号
    private String supplierName; // 供应商名称

    private Long supplierTaxPayerType; //
    private String supplierSocialCreditCode; //
    private String supplierBank; //
    private String supplierBankAccount; //
    private String supplierLegal; //
    private String supplierTelephone; //


    private String redId; //

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getYsNo() {
        return ysNo;
    }

    public void setYsNo(String ysNo) {
        this.ysNo = ysNo;
    }
    public String getTenderCode() {
        return tenderCode;
    }

    public void setTenderCode(String tenderCode) {
        this.tenderCode = tenderCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getOrganizationSysNo() {
        return organizationSysNo;
    }

    public void setOrganizationSysNo(String organizationSysNo) {
        this.organizationSysNo = organizationSysNo;
    }
    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public String getSystemCategoryType() {
        return systemCategoryType;
    }

    public void setSystemCategoryType(String systemCategoryType) {
        this.systemCategoryType = systemCategoryType;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public Date getCalibrationResultNoticeDate() {
        return calibrationResultNoticeDate;
    }

    public void setCalibrationResultNoticeDate(Date calibrationResultNoticeDate) {
        this.calibrationResultNoticeDate = calibrationResultNoticeDate;
    }
    public String getTenderType() {
        return tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getYzwFileNo() {
        return yzwFileNo;
    }

    public void setYzwFileNo(String yzwFileNo) {
        this.yzwFileNo = yzwFileNo;
    }

    public List<CalibrationProjectVO> getCalibrationProjectList() {
        return calibrationProjectList;
     }

     public void setCalibrationProjectList(List<CalibrationProjectVO> calibrationProjectList) {
        this.calibrationProjectList = calibrationProjectList;
     }
     public List<CalibrationSupplierVO> getCalibrationSupplierList() {
        return calibrationSupplierList;
     }

     public void setCalibrationSupplierList(List<CalibrationSupplierVO> calibrationSupplierList) {
        this.calibrationSupplierList = calibrationSupplierList;
     }

    public String getProjectSysNo() {
        return projectSysNo;
    }

    public void setProjectSysNo(String projectSysNo) {
        this.projectSysNo = projectSysNo;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierSysNo() {
        return supplierSysNo;
    }

    public void setSupplierSysNo(String supplierSysNo) {
        this.supplierSysNo = supplierSysNo;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getRedId() {
        return redId;
    }

    public void setRedId(String redId) {
        this.redId = redId;
    }

    public String getAllProject() {
        return allProject;
    }

    public void setAllProject(String allProject) {
        this.allProject = allProject;
    }

    public Long getSupplierTaxPayerType() {
        return supplierTaxPayerType;
    }

    public void setSupplierTaxPayerType(Long supplierTaxPayerType) {
        this.supplierTaxPayerType = supplierTaxPayerType;
    }

    public String getSupplierSocialCreditCode() {
        return supplierSocialCreditCode;
    }

    public void setSupplierSocialCreditCode(String supplierSocialCreditCode) {
        this.supplierSocialCreditCode = supplierSocialCreditCode;
    }

    public String getSupplierBank() {
        return supplierBank;
    }

    public void setSupplierBank(String supplierBank) {
        this.supplierBank = supplierBank;
    }

    public String getSupplierBankAccount() {
        return supplierBankAccount;
    }

    public void setSupplierBankAccount(String supplierBankAccount) {
        this.supplierBankAccount = supplierBankAccount;
    }

    public String getSupplierLegal() {
        return supplierLegal;
    }

    public void setSupplierLegal(String supplierLegal) {
        this.supplierLegal = supplierLegal;
    }

    public String getSupplierTelephone() {
        return supplierTelephone;
    }

    public void setSupplierTelephone(String supplierTelephone) {
        this.supplierTelephone = supplierTelephone;
    }

    public String getContractTypeShow() {
        String name = "";
        switch (contractType){
            case "0": name = "采购合同";break;
            case "1": name = "协议合同";break;
        }
        return name;
    }

    public void setContractTypeShow(String contractTypeShow) {
        this.contractTypeShow = contractTypeShow;
    }

    public String getSystemCategoryTypeShow() {
        String name = "";
        switch (contractType){
            case "0": name = "物资";break;
            case "1": name = "设备";break;
            case "2": name = "劳务分包";break;
            case "3": name = "专业分包";break;
            case "4": name = "专业服务";break;
            case "5": name = "租赁";break;
        }
        return name;
    }

    public void setSystemCategoryTypeShow(String systemCategoryTypeShow) {
        this.systemCategoryTypeShow = systemCategoryTypeShow;
    }

    public String getTenderTypeShow() {
        String name = "";
        switch (contractType){
            case "0": name = "公开招标";break;
            case "1": name = "邀请招标";break;
            case "2": name = "询价采购";break;
            case "3": name = "议标采购——竞争性谈判";break;
            case "4": name = "零星采购——单一来源采购";break;
            case "5": name = "紧急采购";break;
            case "6": name = "询比采购";break;
            case "7": name = "竞价采购";break;
            case "8": name = "谈判采购";break;
            case "9": name = "直接采购";break;
        }
        return name;
    }

    public void setTenderTypeShow(String tenderTypeShow) {
        this.tenderTypeShow = tenderTypeShow;
    }
}
