package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractTotalPriceService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractTotalPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontract")
public class OutcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String LABOROUTCONTRACT_BILL_CODE = "ZJKJ-LABOROUTCONTRACT";//劳务分包
    private static final String MAJOROUTCONTRACT_BILL_CODE = "ZJKJ-MAJOROUTCONTRACT";//专业分包
    private static final String MATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-MATERIALOUTCONTRACT";//物资采购
    private static final String EQUIPMENTOUTCONTRACT_BILL_CODE = "ZJKJ-EQUIPMENTOUTCONTRACT";//机械租赁
    private static final String TURNOVERMATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-TURNOVERMATERIALOUTCONTRACT";//周转材租赁
    private static final String DESIGNOUTCONTRACT_BILL_CODE = "ZJKJ-DESIGNOUTCONTRACT";//设计勘察
    private static final String CONSULTANCYOUTCONTRACT_BILL_CODE = "ZJKJ-CONSULTANCYOUTCONTRACT";//咨询服务
    private static final String OTHEROUTCONTRACT = "ZJKJ-OTHEROUTCONTRACT";//其它合同

    @Autowired
    private IOutcontractService service;

    @Autowired
    private IRecordOutcontractService recordOutcontractService;

    @Autowired
    private IOutcontractSubcontractTotalPriceService outcontractSubcontractTotalPriceService;

    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;
    
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutcontractVO> saveOrUpdate(@RequestBody OutcontractVO saveOrUpdateVO) {
    	OutcontractEntity entity = BeanMapper.map(saveOrUpdateVO, OutcontractEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    		String code = "";
    		entity.setChangeState("1");//未变更
    		if("劳务分包".equals(saveOrUpdateVO.getType())){
    			code = LABOROUTCONTRACT_BILL_CODE;
    		}else if("专业分包".equals(saveOrUpdateVO.getType())){
    			code = MAJOROUTCONTRACT_BILL_CODE;
    		}else if("物资采购".equals(saveOrUpdateVO.getType())){
    			code = MATERIALOUTCONTRACT_BILL_CODE;
    		}else if("机械租赁".equals(saveOrUpdateVO.getType())){
    			code = EQUIPMENTOUTCONTRACT_BILL_CODE;
    		}else if("周转材租赁".equals(saveOrUpdateVO.getType())){
    			code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
    		}else if("设计勘察".equals(saveOrUpdateVO.getType())){
    			code = DESIGNOUTCONTRACT_BILL_CODE;
    		}else if("咨询服务".equals(saveOrUpdateVO.getType())){
    			code = CONSULTANCYOUTCONTRACT_BILL_CODE;
    		}else if("其它合同".equals(saveOrUpdateVO.getType())){
    			code = OTHEROUTCONTRACT;
    		}
            BillCodeParam billCodeParam = BillCodeParam.build(code,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	//处理子表数据
        // 供方信息
    	if(saveOrUpdateVO.getOutcontractSupplierList()!=null&&saveOrUpdateVO.getOutcontractSupplierList().size()>0){
    		OutcontractSupplierVO outcontractSupplierVO = saveOrUpdateVO.getOutcontractSupplierList().get(0);
    		entity.setSupplierName(outcontractSupplierVO.getSupplierName());// 分供商名称
    		entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());// 纳税人类型
    		entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());// 统一社会信用代码
    		entity.setSupplierBank(outcontractSupplierVO.getSupplierBank()); // 开户行
    		entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());; // 开户行账号
    		entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser()); // 联系人
    		entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress()); // 联系人地址
    		entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone()); // 联系人电话
    		entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail()); // 联系人邮箱
    		entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal()); // 法定代表人
    		entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone()); // 供方电话
    	}else{
    		entity.setSupplierName(null);// 分供商名称
    		entity.setSupplierTaxPayerType(null);// 纳税人类型
    		entity.setSupplierSocialCreditCode(null);// 统一社会信用代码
    		entity.setSupplierBank(null); // 开户行
    		entity.setSupplierBankAccount(null);; // 开户行账号
    		entity.setSupplierContactUser(null); // 联系人
    		entity.setSupplierContactUserAddress(null); // 联系人地址
    		entity.setSupplierContactUserPhone(null); // 联系人电话
    		entity.setSupplierContactUserEmail(null); // 联系人邮箱
    		entity.setSupplierLegal(null); // 法定代表人
    		entity.setSupplierTelephone(null); // 供方电话
    	}
    	service.saveOrUpdate(entity, false);
    	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
    	vo.setOutcontractSupplierList(saveOrUpdateVO.getOutcontractSupplierList());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutcontractVO> queryDetail(Long id) {
    	OutcontractEntity entity = service.selectById(id);
    	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
    	
    	List<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<>();
    	OutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, OutcontractSupplierVO.class);
    	outcontractSupplierVO.setRowState("add");
    	outcontractSupplierList.add(outcontractSupplierVO);
		vo.setOutcontractSupplierList(outcontractSupplierList);

		if(vo.getOutcontractSubcontractUnitPriceList()!=null&&vo.getOutcontractSubcontractUnitPriceList().size()>0){
			vo.setOutcontractSubcontractUnitPriceList(createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
		}
		//当前单据变更过则显示变更记录
    	if(!"1".equals(vo.getChangeState())){
    		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("outcontract_id", vo.getId());
        	List<RecordOutcontractEntity> records = recordOutcontractService.list(queryWrapper);
        	if(records!=null&&records.size()>0){
        		vo.setRecordOutcontractList(BeanMapper.mapList(records, RecordOutcontractVO.class));
        	}
    	}
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutcontractEntity> page = service.queryPage(param,false);
        IPage<OutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutcontractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutcontractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> refOutcontractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
            	param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        IPage<OutcontractEntity> page = service.queryPage(param,false);
        IPage<OutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    
    /**
     * @Description saveintegratedCode 保存一体化编码
     */
    @RequestMapping(value = "/saveintegratedCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveintegratedCode(@RequestBody OutcontractVO saveorUpdateVO) {
    	OutcontractEntity entity = service.selectById(saveorUpdateVO.getId());
    	entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
    	service.saveOrUpdate(entity, false);
		return CommonResponse.success("保存一体化编码成功");
    }
    
	/********************分包工程总价汇总表导入导出start**************/
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadTotalPrice")
	@ResponseBody
	public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractSubcontractTotalPrice-import.xlsx", "分包工程总价汇总表模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportTotalPric", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<OutcontractSubcontractTotalPriceVO> successList = new ArrayList<>();
		List<OutcontractSubcontractTotalPriceVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		BigDecimal subcontractTotalAmount = new BigDecimal(0);
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=1;i<result.size();i++) {
					List<String> datas = result.get(i);
					OutcontractSubcontractTotalPriceVO outcontractSubcontractTotalPriceVO = new OutcontractSubcontractTotalPriceVO();
					if(StringUtils.isEmpty(datas.get(0))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("分项名称不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(2))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("暂定工程量不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(3))) {
						outcontractSubcontractTotalPriceVO.setErrorMsg("含税综合单价不能为空！");
						errorList.add(outcontractSubcontractTotalPriceVO);
						continue;
					}
					outcontractSubcontractTotalPriceVO.setId(IdWorker.getId());
					outcontractSubcontractTotalPriceVO.setItemName(datas.get(0)); // 分项名称
					outcontractSubcontractTotalPriceVO.setUnit(datas.get(1)); // 单位
					outcontractSubcontractTotalPriceVO.setProvisionalQuantity(StringUtils.isNotBlank(datas.get(2))?new BigDecimal(datas.get(2)):null); // 暂定工程量
					outcontractSubcontractTotalPriceVO.setTaxAllUnitPrice(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 含税综合单价
					if(outcontractSubcontractTotalPriceVO.getProvisionalQuantity()!=null&&outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()!=null){
						outcontractSubcontractTotalPriceVO.setTotalPrice((outcontractSubcontractTotalPriceVO.getProvisionalQuantity().multiply(outcontractSubcontractTotalPriceVO.getTaxAllUnitPrice()))); // 合计
					}
					if(outcontractSubcontractTotalPriceVO.getTotalPrice()!=null){
						subcontractTotalAmount = subcontractTotalAmount.add(outcontractSubcontractTotalPriceVO.getTotalPrice());
					}
					outcontractSubcontractTotalPriceVO.setRemark(datas.get(5)); // 备注
					successList.add(outcontractSubcontractTotalPriceVO);
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("subcontractTotalAmount", subcontractTotalAmount);
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTotalPricFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTotalPricFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<OutcontractSubcontractTotalPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		List<OutcontractSubcontractTotalPriceEntity> list = outcontractSubcontractTotalPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportTotalPricFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportTotalPricFromPage(@RequestBody List<OutcontractSubcontractTotalPriceVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractTotalPrice-export.xlsx", beans, response);
	}
	/********************分包工程总价汇总表导入导出start**************/

    
	/********************分包工程综合单价计价表导入导出start**************/

	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/downloadUnitPrice")
	@ResponseBody
	public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "outcontractSubcontractUnitPrice-import.xlsx", "分包工程综合单价计价模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImportUnitPrice", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportUnitPrice(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<OutcontractSubcontractUnitPriceVO> successList = new ArrayList<>();
		List<OutcontractSubcontractUnitPriceVO> errorList = new ArrayList<>();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		Map<String,OutcontractSubcontractUnitPriceVO> map = new HashMap<>();
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			if(result != null && result.size() > 0) {
				for(int i=2;i<result.size();i++) {
					List<String> datas = result.get(i);
					OutcontractSubcontractUnitPriceVO unitPriceVO = new OutcontractSubcontractUnitPriceVO();
					if(StringUtils.isEmpty(datas.get(0))) {
						unitPriceVO.setErrorMsg("清单编号不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(datas.get(0).length()<2) {
						unitPriceVO.setErrorMsg("清单编号不能低于2位数！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(1))) {
						unitPriceVO.setErrorMsg("项目不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(2))) {
						unitPriceVO.setErrorMsg("工作内容不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
					if(StringUtils.isEmpty(datas.get(3))) {
						unitPriceVO.setErrorMsg("项目特征不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
//					if(StringUtils.isEmpty(datas.get(5))) {
//						unitPriceVO.setErrorMsg("工程量不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(8))) {
//						unitPriceVO.setErrorMsg("人工费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(9))) {
//						unitPriceVO.setErrorMsg("主材费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(10))) {
//						unitPriceVO.setErrorMsg("材料损耗不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(11))) {
//						unitPriceVO.setErrorMsg("辅材费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(12))) {
//						unitPriceVO.setErrorMsg("机械费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(13))) {
//						unitPriceVO.setErrorMsg("管理费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(14))) {
//						unitPriceVO.setErrorMsg("利润不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(15))) {
//						unitPriceVO.setErrorMsg("规费不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
//					if(StringUtils.isEmpty(datas.get(16))) {
//						unitPriceVO.setErrorMsg("税金不能为空！");
//						errorList.add(unitPriceVO);
//						continue;
//					}
					if(StringUtils.isEmpty(datas.get(17))) {
						unitPriceVO.setErrorMsg("主材品牌不能为空！");
						errorList.add(unitPriceVO);
						continue;
					}
				    unitPriceVO.setListCode(datas.get(0)); // 清单编号
				    unitPriceVO.setInnercode(datas.get(0)); // 内码---为了单独区分装饰工程和建筑工程在咱们系统的表标识，装饰工程一律用a1代替
				    if("01".equals(datas.get(0))&&datas.get(1).contains("装饰")){
				    	unitPriceVO.setInnercode("a1");
				    }
				    //判断是否是装饰工程的子节点编码
				    if(datas.get(0).length()>=4){
				    	//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
				    	String code = datas.get(0).substring(0,4);
				    	if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
//				    		若是的话，将内码改为a1xx
				    		unitPriceVO.setInnercode(("a1"+datas.get(0).substring(2,datas.get(0).length())));
				    	}
				    }
				    unitPriceVO.setProject(datas.get(1)); // 项目
				    unitPriceVO.setJobContent(datas.get(2)); // 工作内容
				    unitPriceVO.setProjectCharacteristic(datas.get(3)); // 项目特征
				    unitPriceVO.setUnit(datas.get(4)); // 单位
				    unitPriceVO.setEngineeringQuantity(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 工程量
//				    unitPriceVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 综合单价
				    BigDecimal comprehensiveUnitPrice = new BigDecimal(0);
				    BigDecimal laborCost = StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null; // 人工费
				    BigDecimal mainMaterialCost = StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null; // 主材费
				    BigDecimal materialLoss = StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null; // 材料损耗
				    BigDecimal auxiliaryMaterialCost = StringUtils.isNotBlank(datas.get(11))?new BigDecimal(datas.get(11)):null; // 辅材费
				    BigDecimal machineryCost = StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null; // 机械费
				    BigDecimal managementCost = StringUtils.isNotBlank(datas.get(13))?new BigDecimal(datas.get(13)):null; // 管理费
				    BigDecimal profit = StringUtils.isNotBlank(datas.get(14))?new BigDecimal(datas.get(14)):null; // 利润
				    BigDecimal paidGovernmentCost = StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null; // 规费
				    BigDecimal tax = StringUtils.isNotBlank(datas.get(16))?new BigDecimal(datas.get(16)):null; // 税金
				    unitPriceVO.setLaborCost(laborCost); // 人工费
				    unitPriceVO.setMainMaterialCost(mainMaterialCost); // 主材费
				    unitPriceVO.setMaterialLoss(materialLoss); // 材料损耗
				    unitPriceVO.setAuxiliaryMaterialCost(auxiliaryMaterialCost); // 辅材费
				    unitPriceVO.setMachineryCost(machineryCost); // 机械费
				    unitPriceVO.setManagementCost(managementCost); // 管理费
				    unitPriceVO.setProfit(profit); // 利润
				    unitPriceVO.setPaidGovernmentCost(paidGovernmentCost); // 税金
				    unitPriceVO.setTax(tax); // 管理费
				    if(laborCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(laborCost);
				    }
				    if(mainMaterialCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(mainMaterialCost);
				    }
				    if(materialLoss!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(materialLoss);
				    }
				    if(auxiliaryMaterialCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(auxiliaryMaterialCost);
				    }
				    if(machineryCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(machineryCost);
				    }
				    if(managementCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(managementCost);
				    }
				    if(profit!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(profit);
				    }
				    if(paidGovernmentCost!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(paidGovernmentCost);
				    }
				    if(tax!=null){
				    	comprehensiveUnitPrice = comprehensiveUnitPrice.add(tax);
				    }
				    comprehensiveUnitPrice = comprehensiveUnitPrice.divide(new BigDecimal(9));
				    unitPriceVO.setComprehensiveUnitPrice(comprehensiveUnitPrice);
				    if(unitPriceVO.getEngineeringQuantity()!=null){
				    	//合计
				    	unitPriceVO.setTotalPrice(comprehensiveUnitPrice.multiply(unitPriceVO.getEngineeringQuantity()));
				    }
				    unitPriceVO.setMainMaterialBrand(datas.get(17)); // 主材品牌
				    unitPriceVO.setRemark(datas.get(18)); // 备注
				    unitPriceVO.setId(IdWorker.getId());
					successList.add(unitPriceVO);
					map.put(unitPriceVO.getInnercode(), unitPriceVO);
				}
			}
		}
		//建筑工程
		//装饰工程
		//设置父级id
		for(OutcontractSubcontractUnitPriceVO vo : successList){
			String innercode = vo.getInnercode();
			if(innercode.length()==2){
				//最上级
			}else if(innercode.length()==4){
				String pcode = innercode.substring(0, 2);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}else if(innercode.length()==6){
				String pcode = innercode.substring(0, 4);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}else if(innercode.length()>6){
				String pcode = innercode.substring(0, 6);
				//有父节点
				Long pid = this.setPid(pcode, map);
				vo.setPid(pid);
			}
		}
		//构建树
		List<OutcontractSubcontractUnitPriceVO> result = createTreeData(successList);
		//统计父级的合计数值
		BigDecimal subcontractUnitTotalAmount = this.getChildrenUnitTotalAmount(result); // 分包工程综合单价计价表合计金额
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", result);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		json.put("subcontractUnitTotalAmount", subcontractUnitTotalAmount);
		return CommonResponse.success(json);
	}
	
	private BigDecimal getChildrenUnitTotalAmount(List<OutcontractSubcontractUnitPriceVO> vos){
		BigDecimal subcontractUnitTotalAmount = new BigDecimal(0);
		for(OutcontractSubcontractUnitPriceVO vo: vos){
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				//有孩子节点----清空工程量和综合单价--金额字段
				vo.setEngineeringQuantity(null);
				vo.setComprehensiveUnitPrice(null);
				vo.setLaborCost(null); // 人工费
				vo.setMainMaterialCost(null); // 主材费
				vo.setMaterialLoss(null); // 材料损耗
				vo.setAuxiliaryMaterialCost(null); // 辅材费
			    vo.setMachineryCost(null); // 机械费
			    vo.setManagementCost(null); // 管理费
			    vo.setProfit(null); // 利润
			    vo.setPaidGovernmentCost(null); // 税金
			    vo.setTax(null); // 管理费
				//获取孩子节点的总计数据
			    BigDecimal childrenUnitTotalAmount = subcontractUnitTotalAmount.add(this.getChildrenUnitTotalAmount(vo.getChildren()));
			    vo.setTotalPrice(childrenUnitTotalAmount);
			    subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(childrenUnitTotalAmount);
			}else{
				if(vo.getTotalPrice()!=null){
					subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(vo.getTotalPrice());
				}
			}
		}
		return subcontractUnitTotalAmount;
	}
	
	//清单编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode,Map<String,OutcontractSubcontractUnitPriceVO> map){
		if(map.get(pcode)!=null){
			return map.get(pcode).getId();
		}else{
			//父级没有找到，则继续往上找
			if(pcode.length()==2){
				//最上级
				return null;
			}else if(pcode.length()==4){
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			}else if(pcode.length()==6){
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			}else if(pcode.length()>6){
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			}else{
				return null;
			}
		}
	}
	
	public static List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
		List<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(OutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	OutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	OutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OutcontractSubcontractUnitPriceVO> child = (List<OutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	/**
	 * excel导出数据库数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportUnitPriceFromDatabase", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportUnitPriceFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
		QueryWrapper<OutcontractSubcontractUnitPriceEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("outcontract_id", outcontractVO.getId());
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByAsc("list_code");
		List<OutcontractSubcontractUnitPriceEntity> list = outcontractSubcontractUnitPriceService.list(queryWrapper );
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
	}
	
	/**
	 * excel导出页面数据
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExportUnitPriceFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void excelExportUnitPriceFromPage(@RequestBody List<OutcontractSubcontractUnitPriceVO> list, HttpServletResponse response) {
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("outcontractSubcontractUnitPrice-export.xlsx", beans, response);
	}
	/********************分包工程综合单价计价表导入导出start**************/
}
