package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractReviewEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractReviewVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 分供方合同评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractReview")
public class OutcontractReviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String REVIEW_BILL_CODE = "ZJKJ-OUTCONTRACTREVIEW";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
	
    @Autowired
    private IOutcontractReviewService service;

    @Autowired
    private IOutcontractService outcontractService;	

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutcontractReviewVO> saveOrUpdate(@RequestBody OutcontractReviewVO saveOrUpdateVO) {
    	OutcontractReviewEntity entity = BeanMapper.map(saveOrUpdateVO, OutcontractReviewEntity.class);
    	entity.setId(saveOrUpdateVO.getOutcontractId());
    	if(StringUtils.isBlank(entity.getApprovalFormCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(REVIEW_BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setApprovalFormCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OutcontractReviewVO vo = BeanMapper.map(entity, OutcontractReviewVO.class);
    	vo.setProjectId(saveOrUpdateVO.getProjectId());
    	vo.setContractName(saveOrUpdateVO.getContractName());
    	vo.setBillCode(saveOrUpdateVO.getBillCode());
    	vo.setSupplier(saveOrUpdateVO.getSupplier());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutcontractReviewVO> queryDetail(Long id) {

    	QueryWrapper<OutcontractReviewEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("outcontract_id", id);
    	queryWrapper.eq("dr", 0);
    	List<OutcontractReviewEntity> entitys = service.list(queryWrapper);
    	OutcontractReviewVO vo = new OutcontractReviewVO();
    	if(entitys!=null&&entitys.size()>0){
    		vo = BeanMapper.map(entitys.get(0), OutcontractReviewVO.class);
    	}
    	vo.setId(id);
    	vo.setOutcontractId(id);
    	//查询项目信息
    	OutcontractEntity outcontractEntity = outcontractService.selectById(id);
    	vo.setProjectId(outcontractEntity.getProjectId());
    	vo.setContractName(outcontractEntity.getContractName());
    	vo.setBillCode(outcontractEntity.getBillCode());
    	vo.setSupplier(outcontractEntity.getSupplier());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractReviewVO> vos) {
        service.removeByIds(vos.stream().map(OutcontractReviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

}
