package com.ejianc.foundation.outcontract.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
@Service("outcontractService")
public class OutcontractServiceImpl extends BaseServiceImpl<OutcontractMapper, OutcontractEntity> implements IOutcontractService{

    @Autowired
    private IOutcontractReviewService reviewService; 
    
	@Override
	public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())){
        	reviewService.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
	}
    
}
