/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractMaterialService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialChangeExport"})
public class ExportChangeMaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IChangeOutcontractMaterialService changeoutcontractMaterialService;

    @RequestMapping(value={"/downloadMaterial"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractMaterial-import.xlsx", (String)"\u7269\u8d44\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeOutcontractMaterialVO> successList = new ArrayList<ChangeOutcontractMaterialVO>();
        ArrayList<ChangeOutcontractMaterialVO> errorList = new ArrayList<ChangeOutcontractMaterialVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal contractPriceTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                MaterialVO backVO;
                List datas = (List)result.get(i);
                ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();
                materialVO.setId(Long.valueOf(IdWorker.getId()));
                materialVO.setMaterialCode((String)datas.get(0));
                materialVO.setMaterialName((String)datas.get(1));
                materialVO.setStrengthGrade((String)datas.get(2));
                materialVO.setMaterialSpec((String)datas.get(3));
                materialVO.setBrandTrademark((String)datas.get(4));
                materialVO.setMaterialUnit((String)datas.get(5));
                materialVO.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                materialVO.setUntaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                materialVO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                materialVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                materialVO.setTotalPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                if (materialVO.getTaxUnitPrice() == null && materialVO.getUntaxUnitPrice() != null && materialVO.getTaxRate() != null) {
                    materialVO.setTotalPrice(materialVO.getUntaxUnitPrice().multiply(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100)))));
                }
                if (materialVO.getTotalPrice() == null && materialVO.getTaxUnitPrice() != null && materialVO.getQuantity() != null) {
                    materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity()));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVO.setErrorMsg("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                CommonResponse back = this.shareMaterialApi.queryMaterialByCode((String)datas.get(0));
                if (back.isSuccess()) {
                    backVO = (MaterialVO)back.getData();
                    if (backVO == null) {
                        materialVO.setErrorMsg("\u7269\u8d44\u6863\u6848\u4e0d\u5b58\u5728");
                        errorList.add(materialVO);
                        continue;
                    }
                } else {
                    materialVO.setErrorMsg("\u7269\u8d44\u6863\u6848\u6821\u9a8c\u5931\u8d25");
                    errorList.add(materialVO);
                    continue;
                }
                materialVO.setMaterialId(backVO.getId());
                materialVO.setMaterialName(backVO.getName());
                materialVO.setMaterialCategoryId(backVO.getCategoryId());
                materialVO.setMaterialCategoryName(backVO.getCategoryName());
                materialVO.setMaterialSpec(backVO.getSpec());
                materialVO.setMaterialUnit(backVO.getUnitName());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVO.setErrorMsg("\u5f3a\u5ea6\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    materialVO.setErrorMsg("\u54c1\u724c\u5546\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    materialVO.setErrorMsg("\u6682\u5b9a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    materialVO.setErrorMsg("\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    materialVO.setErrorMsg("\u7a0e\u91d1\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (materialVO.getTotalPrice() != null) {
                    contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
                }
                successList.add(materialVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("contractPriceTotalAmount", (Object)contractPriceTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMaterialFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changeoutcontractMaterialService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaterialFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
        HashMap<String, List<ChangeOutcontractMaterialVO>> beans = new HashMap<String, List<ChangeOutcontractMaterialVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadTurnoverMaterial"})
    @ResponseBody
    public void downloadTurnoverMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractTurnoverMaterial-import.xlsx", (String)"\u7269\u8d44\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportTurnoverMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTurnoverMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeOutcontractMaterialVO> successList = new ArrayList<ChangeOutcontractMaterialVO>();
        ArrayList<ChangeOutcontractMaterialVO> errorList = new ArrayList<ChangeOutcontractMaterialVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal contractPriceTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                MaterialVO backVO;
                List datas = (List)result.get(i);
                ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();
                materialVO.setId(Long.valueOf(IdWorker.getId()));
                materialVO.setMaterialCode((String)datas.get(0));
                materialVO.setMaterialName((String)datas.get(1));
                materialVO.setMaterialSpec((String)datas.get(2));
                materialVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                materialVO.setUntaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                materialVO.setMaterialUnit((String)datas.get(5));
                materialVO.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                materialVO.setLeaseTerm(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                materialVO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                materialVO.setTotalPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                if (materialVO.getTaxUnitPrice() == null && materialVO.getUntaxUnitPrice() != null && materialVO.getTaxRate() != null) {
                    materialVO.setTotalPrice(materialVO.getUntaxUnitPrice().multiply(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100)))));
                }
                if (materialVO.getTotalPrice() == null && materialVO.getTaxUnitPrice() != null && materialVO.getQuantity() != null && materialVO.getLeaseTerm() != null) {
                    materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity()).multiply(materialVO.getLeaseTerm()));
                }
                materialVO.setRemark((String)datas.get(10));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVO.setErrorMsg("\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                CommonResponse back = this.shareMaterialApi.queryMaterialByCode((String)datas.get(0));
                if (back.isSuccess()) {
                    backVO = (MaterialVO)back.getData();
                    if (backVO == null) {
                        materialVO.setErrorMsg("\u7269\u8d44\u6863\u6848\u4e0d\u5b58\u5728");
                        errorList.add(materialVO);
                        continue;
                    }
                } else {
                    materialVO.setErrorMsg("\u7269\u8d44\u6863\u6848\u6821\u9a8c\u5931\u8d25");
                    errorList.add(materialVO);
                    continue;
                }
                materialVO.setMaterialId(backVO.getId());
                materialVO.setMaterialName(backVO.getName());
                materialVO.setMaterialCategoryId(backVO.getCategoryId());
                materialVO.setMaterialCategoryName(backVO.getCategoryName());
                materialVO.setMaterialSpec(backVO.getSpec());
                materialVO.setMaterialUnit(backVO.getUnitName());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    materialVO.setErrorMsg("\u4e0d\u542b\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    materialVO.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    materialVO.setErrorMsg("\u79df\u8d41\u671f\uff08\u5929\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    materialVO.setErrorMsg("\u7a0e\u7387\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (materialVO.getTotalPrice() != null) {
                    contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
                }
                successList.add(materialVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("contractPriceTotalAmount", (Object)contractPriceTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportTurnoverMaterialFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changeoutcontractMaterialService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractTurnoverMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportTurnoverMaterialFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportTurnoverMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
        HashMap<String, List<ChangeOutcontractMaterialVO>> beans = new HashMap<String, List<ChangeOutcontractMaterialVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractTurnoverMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadOtherMaterial"})
    @ResponseBody
    public void downloadOtherMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"outcontractOtherMaterial-import.xlsx", (String)"\u5408\u540c\u4ef7\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportOtherMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportOtherMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeOutcontractMaterialVO> successList = new ArrayList<ChangeOutcontractMaterialVO>();
        ArrayList<ChangeOutcontractMaterialVO> errorList = new ArrayList<ChangeOutcontractMaterialVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        BigDecimal contractPriceTotalAmount = new BigDecimal(0);
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ChangeOutcontractMaterialVO materialVO = new ChangeOutcontractMaterialVO();
                materialVO.setId(Long.valueOf(IdWorker.getId()));
                materialVO.setMaterialName((String)datas.get(0));
                materialVO.setMaterialSpec((String)datas.get(1));
                materialVO.setUntaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : null);
                materialVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                materialVO.setMaterialUnit((String)datas.get(4));
                materialVO.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                materialVO.setTaxRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                materialVO.setTotalPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                if (materialVO.getTaxUnitPrice() == null && materialVO.getUntaxUnitPrice() != null && materialVO.getTaxRate() != null) {
                    materialVO.setTotalPrice(materialVO.getUntaxUnitPrice().multiply(new BigDecimal(1).add(materialVO.getTaxRate().divide(new BigDecimal(100)))));
                }
                if (materialVO.getTotalPrice() == null && materialVO.getTaxUnitPrice() != null && materialVO.getQuantity() != null) {
                    materialVO.setTotalPrice(materialVO.getTaxUnitPrice().multiply(materialVO.getQuantity()));
                }
                materialVO.setRemark((String)datas.get(8));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVO.setErrorMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    materialVO.setErrorMsg("\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVO.setErrorMsg("\u4e0d\u542b\u7a0e\u5355\u4ef7\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    materialVO.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    materialVO.setErrorMsg("\u7a0e\u91d1\uff08%\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialVO);
                    continue;
                }
                if (materialVO.getTotalPrice() != null) {
                    contractPriceTotalAmount = contractPriceTotalAmount.add(materialVO.getTotalPrice());
                }
                successList.add(materialVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("contractPriceTotalAmount", (Object)contractPriceTotalAmount);
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportOtherMaterialFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportOtherMaterialFromDatabase(@RequestBody OutcontractVO outcontractVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)outcontractVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changeoutcontractMaterialService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractOtherMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportOtherMaterialFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportOtherMaterialFromPage(@RequestBody List<ChangeOutcontractMaterialVO> list, HttpServletResponse response) {
        HashMap<String, List<ChangeOutcontractMaterialVO>> beans = new HashMap<String, List<ChangeOutcontractMaterialVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("outcontractOtherMaterial-export.xlsx", beans, response);
    }
}

