package com.ejianc.foundation.outcontract.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractReviewEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractReviewEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.mapper.ChangeOutcontractMapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.ChangeOutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 变更分供方合同
 * 
 * @author generator
 * 
 */
@Service("changeOutcontractService")
public class ChangeOutcontractServiceImpl extends BaseServiceImpl<ChangeOutcontractMapper, ChangeOutcontractEntity> implements IChangeOutcontractService{

    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IRecordOutcontractService outcontractRecordService;
    @Autowired
    private IChangeOutcontractReviewService changeOutcontractReviewService;
    
    @Autowired
    private IOutcontractReviewService outcontractReviewservice;
    
	@Override
	public CommonResponse<ChangeOutcontractVO> saveChange(ChangeOutcontractVO saveOrUpdateVO) {

		//检验该单据是否存在
		boolean exitBill = false;
		if(saveOrUpdateVO.getId()!=null){
			ChangeOutcontractEntity e = this.getById(saveOrUpdateVO);
			if(e!=null){
				exitBill = true;
			}
		}
		ChangeOutcontractEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeOutcontractEntity.class);
    	//检验是否存在未生效的变更单据，若存在，则不能变更
    	QueryWrapper<ChangeOutcontractEntity> queryWrapper = new QueryWrapper<ChangeOutcontractEntity>();
    	queryWrapper.eq("outcontract_id", saveOrUpdateVO.getOutcontractId());
    	queryWrapper.eq("dr", 0);
    	queryWrapper.in("bill_state", "[0,4]");
    	if(saveOrUpdateVO.getId()!=null){
    		queryWrapper.ne("id", saveOrUpdateVO.getId());
    	}
    	List<ChangeOutcontractEntity> exit = this.list(queryWrapper);
    	if(exit!=null&&exit.size()>0){
    		throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
    	}

    	//处理子表数据
        // 供方信息
    	if(saveOrUpdateVO.getChangeOutcontractSupplierList()!=null&&saveOrUpdateVO.getChangeOutcontractSupplierList().size()>0){
    		ChangeOutcontractSupplierVO outcontractSupplierVO = saveOrUpdateVO.getChangeOutcontractSupplierList().get(0);
    		entity.setSupplierName(outcontractSupplierVO.getSupplierName());// 分供商名称
    		entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());// 纳税人类型
    		entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());// 统一社会信用代码
    		entity.setSupplierBank(outcontractSupplierVO.getSupplierBank()); // 开户行
    		entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());; // 开户行账号
    		entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser()); // 联系人
    		entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress()); // 联系人地址
    		entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone()); // 联系人电话
    		entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail()); // 联系人邮箱
    		entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal()); // 法定代表人
    		entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone()); // 供方电话
    	}else{
    		entity.setSupplierName(null);// 分供商名称
    		entity.setSupplierTaxPayerType(null);// 纳税人类型
    		entity.setSupplierSocialCreditCode(null);// 统一社会信用代码
    		entity.setSupplierBank(null); // 开户行
    		entity.setSupplierBankAccount(null);; // 开户行账号
    		entity.setSupplierContactUser(null); // 联系人
    		entity.setSupplierContactUserAddress(null); // 联系人地址
    		entity.setSupplierContactUserPhone(null); // 联系人电话
    		entity.setSupplierContactUserEmail(null); // 联系人邮箱
    		entity.setSupplierLegal(null); // 法定代表人
    		entity.setSupplierTelephone(null); // 供方电话
    	}
    	this.saveOrUpdate(entity, false);
    	
		if(("劳务分包".equals(entity.getType())||"专业分包".equals(entity.getType()))&&!exitBill){
	    	//同步合同评审信息(新增时同步)
	    	ChangeOutcontractReviewEntity changeReviewEntity = new ChangeOutcontractReviewEntity();
	    	QueryWrapper<OutcontractReviewEntity> ReviewWrapper = new QueryWrapper<>();
	    	ReviewWrapper.eq("outcontract_id", entity.getOutcontractId());
	    	ReviewWrapper.eq("dr", 0);
	    	List<OutcontractReviewEntity> entitys = outcontractReviewservice.list(ReviewWrapper);
	    	if(entitys!=null&&entitys.size()>0){
	    		changeReviewEntity = BeanMapper.map(entitys.get(0), ChangeOutcontractReviewEntity.class);
	    		changeReviewEntity.setChangeOutcontractId(entity.getId());//默认和合同评审id一致
	        	changeReviewEntity.setCreateTime(null);
	        	changeReviewEntity.setCreateUserCode(null);
	        	changeReviewEntity.setTenantId(null);
	        	changeReviewEntity.setUpdateTime(null);
	        	changeReviewEntity.setUpdateUserCode(null);
	        	changeReviewEntity.setId(entity.getId());//默认和合同评审id一致
	        	changeOutcontractReviewService.saveOrUpdate(changeReviewEntity, false);
	    	}
		}
    	ChangeOutcontractVO vo = BeanMapper.map(entity, ChangeOutcontractVO.class);
    	vo.setChangeOutcontractSupplierList(saveOrUpdateVO.getChangeOutcontractSupplierList());
    	vo.setRecordOutcontractList(saveOrUpdateVO.getRecordOutcontractList());
    	if(vo.getChangeOutcontractSubcontractUnitPriceList()!=null&&vo.getChangeOutcontractSubcontractUnitPriceList().size()>0){
    		vo.setChangeOutcontractSubcontractUnitPriceList(createTreeData(vo.getChangeOutcontractSubcontractUnitPriceList()));
    	}
    	if(!exitBill){
        	//查询当前合同信息，将状态改为变更中
        	OutcontractEntity contractEntity = outcontractService.selectById(vo.getOutcontractId());
        	contractEntity.setChangeState("2");//状态改为变更中
        	contractEntity.setChangeId(vo.getId());
        	outcontractService.saveOrUpdate(contractEntity, false);
    	}
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}

	public static List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
		List<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(ChangeOutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ChangeOutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	ChangeOutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ChangeOutcontractSubcontractUnitPriceVO> child = (List<ChangeOutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

	@Override
	public CommonResponse<String> delete(List<ChangeOutcontractVO> vos) {
        for(ChangeOutcontractVO vo : vos){
        	ChangeOutcontractEntity entity = this.getById(vo.getId());
        	OutcontractEntity contractEntity = outcontractService.selectById(entity.getOutcontractId());
    		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("outcontract_id", entity.getId());
        	List<RecordOutcontractEntity> records = outcontractRecordService.list(queryWrapper);
        	if(records!=null&&records.size()>0){
        		contractEntity.setChangeState("3");//状态改为已变更
        	}else{
        		contractEntity.setChangeState("1");//状态改为未变更
        	}
        	contractEntity.setChangeId(null);
        	outcontractService.saveOrUpdate(contractEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
        	changeOutcontractReviewService.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
        }
		
        return CommonResponse.success("删除成功！");
	}
}
