package com.ejianc.foundation.outcontract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.outcontract.vo.ListFileVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.outcontract.mapper.ListFileMapper;
import com.ejianc.foundation.outcontract.bean.ListFileEntity;
import com.ejianc.foundation.outcontract.service.IListFileService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 清单档案
 * 
 * @author generator
 * 
 */
@Service("listFileService")
public class ListFileServiceImpl extends BaseServiceImpl<ListFileMapper, ListFileEntity> implements IListFileService{
    @Override
    public CommonResponse<ListFileVO> updateEn(ListFileVO saveorUpdateVO) {
        //修改子节点
        List<ListFileEntity> list = BeanMapper.mapList(getChildrenByPid(saveorUpdateVO.getId()),ListFileEntity.class);
        for (ListFileEntity entity : list) {
            entity.setState(saveorUpdateVO.getState());
        }
        saveOrUpdateBatch(list);

        return CommonResponse.success("修改成功！");
    }

    @Override
    public List<ListFileVO> getChildrenByPid(Long id) {
        ListFileEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<ListFileEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, ListFileVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        Map<String,ListFileVO> map = new HashMap<>();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //父子关系重复校验
                Map<String, Integer> indexMap = new HashMap<>();
                //父子关系虚拟主键映射
                List<ListFileVO> listFileVOList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                //编码重复校验
                List<String> excelCodeList = new ArrayList<>();
                //查询所有清单
                QueryParam queryParam = new QueryParam();
                List<String> codeList = new ArrayList<>();
                List<ListFileEntity> oldList = queryList(queryParam);
                for(ListFileEntity listFileEntity : oldList){
                    codeList.add(listFileEntity.getListCode());
                }
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ListFileVO listFileVO = new ListFileVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";
                    //编号
                    String listCode = datas.get(0);
                    listFileVO.setListCode(listCode);
                    //父编号
                    String parentCode = datas.get(1);
                    //维护父子关系(虚拟id)
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    //设置虚拟id
                    listFileVO.setTid(id);
                    //虚拟id映射
                    tidMap.put(listCode,id);
                    //设置虚拟父id
                    listFileVO.setTpid(parentCode);
                    listFileVO.setListCode(datas.get(0)); // 清单编号
                    listFileVO.setInnerCode(datas.get(0)); // 内码---为了单独区分装饰工程和建筑工程在咱们系统的表标识，装饰工程一律用a1代替
                    if("01".equals(datas.get(0))&&datas.get(2).contains("装饰")){
                        listFileVO.setInnerCode("a1");
                    }
                    //判断是否是装饰工程的子节点编码
                    if(datas.get(0).length()>=4){
                        //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                        String code = datas.get(0).substring(0,4);
                        if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
//				    		若是的话，将内码改为a1xx
                            listFileVO.setInnerCode(("a1"+datas.get(0).substring(2,datas.get(0).length())));
                        }
                    }
                    if(StringUtils.isEmpty(datas.get(0))) {
                        listFileVO.setListCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(datas.get(0))){
                            listFileVO.setListCode(datas.get(0));
                            warnType = warnType+"编码重复,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(datas.get(0).length()<2) {
                            listFileVO.setListCode(datas.get(0));
                            warnType = warnType+"清单编号不能低于2位数！,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(datas.get(0).length()==3 || datas.get(0).length()==5) {
                            listFileVO.setListCode(datas.get(0));
                            warnType = warnType+"清单编号规范错误！";
                            flag = true;
                            parentWarn = true;
                        }
                        if(excelCodeList.contains(datas.get(0))){
                            listFileVO.setListCode(datas.get(0));
                            warnType = warnType+"文件编码重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            excelCodeList.add(datas.get(0));
                        }
                        listFileVO.setListCode(datas.get(0));
                    }
                    String name = datas.get(2);
                    if(StringUtils.isEmpty(name)){
                        listFileVO.setListName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        listFileVO.setListName(name);
                    }
                    // true=可以导入，false=不可导入
                    listFileVO.setImportFlag(!flag);
                    listFileVO.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    listFileVO.setWarnType(warnType);
                    listFileVO.setRowState("add");
                    listFileVO.setShadowId(listFileVO.getTid());
                    listFileVO.setRemark(datas.get(3));
                    listFileVO.setState(1);
                    listFileVOList.add(listFileVO);
                    map.put(listFileVO.getInnerCode(), listFileVO);
                }
                //此处将之前存储的父级code转换为虚拟父级id
                for(ListFileVO tVo:listFileVOList){
                    if(StringUtils.isNotEmpty(tidMap.get(tVo.getTpid()))){
                        tVo.setTpid(tidMap.get(tVo.getTpid()));
                    }
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(listFileVOList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1),true);
                List<Map<String, Object>> successList=ExcelImportUtil.treeToList(allList.get(0),false);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ListFileVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<ListFileEntity> saveOrUpldates = BeanMapper.mapList(importVOS, ListFileEntity.class);
        saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        if (saveOrUpldates.size() > 0) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (ListFileEntity cdEntity : saveOrUpldates) {
                //存储虚拟id和真实id
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ListFileEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    //通过虚拟id父子关系存储真实导入id
                    if (idMap.get(cdEntity.getTpid()) == null) {
                        //tpid不为空且导入中不存在父子关系，查询已存在父id
                        LambdaQueryWrapper<ListFileEntity> lambda = Wrappers.<ListFileEntity>lambdaQuery();
                        lambda.eq(ListFileEntity::getListCode, cdEntity.getTpid());
                        ListFileEntity listFileEntity = getOne(lambda);
                        if(listFileEntity!=null){
                            cdEntity.setParentId(listFileEntity.getId());
                        }
                    } else {
                        //导入父子关系替换父id
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
            }
         /*   for (ListFileEntity listFileEntity : saveOrUpldates) {
                if (listFileEntity.getParentId() != null && listFileEntity.getParentId() > 0) {
                    ListFileEntity uniqueBean = baseMapper.selectById(listFileEntity.getParentId());
                    listFileEntity.setInnerCode(uniqueBean.getInnerCode() + "," + listFileEntity.getId());
                } else {
                    listFileEntity.setInnerCode(listFileEntity.getId().toString());
                }
                saveOrUpdate(listFileEntity);
            }*/
            saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        return "保存成功！";
    }
}
