package com.ejianc.foundation.outcontractDisclosure.service.impl;

import com.ejianc.foundation.outcontractDisclosure.bean.OutcontractDisclosureEntity;
import com.ejianc.foundation.outcontractDisclosure.service.IOutcontractDisclosureService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("outcontractDisclosure") 
public class OutcontractDisclosureBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IOutcontractDisclosureService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectApprovingByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个审批中的单据，不可提交！");
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
