/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryService;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryReportVO;
import com.ejianc.foundation.report.vo.OutcontractSignSummaryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontractSignSummaryService")
public class OutcontractSignSummaryServiceImpl
implements IOutcontractSignSummaryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ESSignSummary = "ejc_zjkj_outcontract_sign_summary";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
    @Autowired
    private RestHighLevelClient client;

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        OutcontractReportEntity reportEntity = new OutcontractReportEntity();
        reportEntity.setReportName(reportName);
        reportEntity.setReportType("\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
        String curDate = format2.format(new Date());
        reportEntity.setReportTime(curDate);
        Long reportId = IdWorker.getId();
        reportEntity.setId(reportId);
        this.outcontractReportService.saveOrUpdate((Object)reportEntity, false);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.outcontractService.queryList(queryParam);
        BulkRequest bulkRequest = new BulkRequest();
        for (OutcontractEntity entity : list) {
            try {
                OutcontractSignSummaryVO outcontractSignSummaryVO = (OutcontractSignSummaryVO)BeanMapper.map((Object)((Object)entity), OutcontractSignSummaryVO.class);
                Map dataMap = (Map)BeanMapper.map((Object)outcontractSignSummaryVO, Map.class);
                dataMap.put("reportId", reportId.toString());
                IndexRequest indexRequest = new IndexRequest(ESSignSummary);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u4f9b\u65b9\u5408\u540c\u7b7e\u7ea6\u7edf\u8ba1\u6c47\u603b\u8868\u6210\u529f");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public IPage<OutcontractSignSummaryReportVO> queryPage(QueryParam param) {
        Page page = new Page();
        ArrayList<OutcontractSignSummaryReportVO> resultList = new ArrayList<OutcontractSignSummaryReportVO>();
        Map params = param.getParams();
        if (params.get("range") != null && "es".equals(((Parameter)params.get("range")).getValue().toString())) {
            params.remove("range");
            SearchRequest searchRequest = new SearchRequest(new String[]{ESSignSummary});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            String reportId = ((Parameter)params.get("reportId")).getValue().toString();
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"reportId", (Object)reportId));
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
            try {
                List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                ArrayList commonOrgIds = new ArrayList();
                ArrayList departmentIds = new ArrayList();
                orgVOList.stream().forEach(org -> {
                    if (5 == org.getOrgType()) {
                        departmentIds.add(org.getId());
                    } else {
                        commonOrgIds.add(org.getId());
                    }
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", commonOrgIds));
                } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectDepartmentId", departmentIds));
                }
                TermsAggregationBuilder field = (TermsAggregationBuilder)AggregationBuilders.terms((String)"terms_id").field("orgId.keyword");
                sourceBuilder.aggregation((AggregationBuilder)field);
                Integer pageIndex = param.getPageIndex();
                Integer pageSize = param.getPageSize();
                sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
                sourceBuilder.size(pageSize.intValue());
                sourceBuilder.trackTotalHits(true);
                sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
                searchRequest.source(sourceBuilder);
                ArrayList<OutcontractSignSummaryReportVO> list = new ArrayList<OutcontractSignSummaryReportVO>();
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                ParsedStringTerms termsName = (ParsedStringTerms)response.getAggregations().get("terms_id");
                List buckets = termsName.getBuckets();
                for (Terms.Bucket name : buckets) {
                    OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
                    Integer num = (int)name.getDocCount();
                    String key = (String)name.getKey();
                    vo.setCompany(key);
                    list.add(vo);
                    this.logger.info("count , name , sum {} {} {}", (Object)num, (Object)key);
                }
                for (OutcontractSignSummaryReportVO vo : list) {
                    resultList.add(this.selectOrg(reportId, vo.getCompany()));
                }
                page.setRecords(resultList);
            }
            catch (Exception e2) {
                throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e2);
            }
        } else {
            if (params.get("range") != null) {
                params.remove("range");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"org_id"});
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
            queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.groupBy((Object[])new String[]{"org_id"});
            List entityList = this.outcontractService.list((Wrapper)queryWrapper);
            entityList.forEach(e -> resultList.add(this.processData(e.getOrgId())));
            page = new Page(page.getCurrent(), (long)param.getPageSize(), (long)resultList.size());
            page.setRecords(resultList);
        }
        return page;
    }

    public OutcontractSignSummaryReportVO processData(Long orgId) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List entities = this.outcontractService.queryList(queryParam);
        List vos = BeanMapper.mapList((Iterable)entities, OutcontractVO.class);
        if (vos.size() > 0) {
            vo.setCompany(((OutcontractVO)vos.get(0)).getOrgName());
            vo.setSumContract(vos.size());
            vo.setSumSubcontractingContent(vos.size());
        }
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u52b3\u52a1\u5206\u5305"));
        List list0 = this.outcontractService.queryList(queryParam);
        List vos1 = BeanMapper.mapList((Iterable)list0, OutcontractVO.class);
        vos1.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getLaborPrice() == null) {
                        vo.setLaborPrice(0);
                    }
                    vo.setLaborPrice(vo.getLaborPrice() + 1);
                    break;
                }
                case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getLaborArea() == null) {
                        vo.setLaborArea(0);
                    }
                    vo.setLaborArea(vo.getLaborArea() + 1);
                    break;
                }
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getLaborFixedPrice() == null) {
                        vo.setLaborFixedPrice(0);
                    }
                    vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                    break;
                }
                case "\u56fa\u5b9a\u603b\u4ef7": {
                    if (vo.getLaborTotalPrice() == null) {
                        vo.setLaborTotalPrice(0);
                    }
                    vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                    break;
                }
                case "\u5b9a\u989d\u8ba1\u4ef7": {
                    if (vo.getLaborQuotaValuation() == null) {
                        vo.setLaborQuotaValuation(0);
                    }
                    vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u4e13\u4e1a\u5206\u5305"));
        List list1 = this.outcontractService.queryList(queryParam);
        List vos2 = BeanMapper.mapList((Iterable)list1, OutcontractVO.class);
        vos2.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getMajorPrice() == null) {
                        vo.setMajorPrice(0);
                    }
                    vo.setMajorPrice(vo.getMajorPrice() + 1);
                    break;
                }
                case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                    if (vo.getRateLower() == null) {
                        vo.setRateLower(0);
                    }
                    vo.setRateLower(vo.getRateLower() + 1);
                    break;
                }
                case "\u56fa\u5b9a\u603b\u4ef7": {
                    if (vo.getMajorTotalPrice() == null) {
                        vo.setMajorTotalPrice(0);
                    }
                    vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                    break;
                }
                case "\u5b9a\u989d\u8ba1\u4ef7": {
                    if (vo.getMajorQuotaValuation() == null) {
                        vo.setMajorQuotaValuation(0);
                    }
                    vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u7269\u8d44\u91c7\u8d2d"));
        List list2 = this.outcontractService.queryList(queryParam);
        List vos3 = BeanMapper.mapList((Iterable)list2, OutcontractVO.class);
        vos3.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getMaterialFixedPrice() == null) {
                        vo.setMaterialFixedPrice(0);
                    }
                    vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                    break;
                }
                case "\u53ef\u8c03\u4ef7\u683c": {
                    if (vo.getAdjustablePrice() == null) {
                        vo.setAdjustablePrice(0);
                    }
                    vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u673a\u68b0\u79df\u8d41"));
        List list3 = this.outcontractService.queryList(queryParam);
        List vos4 = BeanMapper.mapList((Iterable)list3, OutcontractVO.class);
        vos4.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getEquipmentFixedPrice() == null) {
                        vo.setEquipmentFixedPrice(0);
                    }
                    vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                    break;
                }
                case "\u5176\u4ed6": {
                    if (vo.getEquipmentOther() == null) {
                        vo.setEquipmentOther(0);
                    }
                    vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u5468\u8f6c\u6750\u79df\u8d41"));
        List list4 = this.outcontractService.queryList(queryParam);
        List vos5 = BeanMapper.mapList((Iterable)list4, OutcontractVO.class);
        vos5.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getTurnoverMaterialFixedPrice() == null) {
                        vo.setTurnoverMaterialFixedPrice(0);
                    }
                    vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                    break;
                }
                case "\u5176\u4ed6": {
                    if (vo.getTurnoverMaterialOther() == null) {
                        vo.setTurnoverMaterialOther(0);
                    }
                    vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u8bbe\u8ba1\u52d8\u5bdf"));
        List list5 = this.outcontractService.queryList(queryParam);
        List vos6 = BeanMapper.mapList((Iterable)list5, OutcontractVO.class);
        vos6.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getDesignFixedPrice() == null) {
                        vo.setDesignFixedPrice(0);
                    }
                    vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                    break;
                }
                case "\u5176\u4ed6": {
                    if (vo.getDesignOther() == null) {
                        vo.setDesignOther(0);
                    }
                    vo.setDesignOther(vo.getDesignOther() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u54a8\u8be2\u670d\u52a1"));
        List list6 = this.outcontractService.queryList(queryParam);
        List vos7 = BeanMapper.mapList((Iterable)list6, OutcontractVO.class);
        vos7.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getConsultancyFixedPrice() == null) {
                        vo.setConsultancyFixedPrice(0);
                    }
                    vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                    break;
                }
                case "\u5176\u4ed6": {
                    if (vo.getConsultancyOther() == null) {
                        vo.setConsultancyOther(0);
                    }
                    vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                }
            }
        });
        queryParam.getParams().put("type", new Parameter("eq", (Object)"\u5176\u5b83\u5408\u540c"));
        List list7 = this.outcontractService.queryList(queryParam);
        List vos8 = BeanMapper.mapList((Iterable)list7, OutcontractVO.class);
        vos8.forEach(e -> {
            switch (e.getPricingForm()) {
                case "\u56fa\u5b9a\u5355\u4ef7": {
                    if (vo.getOtherFixedPrice() == null) {
                        vo.setOtherFixedPrice(0);
                    }
                    vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                    break;
                }
                case "\u5176\u4ed6": {
                    if (vo.getOther1() == null) {
                        vo.setOther1(0);
                    }
                    vo.setOther1(vo.getOther1() + 1);
                }
            }
        });
        queryParam.getParams().remove("type");
        vo.setLabor(list0.size());
        vo.setMajor(list1.size());
        vo.setMaterial(list2.size());
        vo.setEquipment(list3.size());
        vo.setTurnoverMaterial(list4.size());
        vo.setDesign(list5.size());
        vo.setConsultancy(list6.size());
        vo.setOther(list7.size());
        queryParam.getParams().put("laborSubcontracteMode", new Parameter("eq", (Object)"\u5305\u8f7b\u5de5"));
        List list8 = this.outcontractService.queryList(queryParam);
        vo.setPackLight(list8.size());
        queryParam.getParams().put("laborSubcontracteMode", new Parameter("eq", (Object)"\u8f7b\u5de5\u8f85\u6599\u5c0f\u578b\u673a\u68b0"));
        List list9 = this.outcontractService.queryList(queryParam);
        vo.setSmallMechanical(list9.size());
        queryParam.getParams().put("laborSubcontracteMode", new Parameter("eq", (Object)"\u6269\u5927\u52b3\u52a1\u5206\u5305"));
        List list10 = this.outcontractService.queryList(queryParam);
        vo.setExpandSub(list10.size());
        queryParam.getParams().put("laborSubcontracteMode", new Parameter("eq", (Object)"\u5176\u4ed6\u5f62\u5f0f"));
        List list11 = this.outcontractService.queryList(queryParam);
        vo.setOtherform(list11.size());
        Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
        Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
        vo.setSumLaborSubcontracteMode(Integer.sum(a, b));
        vo.setSumLabor(list0.size());
        vo.setSumMajor(list1.size());
        vo.setSumMaterial(list2.size());
        vo.setSumEquipment(list3.size());
        vo.setSumTurnoverMaterial(list4.size());
        vo.setSumDesign(list5.size());
        vo.setSumConsultancy(list6.size());
        vo.setSumOther(list7.size());
        return vo;
    }

    public OutcontractSignSummaryReportVO selectOrg(String reportId, String orgId) {
        OutcontractSignSummaryReportVO vo = new OutcontractSignSummaryReportVO();
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignSummary});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"reportId", (Object)reportId));
        boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
        try {
            List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (String[])new String[]{orgId}));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectDepartmentId", departmentIds));
            }
            sourceBuilder.query((QueryBuilder)boolQuery);
            CountRequest count = new CountRequest(new String[]{ESSignSummary});
            count.query((QueryBuilder)boolQuery);
            CountResponse countResponse = this.client.count(count, RequestOptions.DEFAULT);
            sourceBuilder.query((QueryBuilder)boolQuery);
            sourceBuilder.from(0);
            sourceBuilder.size((int)countResponse.getCount());
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
            searchRequest.source(sourceBuilder);
            TermsAggregationBuilder field = (TermsAggregationBuilder)AggregationBuilders.terms((String)"terms_id").script(new Script("doc['orgName.keyword'] +'#'+doc['type.keyword']+'#'+doc['laborSubcontracteMode.keyword']+'#'+doc['pricingForm.keyword']"));
            sourceBuilder.aggregation((AggregationBuilder)field);
            ArrayList<OutcontractSignSummaryReportVO> list = new ArrayList<OutcontractSignSummaryReportVO>();
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            ParsedStringTerms termsName = (ParsedStringTerms)response.getAggregations().get("terms_id");
            List buckets = termsName.getBuckets();
            for (Terms.Bucket name : buckets) {
                OutcontractSignSummaryReportVO vos = new OutcontractSignSummaryReportVO();
                String[] arr = name.getKeyAsString().split("#");
                vos.setCompany(arr[0].replace("[", "").replace("]", ""));
                vos.setType(arr[1].replace("[", "").replace("]", ""));
                vos.setLaborSubcontracteMode(arr[2].replace("[", "").replace("]", ""));
                vos.setPricingForm(arr[3].replace("[", "").replace("]", ""));
                list.add(vos);
            }
            if (list.size() > 0) {
                vo.setCompany(((OutcontractSignSummaryReportVO)list.get(0)).getCompany());
                vo.setSumContract(list.size());
                vo.setSumSubcontractingContent(list.size());
            }
            for (OutcontractSignSummaryReportVO e2 : list) {
                switch (e2.getLaborSubcontracteMode()) {
                    case "\u5305\u8f7b\u5de5": {
                        if (vo.getPackLight() == null) {
                            vo.setPackLight(0);
                        }
                        vo.setPackLight(vo.getPackLight() + 1);
                        break;
                    }
                    case "\u8f7b\u5de5\u8f85\u6599\u5c0f\u578b\u673a\u68b0": {
                        if (vo.getSmallMechanical() == null) {
                            vo.setSmallMechanical(0);
                        }
                        vo.setSmallMechanical(vo.getSmallMechanical() + 1);
                        break;
                    }
                    case "\u6269\u5927\u52b3\u52a1\u5206\u5305": {
                        if (vo.getExpandSub() == null) {
                            vo.setExpandSub(0);
                        }
                        vo.setExpandSub(vo.getExpandSub() + 1);
                        break;
                    }
                    case "\u5176\u4ed6\u5f62\u5f0f": {
                        if (vo.getOtherform() == null) {
                            vo.setOtherform(0);
                        }
                        vo.setOtherform(vo.getOtherform() + 1);
                    }
                }
            }
            list.forEach(e -> {
                if ("\u52b3\u52a1\u5206\u5305".equals(e.getType())) {
                    if (vo.getLabor() == null) {
                        vo.setLabor(0);
                    }
                    vo.setLabor(vo.getLabor() + 1);
                    if (vo.getSumLabor() == null) {
                        vo.setSumLabor(0);
                    }
                    vo.setSumLabor(vo.getSumLabor() + 1);
                    switch (e.getPricingForm()) {
                        case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getLaborPrice() == null) {
                                vo.setLaborPrice(0);
                            }
                            vo.setLaborPrice(vo.getLaborPrice() + 1);
                            break;
                        }
                        case "\u6309\u5efa\u7b51\u9762\u79ef\u5e73\u7c73\u7684\u6bcf\u5e73\u7c73\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getLaborArea() == null) {
                                vo.setLaborArea(0);
                            }
                            vo.setLaborArea(vo.getLaborArea() + 1);
                            break;
                        }
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getLaborFixedPrice() == null) {
                                vo.setLaborFixedPrice(0);
                            }
                            vo.setLaborFixedPrice(vo.getLaborFixedPrice() + 1);
                            break;
                        }
                        case "\u56fa\u5b9a\u603b\u4ef7": {
                            if (vo.getLaborTotalPrice() == null) {
                                vo.setLaborTotalPrice(0);
                            }
                            vo.setLaborTotalPrice(vo.getLaborTotalPrice() + 1);
                            break;
                        }
                        case "\u5b9a\u989d\u8ba1\u4ef7": {
                            if (vo.getLaborQuotaValuation() == null) {
                                vo.setLaborQuotaValuation(0);
                            }
                            vo.setLaborQuotaValuation(vo.getLaborQuotaValuation() + 1);
                        }
                    }
                }
                if ("\u4e13\u4e1a\u5206\u5305".equals(e.getType())) {
                    if (vo.getMajor() == null) {
                        vo.setMajor(0);
                    }
                    vo.setMajor(vo.getMajor() + 1);
                    if (vo.getSumMajor() == null) {
                        vo.setSumMajor(0);
                    }
                    vo.setSumMajor(vo.getSumMajor() + 1);
                    switch (e.getPricingForm()) {
                        case "\u6309\u5b9e\u4f53\u5de5\u7a0b\u91cf\u5bf9\u5e94\u7684\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getMajorPrice() == null) {
                                vo.setMajorPrice(0);
                            }
                            vo.setMajorPrice(vo.getMajorPrice() + 1);
                            break;
                        }
                        case "\u6309\u627f\u5305\u5408\u540c\u4ef7\u6b3e\u8ba9\u5229\u8d39\u7387\u4e0b\u6d6e": {
                            if (vo.getRateLower() == null) {
                                vo.setRateLower(0);
                            }
                            vo.setRateLower(vo.getRateLower() + 1);
                            break;
                        }
                        case "\u56fa\u5b9a\u603b\u4ef7": {
                            if (vo.getMajorTotalPrice() == null) {
                                vo.setMajorTotalPrice(0);
                            }
                            vo.setMajorTotalPrice(vo.getMajorTotalPrice() + 1);
                            break;
                        }
                        case "\u5b9a\u989d\u8ba1\u4ef7": {
                            if (vo.getMajorQuotaValuation() == null) {
                                vo.setMajorQuotaValuation(0);
                            }
                            vo.setMajorQuotaValuation(vo.getMajorQuotaValuation() + 1);
                        }
                    }
                }
                if ("\u7269\u8d44\u91c7\u8d2d".equals(e.getType())) {
                    if (vo.getMaterial() == null) {
                        vo.setMaterial(0);
                    }
                    vo.setMaterial(vo.getMaterial() + 1);
                    if (vo.getSumMaterial() == null) {
                        vo.setSumMaterial(0);
                    }
                    vo.setSumMaterial(vo.getSumMaterial() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getMaterialFixedPrice() == null) {
                                vo.setMaterialFixedPrice(0);
                            }
                            vo.setMaterialFixedPrice(vo.getMaterialFixedPrice() + 1);
                            break;
                        }
                        case "\u53ef\u8c03\u4ef7\u683c": {
                            if (vo.getAdjustablePrice() == null) {
                                vo.setAdjustablePrice(0);
                            }
                            vo.setAdjustablePrice(vo.getAdjustablePrice() + 1);
                        }
                    }
                }
                if ("\u673a\u68b0\u79df\u8d41".equals(e.getType())) {
                    if (vo.getEquipment() == null) {
                        vo.setEquipment(0);
                    }
                    vo.setEquipment(vo.getEquipment() + 1);
                    if (vo.getSumEquipment() == null) {
                        vo.setSumEquipment(0);
                    }
                    vo.setSumEquipment(vo.getSumEquipment() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getEquipmentFixedPrice() == null) {
                                vo.setEquipmentFixedPrice(0);
                            }
                            vo.setEquipmentFixedPrice(vo.getEquipmentFixedPrice() + 1);
                            break;
                        }
                        case "\u5176\u4ed6": {
                            if (vo.getEquipmentOther() == null) {
                                vo.setEquipmentOther(0);
                            }
                            vo.setEquipmentOther(vo.getEquipmentOther() + 1);
                        }
                    }
                }
                if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(e.getType())) {
                    if (vo.getTurnoverMaterial() == null) {
                        vo.setTurnoverMaterial(0);
                    }
                    vo.setTurnoverMaterial(vo.getTurnoverMaterial() + 1);
                    if (vo.getSumTurnoverMaterial() == null) {
                        vo.setSumTurnoverMaterial(0);
                    }
                    vo.setSumTurnoverMaterial(vo.getSumTurnoverMaterial() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getTurnoverMaterialFixedPrice() == null) {
                                vo.setTurnoverMaterialFixedPrice(0);
                            }
                            vo.setTurnoverMaterialFixedPrice(vo.getTurnoverMaterialFixedPrice() + 1);
                            break;
                        }
                        case "\u5176\u4ed6": {
                            if (vo.getTurnoverMaterialOther() == null) {
                                vo.setTurnoverMaterialOther(0);
                            }
                            vo.setTurnoverMaterialOther(vo.getTurnoverMaterialOther() + 1);
                        }
                    }
                }
                if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(e.getType())) {
                    if (vo.getDesign() == null) {
                        vo.setDesign(0);
                    }
                    vo.setDesign(vo.getDesign() + 1);
                    if (vo.getSumDesign() == null) {
                        vo.setSumDesign(0);
                    }
                    vo.setSumDesign(vo.getSumDesign() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getDesignFixedPrice() == null) {
                                vo.setDesignFixedPrice(0);
                            }
                            vo.setDesignFixedPrice(vo.getDesignFixedPrice() + 1);
                            break;
                        }
                        case "\u5176\u4ed6": {
                            if (vo.getDesignOther() == null) {
                                vo.setDesignOther(0);
                            }
                            vo.setDesignOther(vo.getDesignOther() + 1);
                        }
                    }
                }
                if ("\u54a8\u8be2\u670d\u52a1".equals(e.getType())) {
                    if (vo.getConsultancy() == null) {
                        vo.setConsultancy(0);
                    }
                    vo.setConsultancy(vo.getConsultancy() + 1);
                    if (vo.getSumConsultancy() == null) {
                        vo.setSumConsultancy(0);
                    }
                    vo.setSumConsultancy(vo.getSumConsultancy() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getConsultancyFixedPrice() == null) {
                                vo.setConsultancyFixedPrice(0);
                            }
                            vo.setConsultancyFixedPrice(vo.getConsultancyFixedPrice() + 1);
                            break;
                        }
                        case "\u5176\u4ed6": {
                            if (vo.getConsultancyOther() == null) {
                                vo.setConsultancyOther(0);
                            }
                            vo.setConsultancyOther(vo.getConsultancyOther() + 1);
                        }
                    }
                }
                if ("\u5176\u5b83\u5408\u540c".equals(e.getType())) {
                    if (vo.getOther() == null) {
                        vo.setOther(0);
                    }
                    vo.setOther(vo.getOther() + 1);
                    if (vo.getSumOther() == null) {
                        vo.setSumOther(0);
                    }
                    vo.setSumOther(vo.getSumOther() + 1);
                    switch (e.getPricingForm()) {
                        case "\u56fa\u5b9a\u5355\u4ef7": {
                            if (vo.getOtherFixedPrice() == null) {
                                vo.setOtherFixedPrice(0);
                            }
                            vo.setOtherFixedPrice(vo.getOtherFixedPrice() + 1);
                            break;
                        }
                        case "\u5176\u4ed6": {
                            if (vo.getOther1() == null) {
                                vo.setOther1(0);
                            }
                            vo.setOther1(vo.getOther1() + 1);
                        }
                    }
                }
            });
            if (vo.getPackLight() == null) {
                vo.setPackLight(0);
            }
            if (vo.getSmallMechanical() == null) {
                vo.setSmallMechanical(0);
            }
            if (vo.getExpandSub() == null) {
                vo.setExpandSub(0);
            }
            if (vo.getOtherform() == null) {
                vo.setOtherform(0);
            }
            Integer a = Integer.sum(vo.getPackLight(), vo.getSmallMechanical());
            Integer b = Integer.sum(vo.getExpandSub(), vo.getOtherform());
            vo.setSumLaborSubcontracteMode(Integer.sum(a, b));
        }
        catch (Exception e3) {
            throw new BusinessException("\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a", (Throwable)e3);
        }
        return vo;
    }
}

