/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.service.IOutcontractMaterialService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractEquipmentRentVO;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outcontract"})
public class OutcontractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String LABOROUTCONTRACT_BILL_CODE = "ZJKJ-LABOROUTCONTRACT";
    private static final String MAJOROUTCONTRACT_BILL_CODE = "ZJKJ-MAJOROUTCONTRACT";
    private static final String MATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-MATERIALOUTCONTRACT";
    private static final String EQUIPMENTOUTCONTRACT_BILL_CODE = "ZJKJ-EQUIPMENTOUTCONTRACT";
    private static final String TURNOVERMATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-TURNOVERMATERIALOUTCONTRACT";
    private static final String DESIGNOUTCONTRACT_BILL_CODE = "ZJKJ-DESIGNOUTCONTRACT";
    private static final String CONSULTANCYOUTCONTRACT_BILL_CODE = "ZJKJ-CONSULTANCYOUTCONTRACT";
    private static final String OTHEROUTCONTRACT = "ZJKJ-OTHEROUTCONTRACT";
    @Autowired
    private IOutcontractService service;
    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;
    @Autowired
    private IOutcontractMaterialService outcontractMaterialService;
    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractVO> saveOrUpdate(@RequestBody OutcontractVO saveOrUpdateVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutcontractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String code = "";
            entity.setChangeState("1");
            if ("\u52b3\u52a1\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = LABOROUTCONTRACT_BILL_CODE;
            } else if ("\u4e13\u4e1a\u5206\u5305".equals(saveOrUpdateVO.getType())) {
                code = MAJOROUTCONTRACT_BILL_CODE;
            } else if ("\u7269\u8d44\u91c7\u8d2d".equals(saveOrUpdateVO.getType())) {
                code = MATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u673a\u68b0\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = EQUIPMENTOUTCONTRACT_BILL_CODE;
            } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(saveOrUpdateVO.getType())) {
                code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
            } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(saveOrUpdateVO.getType())) {
                code = DESIGNOUTCONTRACT_BILL_CODE;
            } else if ("\u54a8\u8be2\u670d\u52a1".equals(saveOrUpdateVO.getType())) {
                code = CONSULTANCYOUTCONTRACT_BILL_CODE;
            } else if ("\u5176\u5b83\u5408\u540c".equals(saveOrUpdateVO.getType())) {
                code = OTHEROUTCONTRACT;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)code, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getOutcontractSupplierList() != null && saveOrUpdateVO.getOutcontractSupplierList().size() > 0) {
            OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)saveOrUpdateVO.getOutcontractSupplierList().get(0);
            entity.setSupplierName(outcontractSupplierVO.getSupplierName());
            entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());
            entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());
            entity.setSupplierBank(outcontractSupplierVO.getSupplierBank());
            entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());
            entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser());
            entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress());
            entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone());
            entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail());
            entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal());
            entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone());
        } else {
            entity.setSupplierName(null);
            entity.setSupplierTaxPayerType(null);
            entity.setSupplierSocialCreditCode(null);
            entity.setSupplierBank(null);
            entity.setSupplierBankAccount(null);
            entity.setSupplierContactUser(null);
            entity.setSupplierContactUserAddress(null);
            entity.setSupplierContactUserPhone(null);
            entity.setSupplierContactUserEmail(null);
            entity.setSupplierLegal(null);
            entity.setSupplierTelephone(null);
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        vo.setOutcontractSupplierList(saveOrUpdateVO.getOutcontractSupplierList());
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutcontractVO> queryDetail(Long id) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(id));
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        ArrayList<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<OutcontractSupplierVO>();
        OutcontractSupplierVO outcontractSupplierVO = (OutcontractSupplierVO)BeanMapper.map((Object)((Object)entity), OutcontractSupplierVO.class);
        outcontractSupplierVO.setRowState("add");
        outcontractSupplierList.add(outcontractSupplierVO);
        vo.setOutcontractSupplierList(outcontractSupplierList);
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"outcontract_id", (Object)vo.getId());
            List records = this.recordOutcontractService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordOutcontractList(BeanMapper.mapList((Iterable)records, RecordOutcontractVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
        fuzzyFields.add("subcontractingContent");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        if (param.getParams() != null && param.getParams().get("advanceCharge") != null) {
            if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)param.getParams().get("advanceCharge")).getValue())) {
                param.getParams().put("advanceCharge", new Parameter("ne", null));
            } else {
                param.getParams().put("advanceCharge", new Parameter("eq", null));
            }
        }
        if (param.getParams() != null && param.getParams().get("progressPaymentTerms") != null) {
            ComplexParam c11;
            ComplexParam c1;
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                param.getParams().put("monthlyPayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().put("nodePayment", new Parameter("gt", (Object)0));
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70\u4ee5\u4e0b")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c11);
                ComplexParam c12 = new ComplexParam();
                c12.setLogic("or");
                c12.getParams().put("nodePayment", new Parameter("lt", (Object)70));
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("70-75")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                ComplexParam c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)70));
                c11.getComplexParams().add(c111);
                ComplexParam c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)75));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                ComplexParam c12 = new ComplexParam();
                c12.setLogic("or");
                ComplexParam c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)70));
                c12.getComplexParams().add(c121);
                ComplexParam c122 = new ComplexParam();
                c122.setLogic("and");
                c122.getParams().put("nodePayment", new Parameter("lt", (Object)75));
                c12.getComplexParams().add(c122);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("75-80")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                ComplexParam c111 = new ComplexParam();
                c111.setLogic("and");
                c111.getParams().put("monthlyPayment", new Parameter("ge", (Object)75));
                c11.getComplexParams().add(c111);
                ComplexParam c112 = new ComplexParam();
                c112.setLogic("and");
                c112.getParams().put("monthlyPayment", new Parameter("lt", (Object)80));
                c11.getComplexParams().add(c112);
                c1.getComplexParams().add(c11);
                ComplexParam c12 = new ComplexParam();
                c12.setLogic("or");
                ComplexParam c121 = new ComplexParam();
                c121.setLogic("and");
                c121.getParams().put("nodePayment", new Parameter("ge", (Object)75));
                c12.getComplexParams().add(c121);
                ComplexParam c122 = new ComplexParam();
                c122.setLogic("and");
                c122.getParams().put("nodePayment", new Parameter("lt", (Object)80));
                c12.getComplexParams().add(c122);
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            } else if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("80\u4ee5\u4e0a")) {
                c1 = new ComplexParam();
                c1.setLogic("and");
                c11 = new ComplexParam();
                c11.setLogic("or");
                c11.getParams().put("monthlyPayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c11);
                ComplexParam c12 = new ComplexParam();
                c12.setLogic("or");
                c12.getParams().put("nodePayment", new Parameter("ge", (Object)80));
                c1.getComplexParams().add(c12);
                param.getComplexParams().add(c1);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
        fuzzyFields.add("subcontractingContent");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams() != null && param.getParams().get("advanceCharge") != null) {
            if ("\u6709\u9884\u4ed8\u6b3e".equals(((Parameter)param.getParams().get("advanceCharge")).getValue())) {
                param.getParams().put("advanceCharge", new Parameter("ne", null));
            } else {
                param.getParams().put("advanceCharge", new Parameter("eq", null));
            }
        }
        if (param.getParams() != null && param.getParams().get("progressPaymentTerms") != null) {
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u6708\u5ea6\u4ed8\u6b3e")) {
                param.getParams().put("monthlyPayment", new Parameter("gt", (Object)0));
            }
            if (((Parameter)param.getParams().get("progressPaymentTerms")).getValue().toString().contains("\u8282\u70b9\u4ed8\u6b3e")) {
                param.getParams().put("nodePayment", new Parameter("gt", (Object)0));
            }
            param.getParams().remove("progressPaymentTerms");
        }
        List list = this.service.queryList(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        ArrayList<OutcontractVO> vos = new ArrayList<OutcontractVO>();
        String type = "";
        String templateName = "\u627f\u5305\u5408\u540c\u4fe1\u606f";
        String exportXlsx = "outcontract-export.xlsx";
        if (param.getParams() != null && param.getParams().get("type") != null) {
            type = ((Parameter)param.getParams().get("type")).getValue().toString();
        }
        if ("\u52b3\u52a1\u5206\u5305".equals(type)) {
            templateName = "\u52b3\u52a1\u5206\u5305\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u4e13\u4e1a\u5206\u5305".equals(type)) {
            templateName = "\u4e13\u4e1a\u5206\u5305\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u7269\u8d44\u91c7\u8d2d".equals(type)) {
            templateName = "\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u673a\u68b0\u79df\u8d41".equals(type)) {
            templateName = "\u673a\u68b0\u79df\u8d41\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u5468\u8f6c\u6750\u79df\u8d41".equals(type)) {
            templateName = "\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export1.xlsx";
        } else if ("\u8bbe\u8ba1\u52d8\u5bdf".equals(type)) {
            templateName = "\u8bbe\u8ba1\u52d8\u5bdf\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u54a8\u8be2\u670d\u52a1".equals(type)) {
            templateName = "\u54a8\u8be2\u670d\u52a1\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        } else if ("\u5176\u5b83\u5408\u540c".equals(type)) {
            templateName = "\u5176\u5b83\u5408\u540c\u4fe1\u606f";
            exportXlsx = "outcontract-export.xlsx";
        }
        for (OutcontractEntity entity : list) {
            OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
            if (vo.getSignDate() != null) {
                vo.setSignDateShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getSignDate()));
            }
            if (vo.getChangeState() != null) {
                if ("1".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u672a\u53d8\u66f4");
                } else if ("2".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u53d8\u66f4\u4e2d");
                } else if ("3".equals(vo.getChangeState())) {
                    vo.setChangeStateName("\u5df2\u53d8\u66f4");
                }
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vos.add(vo);
        }
        beans.put("templateName", templateName);
        beans.put("records", vos);
        ExcelExport.getInstance().export(exportXlsx, beans, response);
    }

    @RequestMapping(value={"/refOutcontractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> refOutcontractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"type") != null) {
                param.getParams().put("type", new Parameter("in", _con.get((Object)"type")));
            }
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveintegratedCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutcontractVO> saveintegratedCode(@RequestBody OutcontractVO saveorUpdateVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
        this.service.saveOrUpdate((Object)entity, false);
        OutcontractVO vo = (OutcontractVO)BeanMapper.map((Object)((Object)entity), OutcontractVO.class);
        vo.setOutcontractSupplierList(saveorUpdateVO.getOutcontractSupplierList());
        if (vo.getOutcontractSubcontractUnitPriceList() != null && vo.getOutcontractSubcontractUnitPriceList().size() > 0) {
            vo.setOutcontractSubcontractUnitPriceList(OutcontractController.createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e00\u4f53\u5316\u7f16\u7801\u6210\u529f", (Object)vo);
    }

    public static List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
        ArrayList<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<String, OutcontractSubcontractUnitPriceVO>();
        for (OutcontractSubcontractUnitPriceVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            OutcontractSubcontractUnitPriceVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            OutcontractSubcontractUnitPriceVO parent = (OutcontractSubcontractUnitPriceVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((OutcontractSubcontractUnitPriceVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/querySubUnitPriceListByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OutcontractSubcontractUnitPriceVO>> querySubUnitPriceListByContractId(@RequestParam Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outcontract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.outcontractSubcontractUnitPriceService.list((Wrapper)queryWrapper);
        List<Object> result = new ArrayList();
        if (list != null && list.size() > 0) {
            result = OutcontractController.createTreeData(BeanMapper.mapList((Iterable)list, OutcontractSubcontractUnitPriceVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/refOutcontractMaterialList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractMaterialVO>> refOutcontractMaterialList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"contractId") != null) {
            param.getParams().put("outcontractId", new Parameter("eq", _con.get((Object)"contractId")));
        }
        IPage page = this.outcontractMaterialService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refOutcontractEquipmentRentList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutcontractEquipmentRentVO>> refOutcontractEquipmentRentList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"contractId") != null) {
            param.getParams().put("outcontractId", new Parameter("eq", _con.get((Object)"contractId")));
        }
        IPage page = this.outcontractEquipmentRentService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutcontractEquipmentRentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

