package com.ejianc.foundation.outcontract.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractSupplementaryAgreementEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSupplementaryAgreementEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEquipmentLeaseItemEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractSubcontractTotalPriceEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractSupplementaryAgreementEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;

@Service("changeOutcontract") 
public class ChangeOutcontractBpmServiceImpl implements ICommonBusinessService {
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String OUTCONTRACT_SOURCETYPE = "zjkj-outcontract";//合同
    private static final String OUTCONTRACT_CHANGE_SOURCETYPE = "zjkj-outcontractChange";//合同变更
    private static final String OUTCONTRACT_RECORD_SOURCETYPE = "zjkj-outcontractRecord";//合同记录

    private static final String OUTCONTRACT_REVIEW_SOURCETYPE = "zjkj-outcontractReview";//合同评审
    private static final String OUTCONTRACT_REVIEW_CHANGE_SOURCETYPE = "zjkj-outcontractReviewChange";//合同变更评审
    private static final String OUTCONTRACT_REVIEW_RECORD_SOURCETYPE = "zjkj-outcontractReviewRecord";//合同记录评审

    private static final String LABOROUTCONTRACT_BILLTYPE_CODE = "BT220105000000001";//劳务分包
    private static final String MAJOROUTCONTRACT_BILLTYPE_CODE = "BT220105000000002";//专业分包
    private static final String MATERIALOUTCONTRACT_BILLTYPE_CODE = "BT220105000000003";//物资采购
    private static final String EQUIPMENTOUTCONTRACT_BILLTYPE_CODE = "BT220105000000004";//机械租赁
    private static final String TURNOVERMATERIALOUTCONTRACT_BILLTYPE_CODE = "BT220105000000005";//周转材租赁
    private static final String DESIGNOUTCONTRACT_BILLTYPE_CODE = "BT220105000000006";//设计勘察
    private static final String CONSULTANCYOUTCONTRACT_BILLTYPE_CODE = "BT220105000000007";//咨询服务
    private static final String OTHEROUTCONTRACT_BILLTYPE_CODE = "BT220105000000008";//其它合同
    private static final String REVIEW_BILLTYPE_CODE = "BT220105000000009";//合同评审
    
    private static final String LABOROUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000010";//劳务分包
    private static final String MAJOROUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000011";//专业分包
    private static final String MATERIALOUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000012";//物资采购
    private static final String EQUIPMENTOUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000013";//机械租赁
    private static final String TURNOVERMATERIALOUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000014";//周转材租赁
    private static final String DESIGNOUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000015";//设计勘察
    private static final String CONSULTANCYOUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000016";//咨询服务
    private static final String OTHEROUTCONTRACT_CHANGE_BILLTYPE_CODE = "BT220105000000017";//其它合同
    private static final String REVIEW_CHANGE_BILLTYPE_CODE = "BT220105000000018";//合同评审
    
    private static final String LABOROUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000019";//劳务分包
    private static final String MAJOROUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000020";//专业分包
    private static final String MATERIALOUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000021";//物资采购
    private static final String EQUIPMENTOUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000022";//机械租赁
    private static final String TURNOVERMATERIALOUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000023";//周转材租赁
    private static final String DESIGNOUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000024";//设计勘察
    private static final String CONSULTANCYOUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000025";//咨询服务
    private static final String OTHEROUTCONTRACT_RECORD_BILLTYPE_CODE = "BT220105000000026";//其它合同
    private static final String REVIEW_RECORD_BILLTYPE_CODE = "BT220105000000027";//合同评审
    
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IOutcontractService outcontractService;
//    @Autowired
//    private IOutcontractReviewService outcontractReviewservice;
    
//    @Autowired
//    private IChangeOutcontractReviewService changeOutcontractReviewService;
    @Autowired
    private IChangeOutcontractService changeOutcontractService;
    
//    @Autowired
//    private IRecordOutcontractReviewService recordOutcontractReviewService;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//1、获取目前合同信息、变更信息
		ChangeOutcontractEntity changeEntity = changeOutcontractService.selectById(billId);
//		ChangeOutcontractReviewEntity changeReviewEntity = changeOutcontractReviewService.selectById(billId);
    	OutcontractEntity contractEntity = outcontractService.selectById(changeEntity.getOutcontractId());
//		OutcontractReviewEntity reviewEntity = outcontractReviewservice.selectById(changeEntity.getOutcontractId());
		//获取历史版本条数
		QueryWrapper<RecordOutcontractEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("outcontract_id", contractEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordOutcontractService.count(recordWrapper);
		//2、生成历史版本
		//2.1、生成合同信息
		RecordOutcontractEntity recordOutcontractEntity = BeanMapper.map(contractEntity, RecordOutcontractEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordOutcontractEntity);
		recordOutcontractEntity.setBillState(null);
		recordOutcontractEntity.setOutcontractId(contractEntity.getId());
		recordOutcontractEntity.setOutcontractCode(contractEntity.getBillCode()+"-"+(count+1));
		recordOutcontractEntity.setId(recordId);
		recordOutcontractEntity.setBillCode(contractEntity.getBillCode());
		recordOutcontractEntity.setChangeReason(changeEntity.getChangeReason());
		recordOutcontractEntity.setEffectDate(changeEntity.getEffectDate());

    	//处理分包工程总价汇总表变更
    	List<OutcontractSubcontractTotalPriceEntity> outcontractSubcontractTotalPriceList = contractEntity.getOutcontractSubcontractTotalPriceList();
    	if(outcontractSubcontractTotalPriceList!=null&&outcontractSubcontractTotalPriceList.size()>0){
			List<RecordOutcontractSubcontractTotalPriceEntity> recordOutcontractSubcontractTotalPriceList = new ArrayList<>();
			for(OutcontractSubcontractTotalPriceEntity entity : outcontractSubcontractTotalPriceList){
				RecordOutcontractSubcontractTotalPriceEntity reEntity = BeanMapper.map(entity, RecordOutcontractSubcontractTotalPriceEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractSubcontractTotalPriceList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractSubcontractTotalPriceList(recordOutcontractSubcontractTotalPriceList);
		}
    	//处理分包工程综合单价计价表变更
    	List<OutcontractSubcontractUnitPriceEntity> outcontractSubcontractUnitPriceList = contractEntity.getOutcontractSubcontractUnitPriceList();
    	if(outcontractSubcontractUnitPriceList!=null&&outcontractSubcontractUnitPriceList.size()>0){
			List<RecordOutcontractSubcontractUnitPriceEntity> recordOutcontractSubcontractUnitPriceList = new ArrayList<>();
			for(OutcontractSubcontractUnitPriceEntity entity : outcontractSubcontractUnitPriceList){
				RecordOutcontractSubcontractUnitPriceEntity reEntity = BeanMapper.map(entity, RecordOutcontractSubcontractUnitPriceEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractSubcontractUnitPriceList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractSubcontractUnitPriceList(recordOutcontractSubcontractUnitPriceList);
		}
    	//处理物资（周转材）合同价变更
    	List<OutcontractMaterialEntity> outcontractMaterialList = contractEntity.getOutcontractMaterialList();
    	if(outcontractMaterialList!=null&&outcontractMaterialList.size()>0){
			List<RecordOutcontractMaterialEntity> recordOutcontractMaterialList = new ArrayList<>();
			for(OutcontractMaterialEntity entity : outcontractMaterialList){
				RecordOutcontractMaterialEntity reEntity = BeanMapper.map(entity, RecordOutcontractMaterialEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractMaterialList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractMaterialList(recordOutcontractMaterialList);
		}
    	//处理租赁物进出场费明细表变更
    	List<OutcontractEquipmentLeaseItemEntity> outcontractEquipmentLeaseItemList = contractEntity.getOutcontractEquipmentLeaseItemList();
    	if(outcontractEquipmentLeaseItemList!=null&&outcontractEquipmentLeaseItemList.size()>0){
			List<RecordOutcontractEquipmentLeaseItemEntity> recordOutcontractEquipmentLeaseItemList = new ArrayList<>();
			for(OutcontractEquipmentLeaseItemEntity entity : outcontractEquipmentLeaseItemList){
				RecordOutcontractEquipmentLeaseItemEntity reEntity = BeanMapper.map(entity, RecordOutcontractEquipmentLeaseItemEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractEquipmentLeaseItemList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractEquipmentLeaseItemList(recordOutcontractEquipmentLeaseItemList);
		}
    	//处理租金明细表变更
    	List<OutcontractEquipmentRentEntity> outcontractEquipmentRentList = contractEntity.getOutcontractEquipmentRentList();
    	if(outcontractEquipmentRentList!=null&&outcontractEquipmentRentList.size()>0){
			List<RecordOutcontractEquipmentRentEntity> recordOutcontractEquipmentRentList = new ArrayList<>();
			for(OutcontractEquipmentRentEntity entity : outcontractEquipmentRentList){
				RecordOutcontractEquipmentRentEntity reEntity = BeanMapper.map(entity, RecordOutcontractEquipmentRentEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractEquipmentRentList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractEquipmentRentList(recordOutcontractEquipmentRentList);
		}
		//补充
		List<OutcontractSupplementaryAgreementEntity> outcontractSupplementaryAgreementList = contractEntity.getOutcontractSupplementaryAgreementList();
		if(outcontractSupplementaryAgreementList!=null&&outcontractSupplementaryAgreementList.size()>0){
			List<RecordOutcontractSupplementaryAgreementEntity> recordOutcontractSupplementaryAgreementList = new ArrayList<>();
			for(OutcontractSupplementaryAgreementEntity entity : outcontractSupplementaryAgreementList){
				RecordOutcontractSupplementaryAgreementEntity reEntity = BeanMapper.map(entity, RecordOutcontractSupplementaryAgreementEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordOutcontractId(recordId);
				recordOutcontractSupplementaryAgreementList.add(reEntity);
				entity.setRowState("del");
			}
			recordOutcontractEntity.setRecordOutcontractSupplementaryAgreementList(recordOutcontractSupplementaryAgreementList);
		}
		//复制合同附件信息到记录中
		String sourceBillType = "";
		String targetBillType = "";
		if("劳务分包".equals(contractEntity.getType())){
			sourceBillType = LABOROUTCONTRACT_BILLTYPE_CODE;
			targetBillType = LABOROUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("专业分包".equals(contractEntity.getType())){
			sourceBillType = MAJOROUTCONTRACT_BILLTYPE_CODE;
			targetBillType = MAJOROUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("物资采购".equals(contractEntity.getType())){
			sourceBillType = MATERIALOUTCONTRACT_BILLTYPE_CODE;
			targetBillType = MATERIALOUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("机械租赁".equals(contractEntity.getType())){
			sourceBillType = EQUIPMENTOUTCONTRACT_BILLTYPE_CODE;
			targetBillType = EQUIPMENTOUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("周转材租赁".equals(contractEntity.getType())){
			sourceBillType = TURNOVERMATERIALOUTCONTRACT_BILLTYPE_CODE;
			targetBillType = TURNOVERMATERIALOUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("设计勘察".equals(contractEntity.getType())){
			sourceBillType = DESIGNOUTCONTRACT_BILLTYPE_CODE;
			targetBillType = DESIGNOUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("咨询服务".equals(contractEntity.getType())){
			sourceBillType = CONSULTANCYOUTCONTRACT_BILLTYPE_CODE;
			targetBillType = CONSULTANCYOUTCONTRACT_RECORD_BILLTYPE_CODE;
		}else if("其它合同".equals(contractEntity.getType())){
			sourceBillType = OTHEROUTCONTRACT_BILLTYPE_CODE;
			targetBillType = OTHEROUTCONTRACT_RECORD_BILLTYPE_CODE;
		}
		attachmentApi.copyFilesFromSourceBillToTargetBill(contractEntity.getId().toString(), sourceBillType, OUTCONTRACT_SOURCETYPE, recordId.toString(), targetBillType, OUTCONTRACT_RECORD_SOURCETYPE);
		recordOutcontractService.saveOrUpdate(recordOutcontractEntity, false);
		logger.info("---------生成合同信息完成--------");
		/*if("劳务分包".equals(contractEntity.getType())||"专业分包".equals(contractEntity.getType())){
			//2.1、生成合同评审信息
			RecordOutcontractReviewEntity recordOutcontractReviewEntity = BeanMapper.map(reviewEntity, RecordOutcontractReviewEntity.class);
			this.clearBaseData(recordOutcontractReviewEntity);
			recordOutcontractReviewEntity.setId(recordId);
			logger.info("---------生成合同评审信息完成--------");
			attachmentApi.copyFilesFromSourceBillToTargetBill(reviewEntity.getId().toString(), REVIEW_BILLTYPE_CODE, OUTCONTRACT_REVIEW_SOURCETYPE , recordId.toString(), REVIEW_RECORD_BILLTYPE_CODE, OUTCONTRACT_REVIEW_RECORD_SOURCETYPE);
			recordOutcontractReviewService.saveOrUpdate(recordOutcontractReviewEntity, false);
		}*/
		
		//3、修改当前合同信息
    	OutcontractEntity newContractEntity = BeanMapper.map(changeEntity, OutcontractEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillState(contractEntity.getBillState());
		newContractEntity.setId(contractEntity.getId());
		newContractEntity.setCreateTime(contractEntity.getCreateTime());
		newContractEntity.setCreateUserCode(contractEntity.getCreateUserCode());
		newContractEntity.setTenantId(contractEntity.getTenantId());
		newContractEntity.setVersion(contractEntity.getVersion());
		//子表
    	//处理分包工程总价汇总表变更
		List<ChangeOutcontractSubcontractTotalPriceEntity> changeOutcontractSubcontractTotalPriceList = changeEntity.getChangeOutcontractSubcontractTotalPriceList();
		if(changeOutcontractSubcontractTotalPriceList!=null&&changeOutcontractSubcontractTotalPriceList.size()>0){
			List<OutcontractSubcontractTotalPriceEntity> newOutcontractSubcontractTotalPriceList = BeanMapper.mapList(changeOutcontractSubcontractTotalPriceList, OutcontractSubcontractTotalPriceEntity.class);
			newOutcontractSubcontractTotalPriceList.addAll(outcontractSubcontractTotalPriceList);
			newContractEntity.setOutcontractSubcontractTotalPriceList(newOutcontractSubcontractTotalPriceList);
		}
    	//处理分包工程综合单价计价表变更
		List<ChangeOutcontractSubcontractUnitPriceEntity> changeOutcontractSubcontractUnitPriceList = changeEntity.getChangeOutcontractSubcontractUnitPriceList();
		if(changeOutcontractSubcontractUnitPriceList!=null&&changeOutcontractSubcontractUnitPriceList.size()>0){
			List<OutcontractSubcontractUnitPriceEntity> newOutcontractSubcontractUnitPriceList = BeanMapper.mapList(changeOutcontractSubcontractUnitPriceList, OutcontractSubcontractUnitPriceEntity.class);
			newOutcontractSubcontractUnitPriceList.addAll(outcontractSubcontractUnitPriceList);
			newContractEntity.setOutcontractSubcontractUnitPriceList(newOutcontractSubcontractUnitPriceList);
		}
    	//处理物资（周转材）合同价变更
		List<ChangeOutcontractMaterialEntity> changeOutcontractMaterialList = changeEntity.getChangeOutcontractMaterialList();
		if(changeOutcontractMaterialList!=null&&changeOutcontractMaterialList.size()>0){
			List<OutcontractMaterialEntity> newOutcontractMaterialList = BeanMapper.mapList(changeOutcontractMaterialList, OutcontractMaterialEntity.class);
			newOutcontractMaterialList.addAll(outcontractMaterialList);
			newContractEntity.setOutcontractMaterialList(newOutcontractMaterialList);
		}
    	//处理租赁物进出场费明细表变更
		List<ChangeOutcontractEquipmentLeaseItemEntity> changeOutcontractEquipmentLeaseItemList = changeEntity.getChangeOutcontractEquipmentLeaseItemList();
		if(changeOutcontractEquipmentLeaseItemList!=null&&changeOutcontractEquipmentLeaseItemList.size()>0){
			List<OutcontractEquipmentLeaseItemEntity> newOutcontractEquipmentLeaseItemList = BeanMapper.mapList(changeOutcontractEquipmentLeaseItemList, OutcontractEquipmentLeaseItemEntity.class);
			newOutcontractEquipmentLeaseItemList.addAll(outcontractEquipmentLeaseItemList);
			newContractEntity.setOutcontractEquipmentLeaseItemList(newOutcontractEquipmentLeaseItemList);
		}
    	//处理租金明细表变更
		List<ChangeOutcontractEquipmentRentEntity> changeOutcontractEquipmentRentList = changeEntity.getChangeOutcontractEquipmentRentList();
		if(changeOutcontractEquipmentRentList!=null&&changeOutcontractEquipmentRentList.size()>0){
			List<OutcontractEquipmentRentEntity> newOutcontractEquipmentRentList = BeanMapper.mapList(changeOutcontractEquipmentRentList, OutcontractEquipmentRentEntity.class);
			newOutcontractEquipmentRentList.addAll(outcontractEquipmentRentList);
			newContractEntity.setOutcontractEquipmentRentList(newOutcontractEquipmentRentList);
		}
		//补充
		List<ChangeOutcontractSupplementaryAgreementEntity> changeOutcontractSupplementaryAgreementList = changeEntity.getChangeOutcontractSupplementaryAgreementList();
		if(changeOutcontractSupplementaryAgreementList!=null&&changeOutcontractSupplementaryAgreementList.size()>0){
			List<OutcontractSupplementaryAgreementEntity> newOutcontractSupplementaryAgreementList = BeanMapper.mapList(changeOutcontractSupplementaryAgreementList, OutcontractSupplementaryAgreementEntity.class);
			newOutcontractSupplementaryAgreementList.addAll(outcontractSupplementaryAgreementList);
			newContractEntity.setOutcontractSupplementaryAgreementList(newOutcontractSupplementaryAgreementList);
		}
    	outcontractService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		if("劳务分包".equals(contractEntity.getType())){
			sourceBillType = LABOROUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = LABOROUTCONTRACT_BILLTYPE_CODE;
		}else if("专业分包".equals(contractEntity.getType())){
			sourceBillType = MAJOROUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = MAJOROUTCONTRACT_BILLTYPE_CODE;
		}else if("物资采购".equals(contractEntity.getType())){
			sourceBillType = MATERIALOUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = MATERIALOUTCONTRACT_BILLTYPE_CODE;
		}else if("机械租赁".equals(contractEntity.getType())){
			sourceBillType = EQUIPMENTOUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = EQUIPMENTOUTCONTRACT_BILLTYPE_CODE;
		}else if("周转材租赁".equals(contractEntity.getType())){
			sourceBillType = TURNOVERMATERIALOUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = TURNOVERMATERIALOUTCONTRACT_BILLTYPE_CODE;
		}else if("设计勘察".equals(contractEntity.getType())){
			sourceBillType = DESIGNOUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = DESIGNOUTCONTRACT_BILLTYPE_CODE;
		}else if("咨询服务".equals(contractEntity.getType())){
			sourceBillType = CONSULTANCYOUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = CONSULTANCYOUTCONTRACT_BILLTYPE_CODE;
		}else if("其它合同".equals(contractEntity.getType())){
			sourceBillType = OTHEROUTCONTRACT_CHANGE_BILLTYPE_CODE;
			targetBillType = OTHEROUTCONTRACT_BILLTYPE_CODE;
		}
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, OUTCONTRACT_CHANGE_SOURCETYPE, contractEntity.getId().toString(), targetBillType, OUTCONTRACT_SOURCETYPE);
//		recordOutcontractService.saveOrUpdate(recordOutcontractEntity, false);
		
		logger.info("---------修改合同信息完成--------");
		/*if("劳务分包".equals(contractEntity.getType())||"专业分包".equals(contractEntity.getType())){
			//3.2修改合同评审信息
			OutcontractReviewEntity newReviewEntity = BeanMapper.map(changeReviewEntity, OutcontractReviewEntity.class);
			newReviewEntity.setId(reviewEntity.getId());
			newReviewEntity.setOutcontractId(reviewEntity.getId());
			newReviewEntity.setCreateTime(reviewEntity.getCreateTime());
			newReviewEntity.setCreateUserCode(reviewEntity.getCreateUserCode());
			newReviewEntity.setTenantId(reviewEntity.getTenantId());
			newReviewEntity.setVersion(reviewEntity.getVersion());
			outcontractReviewservice.saveOrUpdate(newReviewEntity, false);
			attachmentApi.copyFilesFromSourceBillToTargetBill(changeReviewEntity.getId().toString(), REVIEW_CHANGE_BILLTYPE_CODE, OUTCONTRACT_REVIEW_CHANGE_SOURCETYPE , reviewEntity.getId().toString(), REVIEW_BILLTYPE_CODE, OUTCONTRACT_REVIEW_SOURCETYPE);
			logger.info("---------修改合同评审信息完成--------");
		}*/
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
