package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontractFileUpdate")
public class OutcontractFileUpdateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractService service;

    /**
     * @Description wps回掉方法，回写附件id
     */
    @RequestMapping(value = "/updateFileInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
    	JSONObject back = new JSONObject();
    	OutcontractEntity entity = service.selectById(updateData.getLong("billId"));
    	entity.setFileId(updateData.getLong("fileId"));
    	service.saveOrUpdate(entity, false);
    	back.put("message", "合同文件信息更新成功");
    	back.put("billData", entity);
		return CommonResponse.success("合同文件信息更新成功",back);
    }
}
