package com.ejianc.foundation.outcontract.service.impl;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
@Service("outcontractService")
public class OutcontractServiceImpl extends BaseServiceImpl<OutcontractMapper, OutcontractEntity> implements IOutcontractService{

    @Autowired
    private IOutcontractReviewService reviewService; 
    
	@Override
	public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
        	reviewService.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
	}

	@Override
	public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id).set("performance_status", performanceStatus);
        this.update(null, updateWrapper);
        return CommonResponse.success("更改履约状态成功！");
	}

	@Override
	public CommonResponse<String> changeDate(Long id, String type, Date date) {
		UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
		if("mobilizationDate".equals(type)){
			updateWrapper.eq("id",id).set("mobilization_date", date);
		}else if("exitDate".equals(type)){
			updateWrapper.eq("id",id).set("exit_date", date);
		}
        this.update(null, updateWrapper);
        return CommonResponse.success("更改成功！");
	}

}
