package com.ejianc.foundation.outcontractDisclosure.service.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.outcontractDisclosure.bean.OutcontractDisclosureEntity;
import com.ejianc.foundation.outcontractDisclosure.service.IOutcontractDisclosureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("outcontractDisclosure") 
public class OutcontractDisclosureBpmServiceImpl implements ICommonBusinessService {
	
    private static final String outcontractDisclosure_sourceType = "zjkj-outcontractDisclosure";//供方合同交底
    
    private static final String outcontractDisclosure_billtype_code = "BT220112000000001";//供方合同交底

    @Autowired
    private IAttachmentApi attachmentApi;

	@Autowired
	private IOutcontractDisclosureService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectApprovingByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个审批中的单据，不可提交！");
		}
		CommonResponse<List<AttachmentVO>> list = attachmentApi.queryListBySourceId(billId, outcontractDisclosure_billtype_code, outcontractDisclosure_sourceType, "desc");
		if(list.isSuccess()){
			if(!(list.getData()!=null&&list.getData().size()>0)){
				throw new BusinessException("无附件，不能提交");
			}
		}else{
			throw new BusinessException("校验附件信息失败");
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if(state==0){
//			直审
			CommonResponse<List<AttachmentVO>> list = attachmentApi.queryListBySourceId(billId, outcontractDisclosure_billtype_code, outcontractDisclosure_sourceType, "desc");
			if(list.isSuccess()){
				if(!(list.getData()!=null&&list.getData().size()>0)){
					throw new BusinessException("无附件，不能提交");
				}
			}else{
				throw new BusinessException("校验附件信息失败");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutcontractDisclosureEntity entity = service.selectById(billId);
		List<OutcontractDisclosureEntity> entities = service.selectUncommitedByContractId(entity.getId(), entity.getContractId());
		if (CollectionUtils.isNotEmpty(entities)){
			return CommonResponse.error("一个合同只能存在一个自由态的单据，不可撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
