package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractReviewEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;
import com.ejianc.foundation.report.service.IOutcontractSignStatisticService;
import com.ejianc.foundation.report.vo.OutcontractSignStatisticVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 供方合同签约情况统计
 * 
 * @author generator
 * 
 */
@Service("outcontractSignStatisticService")
public class OutcontractSignStatisticServiceImpl implements IOutcontractSignStatisticService {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	private final static String ESSignStatistic = "ejc_zjkj_outcontract_sign_statistic";

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IOutcontractReportService outcontractReportService;
	@Autowired
	private RestHighLevelClient client;

	@Override
	public CommonResponse<String> saveESData(String reportName) {
		//1、生成关系表
		OutcontractReportEntity reportEntity = new OutcontractReportEntity();
		reportEntity.setReportName(reportName);
		reportEntity.setReportType("供方合同签约情况统计");
        SimpleDateFormat format2 = new SimpleDateFormat("YYYY-MM");
		String curDate = format2.format(new Date());
		reportEntity.setReportTime(curDate);
		Long reportId = IdWorker.getId();
		reportEntity.setId(reportId);
		outcontractReportService.saveOrUpdate(reportEntity, false);
		//获取当前合同数据
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
		List<OutcontractEntity> list = outcontractService.queryList(queryParam);
		
		BulkRequest bulkRequest = new BulkRequest();
		for(OutcontractEntity entity : list){
            try {
            	OutcontractSignStatisticVO outcontractSignStatisticVO = BeanMapper.map(entity, OutcontractSignStatisticVO.class);
	            Map<String, Object> dataMap = BeanMapper.map(outcontractSignStatisticVO, Map.class);
	            dataMap.put("reportId", reportId.toString());
		        IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
				indexRequest.source(dataMap, XContentType.JSON);
	            bulkRequest.add(indexRequest);
			} catch (Exception e) {
				logger.error("生成供方合同签约情况统计数据异常，", e);
				throw new BusinessException("生成供方合同签约情况统计数据异常");
			}
		}
		try {
        	bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
			client.bulk(bulkRequest, RequestOptions.DEFAULT);
		} catch (IOException e) {
			logger.info("生成ES数据失败:---->"+e.getMessage());
			throw new BusinessException("生成ES数据失败:---->"+e.getMessage());
		}
        
		logger.info("***********生成供方合同签约情况统计执行 完事 *********** ");
		return CommonResponse.success("生成供方合同签约情况统计成功");
	}
    
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

	@Override
	public IPage<OutcontractVO> queryPage(QueryParam param) {
		IPage<OutcontractVO> page = new Page<>();
		List<OutcontractVO> resultList = new ArrayList<>();
		Map<String,Parameter> params = param.getParams();
    	if(params.get("range")!=null&&"es".equals(param.getParams().get("range").getValue().toString())){
        	param.getParams().remove("range");
    		//查询es中数据
    		SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
    		SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
    		//查询参数
    		BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
    		//获取es中数据
    		String reportId = params.get("reportId").getValue().toString();
            boolQuery.must(QueryBuilders.matchQuery("reportId", reportId));
			boolQuery.must(QueryBuilders.matchQuery("tenantId", InvocationInfoProxy.getTenantid()));
            try {
                List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
                List<Long> commonOrgIds = new ArrayList<>();
                List<Long> departmentIds = new ArrayList<>();
                orgVOList.stream().forEach(org -> {
                    if(5 == org.getOrgType()) {
                        //项目部
                        departmentIds.add(org.getId());
                    } else {
                        //普通组织
                        commonOrgIds.add(org.getId());
                    }
                });
                if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                	boolQuery.must(QueryBuilders.termsQuery("orgId", commonOrgIds));
                } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                	boolQuery.must(QueryBuilders.termsQuery("projectDepartmentId", departmentIds));
                }
				if(StringUtils.isNotBlank(param.getSearchText())){
					BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("billCode", param.getSearchText()));
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("contractName", param.getSearchText()));
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("projectName", param.getSearchText()));
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("signUnitName", param.getSearchText()));
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("buildUnitName", param.getSearchText()));
					shouldBuilder.should(QueryBuilders.matchPhrasePrefixQuery("pricingForm", param.getSearchText()));
					boolQuery.must(shouldBuilder);
				}
				for(String key : params.keySet()){
					if("range".equals(key)||"reportId".equals(key)){
						continue;
					}
					//预付款
					if(params!=null&&"advanceCharge".equals(key)){
						if("有预付款".equals(params.get("advanceCharge").getValue())){
							boolQuery.must(QueryBuilders.existsQuery("advanceCharge"));
						}else{
							boolQuery.mustNot(QueryBuilders.existsQuery("advanceCharge"));
						}
						continue;
					}
					//进度付款条件
//					70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
					if(params!=null&&"monthlyPayment".equals(key)){
						if(params.get("monthlyPayment").getValue().toString().contains("月度付款")){
							boolQuery.must(QueryBuilders.rangeQuery("monthlyPayment").gt(0));
						}else if(params.get("monthlyPayment").getValue().toString().contains("节点付款")){
							boolQuery.must(QueryBuilders.rangeQuery("nodePayment").gt(0));
						}else if(params.get("monthlyPayment").getValue().toString().contains("70以下")){
							BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
							shouldBuilder.should(QueryBuilders.rangeQuery("monthlyPayment").lt(70));
							shouldBuilder.should(QueryBuilders.rangeQuery("nodePayment").lt(70));
							boolQuery.must(shouldBuilder );
						}else if(params.get("monthlyPayment").getValue().toString().contains("70-75")){
							BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
							shouldBuilder.should(QueryBuilders.rangeQuery("monthlyPayment").gte(70).lt(75));
							shouldBuilder.should(QueryBuilders.rangeQuery("nodePayment").gte(70).lt(75));
							boolQuery.must(shouldBuilder);
							
						}else if(params.get("monthlyPayment").getValue().toString().contains("75-80")){
							BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
							shouldBuilder.should(QueryBuilders.rangeQuery("monthlyPayment").gte(75).lt(80));
							shouldBuilder.should(QueryBuilders.rangeQuery("nodePayment").gte(75).lt(80));
							boolQuery.must(shouldBuilder);
						}else if(params.get("monthlyPayment").getValue().toString().contains("80以上")){
							BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
							shouldBuilder.should(QueryBuilders.rangeQuery("monthlyPayment").gte(80));
							shouldBuilder.should(QueryBuilders.rangeQuery("nodePayment").gte(80));
							boolQuery.must(shouldBuilder);
						}
						continue;
					}
					//签约日期
					if(params!=null&&"signDate".equals(key)){
						String[] signDate = params.get("signDate").getValue().toString().split(",");
						boolQuery.must(QueryBuilders.rangeQuery("signDate").from(signDate[0]).to(signDate[1]));
						continue;
					}
		            //分包状态：签约时间大于进场时间
					if(params!=null&&"subcontractingStatus".equals(key)){
		                Map<String, Object> par = new HashMap<>();
						Script script = new Script("doc['signDate'].size() > 0 && doc['mobilizationDate'].size() > 0 && doc['signDate'].value.getMillis() > doc['mobilizationDate'].value.getMillis()");
//						Script script = new Script("doc['mobilizationDate'].size() > 0");
		                ScriptQueryBuilder scriptQueryBuilder = new ScriptQueryBuilder(script);
		            	boolQuery.must(scriptQueryBuilder);
//						Script script1 = new Script("doc['signDate'].value.getMillis() > doc['mobilizationDate'].value.getMillis()");
//		                ScriptQueryBuilder scriptQueryBuilder1 = new ScriptQueryBuilder(script1);
//		            	boolQuery.must(scriptQueryBuilder1);
		            	continue;
		            }
					boolQuery.must(QueryBuilders.termsQuery(key, params.get(key).getValue().toString().split(",")));
				}

				sourceBuilder.query(boolQuery);
				if(param.getOrderMap()!=null){
					for(String key : param.getOrderMap().keySet()){
						if("desc".equals(param.getOrderMap().get(key).toString())){
							sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.DESC));
						}else{
							sourceBuilder.sort(new FieldSortBuilder(key).order(SortOrder.ASC));
						}
					}
				}
				Integer pageIndex = param.getPageIndex();
				Integer pageSize = param.getPageSize();
				sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex-1)*pageSize);
				sourceBuilder.size(pageSize);
				sourceBuilder.trackTotalHits(true);
				sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间

				searchRequest.source(sourceBuilder);

				List<OutcontractVO> list = new ArrayList<>();
				SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);

				SearchHits hits = response.getHits();
				for (SearchHit hit : hits) {
					JSONObject json = new JSONObject(hit.getSourceAsMap());
					OutcontractVO vo = JSONObject.toJavaObject(json, OutcontractVO.class);
					//金额转为万元
					if(vo.getContractPrice()!=null){//合同额
						vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
					}
					list.add(vo);
				}
				resultList = this.processData(list);
				page.setCurrent(param.getPageIndex());
				page.setRecords(resultList);
				page.setTotal(hits.getTotalHits().value);
			} catch (Exception e) {
				throw new BusinessException("查询全部记录索引失败，MSG：", e);
			}
    	}else{
    		if(params.get("range")!=null){
    			params.remove("range");
    		}
    		params.put("billState", new Parameter(QueryParam.IN, "1,3"));
    		//获取数据库中数据
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("billCode");
            fuzzyFields.add("contractName");
            fuzzyFields.add("projectName");
            fuzzyFields.add("subcontractStatus");
            fuzzyFields.add("signUnitName");
            fuzzyFields.add("buildUnitName");
            fuzzyFields.add("pricingForm");
            /** 租户隔离 */
            params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

            /** 数据隔离 本下 没有组织orgId的删除下面代码 */
            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            List<Long> commonOrgIds = new ArrayList<>();
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            	params.put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            	params.put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            }
            //预付款
            if(params!=null&&params.get("advanceCharge")!=null){
            	if("有预付款".equals(params.get("advanceCharge").getValue())){
            		params.put("advanceCharge", new Parameter(QueryParam.NE,null));
            	}else{
            		params.put("advanceCharge", new Parameter(QueryParam.EQ,null));
            	}
            }
			//进度付款条件
//			70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
			if(params!=null&&params.get("monthlyPayment")!=null){
				if(params.get("monthlyPayment").getValue().toString().contains("月度付款")){
					params.put("monthlyPayment", new Parameter(QueryParam.GT,0));
				}else if(params.get("monthlyPayment").getValue().toString().contains("节点付款")){
					params.put("nodePayment", new Parameter(QueryParam.GT,0));
					params.remove("monthlyPayment");
				}else if(params.get("monthlyPayment").getValue().toString().contains("70以下")){
		            ComplexParam c1 = new ComplexParam();
		            c1.setLogic(ComplexParam.AND);
		            ComplexParam c11 = new ComplexParam();
		            c11.setLogic(ComplexParam.OR);
		            c11.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 70));
		            c1.getComplexParams().add(c11);
		            ComplexParam c12 = new ComplexParam();
		            c12.setLogic(ComplexParam.OR);
		            c12.getParams().put("nodePayment", new Parameter(QueryParam.LT, 70));
		            c1.getComplexParams().add(c12);
		            param.getComplexParams().add(c1);
					params.remove("monthlyPayment");
				}else if(params.get("monthlyPayment").getValue().toString().contains("70-75")){
		            ComplexParam c1 = new ComplexParam();
		            c1.setLogic(ComplexParam.AND);
		            
		            //月度付款----（monthlyPayment>=70 and monthlyPayment <75）
		            ComplexParam c11 = new ComplexParam();
		            c11.setLogic(ComplexParam.OR);
		            ComplexParam c111 = new ComplexParam();
		            c111.setLogic(ComplexParam.AND);
		            c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 70));
		            c11.getComplexParams().add(c111);
		            ComplexParam c112 = new ComplexParam();
		            c112.setLogic(ComplexParam.AND);
		            c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 75));
		            c11.getComplexParams().add(c112);
		            c1.getComplexParams().add(c11);
		            
		            //节点付款----（monthlyPayment>=70 and monthlyPayment <75）
		            ComplexParam c12 = new ComplexParam();
		            c12.setLogic(ComplexParam.OR);
		            ComplexParam c121 = new ComplexParam();
		            c121.setLogic(ComplexParam.AND);
		            c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 70));
		            c12.getComplexParams().add(c121);
		            ComplexParam c122 = new ComplexParam();
		            c122.setLogic(ComplexParam.AND);
		            c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 75));
		            c12.getComplexParams().add(c122);
		            c1.getComplexParams().add(c12);
		            
		            param.getComplexParams().add(c1);
					params.remove("monthlyPayment");
					
				}else if(params.get("monthlyPayment").getValue().toString().contains("75-80")){
		            ComplexParam c1 = new ComplexParam();
		            c1.setLogic(ComplexParam.AND);
		            
		            //月度付款----（monthlyPayment>=70 and monthlyPayment <75）
		            ComplexParam c11 = new ComplexParam();
		            c11.setLogic(ComplexParam.OR);
		            ComplexParam c111 = new ComplexParam();
		            c111.setLogic(ComplexParam.AND);
		            c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 75));
		            c11.getComplexParams().add(c111);
		            ComplexParam c112 = new ComplexParam();
		            c112.setLogic(ComplexParam.AND);
		            c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 80));
		            c11.getComplexParams().add(c112);
		            c1.getComplexParams().add(c11);
		            
		            //节点付款----（monthlyPayment>=70 and monthlyPayment <75）
		            ComplexParam c12 = new ComplexParam();
		            c12.setLogic(ComplexParam.OR);
		            ComplexParam c121 = new ComplexParam();
		            c121.setLogic(ComplexParam.AND);
		            c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 75));
		            c12.getComplexParams().add(c121);
		            ComplexParam c122 = new ComplexParam();
		            c122.setLogic(ComplexParam.AND);
		            c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 80));
		            c12.getComplexParams().add(c122);
		            c1.getComplexParams().add(c12);
		            
		            param.getComplexParams().add(c1);
				}else if(params.get("monthlyPayment").getValue().toString().contains("80以上")){
		            ComplexParam c1 = new ComplexParam();
		            c1.setLogic(ComplexParam.AND);
		            ComplexParam c11 = new ComplexParam();
		            c11.setLogic(ComplexParam.OR);
		            c11.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 80));
		            c1.getComplexParams().add(c11);
		            ComplexParam c12 = new ComplexParam();
		            c12.setLogic(ComplexParam.OR);
		            c12.getParams().put("nodePayment", new Parameter(QueryParam.GE, 80));
		            c1.getComplexParams().add(c12);
		            param.getComplexParams().add(c1);
					params.remove("monthlyPayment");
				}
			}
            //分包状态：签约时间大于进场时间
            if(params!=null&&params.get("subcontractingStatus")!=null){
            	params.put("subcontractingStatus", new Parameter(QueryParam.SQL," sign_date > mobilization_date "));
            	params.put("subcontractingStatus1", new Parameter(QueryParam.SQL," mobilization_date is not null "));
            }
            IPage<OutcontractEntity> pageData = outcontractService.queryPage(param,false);
			page = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
			List<OutcontractVO> voList = new ArrayList<>();
			for (OutcontractEntity entity : pageData.getRecords()) {
				OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
				//金额转为万元
				if(vo.getContractPrice()!=null){//合同额
					vo.setContractPrice(vo.getContractPrice().divide(new BigDecimal(10000)));
				}
				voList.add(vo);
			}
			resultList = this.processData(voList);
			page.setRecords(resultList);
    	}
        return page;
	}

	public List<OutcontractVO> processData(List<OutcontractVO> list){
		List<OutcontractVO> vos = BeanMapper.mapList(list, OutcontractVO.class);
		vos.forEach(e->{
			if ("劳务分包".equals(e.getType())){
				e.setLabor(e.getSubcontractingContent());
				switch (e.getPricingForm()) {
					case "按实体工程量对应的固定单价":
						e.setLaborPrice(e.getPricingForm());
						break;
					case "按建筑面积平米的每平米固定单价":
						e.setLaborArea(e.getPricingForm());
						break;
					case "固定单价":
						e.setLaborFixedPrice(e.getPricingForm());
						break;
					case "固定总价":
						e.setLaborTotalPrice(e.getPricingForm());
						break;
					case "定额计价":
						e.setLaborQuotaValuation(e.getPricingForm());
						break;
				}
				if ("包清工".equals(e.getLaborSubcontracteMode())){
					e.setPackLight(e.getLaborSubcontracteMode());
				}
				if ("扩大劳务分包".equals(e.getLaborSubcontracteMode())){
					e.setExpandSub(e.getLaborSubcontracteMode());
				}
				if ("其他形式".equals(e.getLaborSubcontracteMode())){
					e.setOtherform(e.getLaborSubcontracteMode());
				}
			}
			if ("专业分包".equals(e.getType())){
				e.setMajor(e.getSubcontractingContent());
				switch (e.getPricingForm()) {
					case "按实体工程量对应的固定单价":
						e.setMajorPrice(e.getPricingForm());
						break;
					case "按承包合同价款让利费率下浮":
						e.setRateLower(e.getPricingForm());
						break;
					case "固定总价":
						e.setMajorTotalPrice(e.getPricingForm());
						break;
					case "定额计价":
						e.setMajorQuotaValuation(e.getPricingForm());
						break;
				}
				if ("包清工辅材".equals(e.getLaborSubcontracteMode())){
					e.setWorkersAndAuxiliaryMaterials(e.getLaborSubcontracteMode());
				}
				if ("包工包料".equals(e.getLaborSubcontracteMode())){
					e.setLaborAndMaterials(e.getLaborSubcontracteMode());
				}
				if ("其他形式".equals(e.getLaborSubcontracteMode())){
					e.setOtherForms(e.getLaborSubcontracteMode());
				}
			}
			if ("物资采购".equals(e.getType())){
				e.setMaterial(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setMaterialFixedPrice(e.getPricingForm());
				}
				if ("可调价格".equals(e.getPricingForm())){
					e.setAdjustablePrice(e.getPricingForm());
				}
			}
			if ("机械租赁".equals(e.getType())){
				e.setEquipment(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setEquipmentFixedPrice("固定单价");
				}
				if ("其他".equals(e.getPricingForm())){
					e.setEquipmentOther("其他");
				}
			}
			if ("周转材租赁".equals(e.getType())){
				e.setTurnoverMaterial(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setTurnoverMaterialFixedPrice(e.getPricingForm());
				}
				if ("其他".equals(e.getPricingForm())){
					e.setTurnoverMaterialOther(e.getPricingForm());
				}
			}
			if ("设计勘察".equals(e.getType())){
				e.setDesign(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setDesignFixedPrice(e.getPricingForm());
				}
				//
				if("固定总价".equals(e.getPricingForm())){
					e.setDesignTotalPrice(e.getPricingForm());
				}
				if ("其他".equals(e.getPricingForm())){
					e.setDesignOther(e.getPricingForm());
				}
			}

			if ("咨询服务".equals(e.getType())){
				e.setConsultancy(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setConsultancyFixedPrice(e.getPricingForm());
				}
				if ("其他".equals(e.getPricingForm())){
					e.setConsultancyOther(e.getPricingForm());
				}
			}
			if ("其它合同".equals(e.getType())){
				e.setOther(e.getSubcontractingContent());
				if ("固定单价".equals(e.getPricingForm())){
					e.setOtherFixedPrice(e.getPricingForm());
				}
				if ("其他".equals(e.getPricingForm())){
					e.setOther1(e.getPricingForm());
				}
			}
		});
		return vos;
	}
}
