package com.ejianc.foundation.report.service.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportOrgEntity;
import com.ejianc.foundation.report.bean.OutcontractSignSummaryReportProjectEntity;
import com.ejianc.foundation.report.mapper.OutcontractSignSummaryReportProjectMapper;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryReportProjectService;
import com.ejianc.foundation.report.vo.OutcontractSignStatisticVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 
 *
 * @author generator
 *
 */
@Service("outcontractSignSummaryReportProjectService")
public class OutcontractSignSummaryReportProjectServiceImpl extends BaseServiceImpl<OutcontractSignSummaryReportProjectMapper, OutcontractSignSummaryReportProjectEntity> implements IOutcontractSignSummaryReportProjectService{
	
    @Autowired
    private OutcontractSignSummaryReportProjectMapper projectMapper;
    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public IPage<OutcontractSignSummaryReportProjectEntity> queryNewPage(QueryParam param, List<Long> commonOrgIds, List<Long> departmentIds) {
		IPage<OutcontractSignSummaryReportProjectEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Map<String, Parameter> params = param.getParams();
        String reportId = params.get("reportId").getValue().toString();
        Map<String,Object> paramMapper = new HashMap<>();
        paramMapper.put("reportId", reportId);
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("departmentIds", departmentIds);
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
		Integer pn = param.getPageIndex();
		pn = pn - 1 < 0 ? 1 : pn;
        long startLine = (pn - 1) * param.getPageSize();
        paramMapper.put("startLine", startLine);
        paramMapper.put("pageSize", param.getPageSize());
        paramMapper.put("commonOrgIds", commonOrgIds);
        if(param.getParams().get("signDate")!=null){
        	String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            paramMapper.put("startSignDate", signDate[0]);
            paramMapper.put("endSignDate", signDate[1]);
        }
        List<OutcontractSignSummaryReportProjectEntity> list = projectMapper.queryNewPage(paramMapper);
        long total = projectMapper.count(paramMapper);
        page.setTotal(total);
        page.setRecords(list);
		return page;
	}
}

