package com.ejianc.foundation.outcontract.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.outcontract.mapper.RecordOutcontractMapper;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;

import java.util.List;
import java.util.Map;

/**
 * 记录分供方合同
 * 
 * @author generator
 * 
 */
@Service("recordOutcontractService")
public class RecordOutcontractServiceImpl extends BaseServiceImpl<RecordOutcontractMapper, RecordOutcontractEntity> implements IRecordOutcontractService{

    @Autowired
    private OutcontractMapper contractMapper;

    @Override
    public IPage<RecordOutcontractVO> queryAllList(Map<String, Object> params) {
        Long count = contractMapper.countAll(params);
        Integer pageIndex = params.get("pageIndex")!=null?Integer.parseInt(params.get("pageIndex").toString()):1;
        Integer pageSize = params.get("pageSize")!=null?Integer.parseInt(params.get("pageSize").toString()):10;
        IPage<RecordOutcontractVO> pageData = new Page<>(pageIndex, pageSize, count);
        if(count>0){
            List<RecordOutcontractVO> list = contractMapper.queryAllList(params);
            pageData.setRecords(list);
        }
        return pageData;
    }
}
