/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.outcontract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outcontractService")
public class OutcontractServiceImpl
extends BaseServiceImpl<OutcontractMapper, OutcontractEntity>
implements IOutcontractService {
    @Autowired
    private IOutcontractReviewService reviewService;
    @Autowired
    private OutcontractMapper contractMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Override
    public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if ("\u52b3\u52a1\u5206\u5305".equals(vos.get(0).getType()) || "\u4e13\u4e1a\u5206\u5305".equals(vos.get(0).getType())) {
            this.reviewService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"performance_status", (Object)performanceStatus);
        this.update(null, (Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u6539\u5c65\u7ea6\u72b6\u6001\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> changeDate(Long id, String type, Date date) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if ("mobilizationDate".equals(type)) {
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"mobilization_date", (Object)date);
        } else if ("exitDate".equals(type)) {
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"exit_date", (Object)date);
        }
        this.update(null, (Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u66f4\u6539\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> file(OutcontractVO outcontractVO) {
        OutcontractEntity entity = (OutcontractEntity)((Object)this.selectById(outcontractVO.getId()));
        if ("1".equals(entity.getFileState())) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5f52\u6863");
        }
        entity.setFileState("1");
        this.saveOrUpdate((Object)entity, false);
        CommonResponse back = this.attachmentApi.updateAttachRef(outcontractVO.getId(), outcontractVO.getAttachIds());
        if (!back.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }

    @Override
    public IPage<OutcontractSupplierVO> refSupplierList(Map<String, Object> params) {
        Long count = this.contractMapper.countSupplier(params);
        Integer pageIndex = (Integer)params.get("pageIndex");
        Integer pageSize = (Integer)params.get("pageSize");
        Page pageData = new Page((long)pageIndex.intValue(), (long)pageSize.intValue(), count.longValue());
        if (count > 0L) {
            List<OutcontractSupplierVO> list = this.contractMapper.querySupplierList(params);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (OutcontractSupplierVO vo : list) {
                ids.add(vo.getId());
            }
            CommonResponse supplierResponse = this.shareSupplierApi.querySupplierByIds(ids);
            if (supplierResponse.isSuccess() && supplierResponse.getData() != null && ((List)supplierResponse.getData()).size() > 0) {
                HashMap<Long, SupplierVO> map = new HashMap<Long, SupplierVO>();
                for (SupplierVO supplierVO : (List)supplierResponse.getData()) {
                    map.put(supplierVO.getId(), supplierVO);
                }
                for (OutcontractSupplierVO outcontractSupplierVO : list) {
                    if (map.get(outcontractSupplierVO.getId()) == null) continue;
                    SupplierVO supplierVO = (SupplierVO)map.get(outcontractSupplierVO.getId());
                    outcontractSupplierVO.setSupplierName(supplierVO.getName());
                    outcontractSupplierVO.setSupplierTaxPayerType(supplierVO.getTaxPayerType());
                    outcontractSupplierVO.setSupplierSocialCreditCode(supplierVO.getSocialCreditCode());
                    outcontractSupplierVO.setSupplierBank(supplierVO.getBankName());
                    outcontractSupplierVO.setSupplierBankAccount(supplierVO.getBankAccount());
                    outcontractSupplierVO.setSupplierLegal(supplierVO.getLegal());
                    outcontractSupplierVO.setSupplierTelephone(supplierVO.getTelephone());
                }
            }
            pageData.setRecords(list);
        }
        return pageData;
    }
}

