/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sealApproval.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.vo.SealApprovalVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sealApproval"})
public class SealApprovalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_SEAL_APPROVAL";
    @Autowired
    private ISealApprovalService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IRoleApi roleApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SealApprovalVO> saveOrUpdate(@RequestBody SealApprovalVO saveOrUpdateVO) {
        SealApprovalEntity entity = (SealApprovalEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SealApprovalEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getSeal().contains("bid")) {
            entity.setBid("bid");
        } else {
            entity.setBid(null);
        }
        if (saveOrUpdateVO.getSeal().contains("certification")) {
            entity.setCertification("certification");
        } else {
            entity.setCertification(null);
        }
        if (saveOrUpdateVO.getSeal().contains("contract")) {
            entity.setContract("contract");
        } else {
            entity.setContract(null);
        }
        if (saveOrUpdateVO.getSeal().contains("lawsuit")) {
            entity.setLawsuit("lawsuit");
        } else {
            entity.setLawsuit(null);
        }
        if (saveOrUpdateVO.getSeal().contains("prove")) {
            entity.setProve("prove");
        } else {
            entity.setProve(null);
        }
        if (saveOrUpdateVO.getSeal().contains("guarantee")) {
            entity.setGuarantee("guarantee");
        } else {
            entity.setGuarantee(null);
        }
        if (saveOrUpdateVO.getSeal().contains("signed")) {
            entity.setSigned("signed");
        } else {
            entity.setSigned(null);
        }
        if (saveOrUpdateVO.getSeal().contains("excellence")) {
            entity.setExcellence("excellence");
        } else {
            entity.setExcellence(null);
        }
        if (saveOrUpdateVO.getSeal().contains("engineering")) {
            entity.setEngineering("engineering");
        } else {
            entity.setEngineering(null);
        }
        if (saveOrUpdateVO.getSeal().contains("others")) {
            entity.setOthers("others");
        } else {
            entity.setOthers(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("companySeal")) {
            entity.setCompanySeal("companySeal");
        } else {
            entity.setCompanySeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("legalSeal")) {
            entity.setLegalSeal("legalSeal");
        } else {
            entity.setLegalSeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("contractSeal")) {
            entity.setContractSeal("contractSeal");
        } else {
            entity.setContractSeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("partySeal")) {
            entity.setPartySeal("partySeal");
        } else {
            entity.setPartySeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("disciplineSeal")) {
            entity.setDisciplineSeal("disciplineSeal");
        } else {
            entity.setDisciplineSeal(null);
        }
        if (saveOrUpdateVO.getText().contains("otherSeal")) {
            entity.setOtherSeal("otherSeal");
        } else {
            entity.setOtherSeal(null);
            entity.setSealMemo(null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)entity.getBid())) {
            stringBuffer.append("\u6295\u6807").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getCertification())) {
            stringBuffer.append("\u8d44\u683c\u5ba1\u67e5").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getContract())) {
            stringBuffer.append("\u5408\u540c").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getLawsuit())) {
            stringBuffer.append("\u8bc9\u8bbc").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getProve())) {
            stringBuffer.append("\u8bc1\u660e").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getGuarantee())) {
            stringBuffer.append("\u62c5\u4fdd").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSigned())) {
            stringBuffer.append("\u7b7e\u7ea6").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getExcellence())) {
            stringBuffer.append("\u521b\u4f18").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getEngineering())) {
            stringBuffer.append("\u5de5\u7a0b\u8d44\u6599").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOthers())) {
            stringBuffer.append("\u5176\u4ed6").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)stringBuffer)) {
            String sealContent = stringBuffer.substring(0, stringBuffer.length() - 1);
            entity.setSealContent(sealContent);
        }
        StringBuffer stringBuffer1 = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)entity.getCompanySeal())) {
            stringBuffer1.append("\u516c\u53f8\u7ae0").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getLegalSeal())) {
            stringBuffer1.append("\u6cd5\u4eba\u4ee3\u8868\u7ae0").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getContractSeal())) {
            stringBuffer1.append("\u5408\u540c\u4e13\u7528\u7ae0").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getPartySeal())) {
            stringBuffer1.append("\u515a\u59d4\u7ae0").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getDisciplineSeal())) {
            stringBuffer1.append("\u7eaa\u59d4\u7ae0").append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOtherSeal())) {
            stringBuffer1.append(entity.getSealMemo()).append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)stringBuffer1)) {
            String stampCategory = stringBuffer1.substring(0, stringBuffer1.length() - 1);
            entity.setStampCategory(stampCategory);
        }
        this.service.saveOrUpdate((Object)entity, false);
        SealApprovalVO vo = (SealApprovalVO)BeanMapper.map((Object)((Object)entity), SealApprovalVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SealApprovalVO> queryDetail(Long id) {
        SealApprovalEntity entity = (SealApprovalEntity)((Object)this.service.selectById(id));
        SealApprovalVO vo = (SealApprovalVO)BeanMapper.map((Object)((Object)entity), SealApprovalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SealApprovalVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SealApprovalVO sealApprovalVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SealApprovalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyDeptName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("printUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean userSearchFlag = false;
        CommonResponse roleResponse = this.roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if (roleResponse.isSuccess() && roleResponse.getData() != null) {
            for (RoleVO roleVO : (List)roleResponse.getData()) {
                if (!"ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())) continue;
                userSearchFlag = true;
                break;
            }
        }
        if (userSearchFlag) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)this.sessionManager.getUserContext().getUserCode()));
        } else {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SealApprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("printUnitName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, SealApprovalVO.class);
        vos.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getPrintTime() != null) {
                vo.setPrintTimeShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getPrintTime()));
            }
            if (vo.getApplyDate() != null) {
                vo.setApplyDateShow(DateFormatUtil.formatDate((String)"yyyy-MM-dd hh:mm:ss", (Date)vo.getApplyDate()));
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("SealApproval-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSealApprovalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SealApprovalVO>> refSealApprovalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SealApprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getEmployeePhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SealApprovalVO> validateContract(@RequestParam(value="employeeId") Long employeeId) {
        CommonResponse userResp;
        String mobile = null;
        if (employeeId != null && (userResp = this.employeeApi.getById(employeeId)) != null) {
            mobile = ((EmployeeVO)userResp.getData()).getMobilePhone();
        }
        SealApprovalVO vo = new SealApprovalVO();
        vo.setEmployeePhone(mobile);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/useSeal"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> useSeal(@RequestParam(value="id") Long id) {
        SealApprovalEntity entity = (SealApprovalEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef\uff0c\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setPrintState("1");
        entity.setPrintTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u7528\u5370\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updatePrintTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updatePrintTime(@RequestParam(value="id") Long id, @RequestParam(value="printTime") String printTime) {
        SealApprovalEntity entity = (SealApprovalEntity)((Object)this.service.selectById(id));
        if (entity != null) {
            try {
                entity.setPrintState("1");
                entity.setPrintTime(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(printTime));
                this.service.saveOrUpdate((Object)entity, false);
            }
            catch (Exception e) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef\uff0c\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return CommonResponse.success((String)"\u7528\u5370\u6210\u529f\uff01");
    }
}

