package com.ejianc.foundation.sealApproval.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.vo.SealApprovalVO;

/**
 * 用印审批
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sealApproval")
public class SealApprovalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_SEAL_APPROVAL";//此处需要根据实际修改

    @Autowired
    private ISealApprovalService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IRoleApi roleApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SealApprovalVO> saveOrUpdate(@RequestBody SealApprovalVO saveOrUpdateVO) {
    	SealApprovalEntity entity = BeanMapper.map(saveOrUpdateVO, SealApprovalEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(saveOrUpdateVO.getSeal().contains("bid")){
            entity.setBid("bid");
        }else {
            entity.setBid(null);
        }
        if (saveOrUpdateVO.getSeal().contains("certification")){
            entity.setCertification("certification");
        }else {
            entity.setCertification(null);
        }
        if(saveOrUpdateVO.getSeal().contains("contract")){
            entity.setContract("contract");
        }else {
            entity.setContract(null);
        }
        if (saveOrUpdateVO.getSeal().contains("lawsuit")){
            entity.setLawsuit("lawsuit");
        }else {
            entity.setLawsuit(null);
        }
        if (saveOrUpdateVO.getSeal().contains("prove")){
            entity.setProve("prove");
        }else {
            entity.setProve(null);
        }
        if (saveOrUpdateVO.getSeal().contains("guarantee")){
            entity.setGuarantee("guarantee");
        }else {
            entity.setGuarantee(null);
        }
        if (saveOrUpdateVO.getSeal().contains("signed")){
            entity.setSigned("signed");
        }else {
            entity.setSigned(null);
        }
        if (saveOrUpdateVO.getSeal().contains("excellence")){
            entity.setExcellence("excellence");
        }else {
            entity.setExcellence(null);
        }
        if (saveOrUpdateVO.getSeal().contains("engineering")){
            entity.setEngineering("engineering");
        }else {
            entity.setEngineering(null);
        }
        if (saveOrUpdateVO.getSeal().contains("others")){
            entity.setOthers("others");
        }else {
            entity.setOthers(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("companySeal")){
            entity.setCompanySeal("companySeal");
        }else {
            entity.setCompanySeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("legalSeal")){
            entity.setLegalSeal("legalSeal");
        }else {
            entity.setLegalSeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("contractSeal")){
            entity.setContractSeal("contractSeal");
        }else {
            entity.setContractSeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("partySeal")){
            entity.setPartySeal("partySeal");
        }else {
            entity.setPartySeal(null);
        }
        if (saveOrUpdateVO.getSealCategory().contains("disciplineSeal")){
            entity.setDisciplineSeal("disciplineSeal");
        }else {
            entity.setDisciplineSeal(null);
        }
        if (saveOrUpdateVO.getText().contains("otherSeal")){
            entity.setOtherSeal("otherSeal");
        }else {
            entity.setOtherSeal(null);
            entity.setSealMemo(null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if(StringUtils.isNotBlank(entity.getBid())){
            stringBuffer.append("投标").append("/");
        }
        if(StringUtils.isNotBlank(entity.getCertification())){
            stringBuffer.append("资格审查").append("/");
        }
        if(StringUtils.isNotBlank(entity.getContract())){
            stringBuffer.append("合同").append("/");
        }
        if(StringUtils.isNotBlank(entity.getLawsuit())){
            stringBuffer.append("诉讼").append("/");
        }
        if(StringUtils.isNotBlank(entity.getProve())){
            stringBuffer.append("证明").append("/");
        }
        if(StringUtils.isNotBlank(entity.getGuarantee())){
            stringBuffer.append("担保").append("/");
        }
        if(StringUtils.isNotBlank(entity.getSigned())){
            stringBuffer.append("签约").append("/");
        }
        if(StringUtils.isNotBlank(entity.getExcellence())){
            stringBuffer.append("创优").append("/");
        }
        if(StringUtils.isNotBlank(entity.getEngineering())){
            stringBuffer.append("工程资料").append("/");
        }
        if(StringUtils.isNotBlank(entity.getOthers())){
            stringBuffer.append("其他").append("/");
        }
        if (StringUtils.isNotBlank(stringBuffer)){
            String sealContent = stringBuffer.substring(0,stringBuffer.length()-1);
            entity.setSealContent(sealContent);
        }
        StringBuffer stringBuffer1 = new StringBuffer();
        if(StringUtils.isNotBlank(entity.getCompanySeal())){
            stringBuffer1.append("公司章").append("/");
        }
        if(StringUtils.isNotBlank(entity.getLegalSeal())){
            stringBuffer1.append("法人代表章").append("/");
        }
        if(StringUtils.isNotBlank(entity.getContractSeal())){
            stringBuffer1.append("合同专用章").append("/");
        }
        if(StringUtils.isNotBlank(entity.getPartySeal())){
            stringBuffer1.append("党委章").append("/");
        }
        if(StringUtils.isNotBlank(entity.getDisciplineSeal())){
            stringBuffer1.append("纪委章").append("/");
        }
        if(StringUtils.isNotBlank(entity.getOtherSeal())){
            stringBuffer1.append(entity.getSealMemo()).append("/");
        }
        if (StringUtils.isNotBlank(stringBuffer1)){
            String stampCategory = stringBuffer1.substring(0,stringBuffer1.length()-1);
            entity.setStampCategory(stampCategory);
        }
    	service.saveOrUpdate(entity, false);
    	SealApprovalVO vo = BeanMapper.map(entity, SealApprovalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SealApprovalVO> queryDetail(Long id) {
    	SealApprovalEntity entity = service.selectById(id);
    	SealApprovalVO vo = BeanMapper.map(entity, SealApprovalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SealApprovalVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SealApprovalVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SealApprovalVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SealApprovalVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyDeptName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("printUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
            for(RoleVO roleVO : roleResponse.getData()){
                if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
                    userSearchFlag = true;
                    break;
                }
            }
        }
        if(userSearchFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
        }else{
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SealApprovalEntity> page = service.queryPage(param,false);
        IPage<SealApprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SealApprovalVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("printUnitName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SealApprovalEntity> list = service.queryList(param);
        List<SealApprovalVO> vos = BeanMapper.mapList(list, SealApprovalVO.class);
        vos.forEach(vo -> {
        	vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        	if(vo.getPrintTime()!=null){
        		vo.setPrintTimeShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getPrintTime()));
        	}
        	if(vo.getApplyDate()!=null){
        		vo.setApplyDateShow(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss", vo.getApplyDate()));
        	}
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("SealApproval-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSealApprovalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SealApprovalVO>> refSealApprovalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SealApprovalEntity> page = service.queryPage(param,false);
        IPage<SealApprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SealApprovalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    
    //获取经办人电话
    @RequestMapping(value = "/getEmployeePhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SealApprovalVO> validateContract(@RequestParam("employeeId") Long employeeId) {
        String mobile = null;
        if (employeeId != null){
            CommonResponse<EmployeeVO> userResp = employeeApi.getById(employeeId);
            if (userResp != null){
                mobile = userResp.getData().getMobilePhone();
            }
        }
        SealApprovalVO vo = new SealApprovalVO();
        vo.setEmployeePhone(mobile);
        return CommonResponse.success("查询成功！",vo);
    }

    //用印审批
    @RequestMapping(value = "/useSeal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> useSeal(@RequestParam("id") Long id) {
        SealApprovalEntity entity = service.selectById(id);
        if(entity!=null){
            entity.setPrintState("1");
            entity.setPrintTime(new Date());
            service.saveOrUpdate(entity, false);
        }else{
            throw new BusinessException("网络错误，未获取到单据信息，请稍后再试");
        }
        return CommonResponse.success("用印成功！");
    }

    //用印审批
    @RequestMapping(value = "/updatePrintTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updatePrintTime(@RequestParam("id") Long id, @RequestParam("printTime") String printTime) {
        SealApprovalEntity entity = service.selectById(id);
        if(entity!=null){
            try{
                entity.setPrintState("1");
                entity.setPrintTime(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(printTime));
                service.saveOrUpdate(entity, false);
            }catch(Exception e){
                throw new BusinessException("保存失败，请稍后再试");
            }
        }else{
            throw new BusinessException("网络错误，未获取到单据信息，请稍后再试");
        }
        return CommonResponse.success("用印成功！");
    }

}
