package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;

/**
 * 记录分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("recordOutcontract")
public class RecordOutcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRecordOutcontractService service;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecordOutcontractVO> queryDetail(Long id) {
    	RecordOutcontractEntity entity = service.selectById(id);
    	RecordOutcontractVO vo = BeanMapper.map(entity, RecordOutcontractVO.class);
    	List<RecordOutcontractSupplierVO> recordOutcontractSupplierList = new ArrayList<>();
    	RecordOutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, RecordOutcontractSupplierVO.class);
    	outcontractSupplierVO.setRowState("add");
    	recordOutcontractSupplierList.add(outcontractSupplierVO);
		vo.setRecordOutcontractSupplierList(recordOutcontractSupplierList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RecordOutcontractVO>> queryList(@RequestBody QueryParam param) {
        Map<String,Object> params = new HashMap<>();
        long startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() -  1) * param.getPageSize();
        params.put("startLine", startLine);
        params.put("pageIndex", param.getPageIndex());
        params.put("pageSize", param.getPageSize());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
            String sql = " order by ";
            for(String key : param.getOrderMap().keySet()){
                sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
            }
            params.put("ordersql", sql);
        }
        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
            for(RoleVO roleVO : roleResponse.getData()){
                if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
                    userSearchFlag = true;
                    break;
                }
            }
        }
        if(userSearchFlag){
//            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
            params.put("createUserCode", sessionManager.getUserContext().getUserCode());
        }else{
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
        		params.put("orgIds", commonOrgIds);
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
        		params.put("projectDepartmentIds", departmentIds);
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //承包类型
        if(param.getParams()!=null&&param.getParams().get("type")!=null){
            String[] type = param.getParams().get("type").getValue().toString().split(",");
            params.put("type", Arrays.asList(type));
        }
        //项目名称
        if(param.getParams()!=null&&param.getParams().get("projectId")!=null){
            params.put("projectId", param.getParams().get("projectId").getValue());
        }
        //发包人
        if(param.getParams()!=null&&param.getParams().get("supplier")!=null){
            params.put("supplier", param.getParams().get("supplier").getValue());
        }
        //签约单位
        if(param.getParams()!=null&&param.getParams().get("signUnit")!=null){
            params.put("signUnit", param.getParams().get("signUnit").getValue());
        }
        //计价形式
        if(param.getParams()!=null&&param.getParams().get("pricingForm")!=null){
            String[] pricingForm = param.getParams().get("pricingForm").getValue().toString().split(",");
            params.put("pricingForm", Arrays.asList(pricingForm));
        }
        //签约日期
        if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
            String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            String sql = "( sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("signDate", sql);
            String sql1 = "( supplementary_sign_time BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("supplementarySignTime", sql1);
        }
        //补充签订时间
//        if(param.getParams()!=null&&param.getParams().get("supplementarySignTime")!=null){
//            String[] supplementarySignTime = param.getParams().get("supplementarySignTime").getValue().toString().split(",");
//            String sql = "( d.supplementarySignTime BETWEEN '"+ supplementarySignTime[0] +"' and  '"+ supplementarySignTime[1] +"')";
//            params.put("supplementarySignTime", sql);
//        }
        //预付款
        if(param.getParams()!=null&&param.getParams().get("advanceCharge")!=null){
            if("有预付款".equals(param.getParams().get("advanceCharge").getValue())){
                String sql = "( d.advanceCharge is not null)";
                params.put("advancePaymentProportion", sql);
            }else{
                String sql = "( d.advanceCharge is null )";
                params.put("advancePaymentProportion", sql);
            }
        }
//		70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
        if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
            if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
                String sql = "( d.monthlyPayment > 0)";
                params.put("monthlyPayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
                String sql = "( d.nodePayment > 0)";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70以下")){
                String sql = "( d.nodePayment < 70 or d.monthlyPayment < 70 )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70-75")){
                String sql = "( (d.nodePayment >= 70 and d.nodePayment < 75) or (d.monthlyPayment >= 70 and d.monthlyPayment <75) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("75-80")){
                String sql = "( (d.nodePayment >= 75 and d.nodePayment < 80) or (d.monthlyPayment >= 75 and d.monthlyPayment <80) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("80以上")){
                String sql = "( d.nodePayment >= 80 or d.monthlyPayment >= 80 )";
                params.put("nodePayment", sql);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        //履约状态
        if(param.getParams()!=null&&param.getParams().get("performanceStatus")!=null){
            params.put("performanceStatus", param.getParams().get("performanceStatus").getValue());
        }
        if(param.getParams()!=null&&param.getParams().get("supplementary")!=null){
            params.put("supplementary", param.getParams().get("supplementary").getValue());
        }

        IPage<RecordOutcontractVO> page = service.queryAllList(params);

        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
            String sql = " order by ";
            for(String key : param.getOrderMap().keySet()){
                sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
            }
            params.put("ordersql", sql);
        }
        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
            for(RoleVO roleVO : roleResponse.getData()){
                if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
                    userSearchFlag = true;
                    break;
                }
            }
        }
        if(userSearchFlag){
            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
        }else{
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
        		params.put("orgIds", commonOrgIds);
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
        		params.put("projectDepartmentIds", departmentIds);
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //承包类型
        if(param.getParams()!=null&&param.getParams().get("type")!=null){
            String[] type = param.getParams().get("type").getValue().toString().split(",");
            params.put("type", Arrays.asList(type));
        }
        //项目名称
        if(param.getParams()!=null&&param.getParams().get("projectId")!=null){
            params.put("projectId", param.getParams().get("projectId").getValue());
        }
        //发包人
        if(param.getParams()!=null&&param.getParams().get("supplier")!=null){
            params.put("supplier", param.getParams().get("supplier").getValue());
        }
        //签约单位
        if(param.getParams()!=null&&param.getParams().get("signUnit")!=null){
            params.put("signUnit", param.getParams().get("signUnit").getValue());
        }
        //计价形式
        if(param.getParams()!=null&&param.getParams().get("pricingForm")!=null){
            String[] pricingForm = param.getParams().get("pricingForm").getValue().toString().split(",");
            params.put("pricingForm", Arrays.asList(pricingForm));
        }
        //签约日期
        if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
            String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            String sql = "( d.signDate BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("signDate", sql);
        }
        //补充签订时间
        if(param.getParams()!=null&&param.getParams().get("supplementarySignTime")!=null){
            String[] supplementarySignTime = param.getParams().get("supplementarySignTime").getValue().toString().split(",");
            String sql = "( d.supplementarySignTime BETWEEN '"+ supplementarySignTime[0] +"' and  '"+ supplementarySignTime[1] +"')";
            params.put("supplementarySignTime", sql);
        }
        //预付款
        if(param.getParams()!=null&&param.getParams().get("advanceCharge")!=null){
            if("有预付款".equals(param.getParams().get("advanceCharge").getValue())){
                String sql = "( d.advanceCharge is not null)";
                params.put("advancePaymentProportion", sql);
            }else{
                String sql = "( d.advanceCharge is null )";
                params.put("advancePaymentProportion", sql);
            }
        }
//		70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
        if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
            if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
                String sql = "( d.monthlyPayment > 0)";
                params.put("monthlyPayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
                String sql = "( d.nodePayment > 0)";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70以下")){
                String sql = "( d.nodePayment < 70 or d.monthlyPayment < 70 )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70-75")){
                String sql = "( (d.nodePayment >= 70 and d.nodePayment < 75) or (d.monthlyPayment >= 70 and d.monthlyPayment <75) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("75-80")){
                String sql = "( (d.nodePayment >= 75 and d.nodePayment < 80) or (d.monthlyPayment >= 75 and d.monthlyPayment <80) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("80以上")){
                String sql = "( d.nodePayment >= 80 or d.monthlyPayment >= 80 )";
                params.put("nodePayment", sql);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        //履约状态
        if(param.getParams()!=null&&param.getParams().get("performanceStatus")!=null){
            params.put("performanceStatus", param.getParams().get("performanceStatus").getValue());
        }
        IPage<RecordOutcontractVO> page = service.queryAllList(params);
        List<RecordOutcontractVO> list = page.getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        for(RecordOutcontractVO vo : list){
            if(vo.getSignDate()!=null){
                vo.setSignDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSignDate()));
            }
            if(vo.getChangeState()!=null){
                if("1".equals(vo.getChangeState())){
                    vo.setChangeStateName("未变更");
                }else if("2".equals(vo.getChangeState())){
                    vo.setChangeStateName("变更中");
                }else if("3".equals(vo.getChangeState())){
                    vo.setChangeStateName("已变更");
                }
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("alloutcontract-export.xlsx", beans, response);
    }
}
