package com.ejianc.foundation.outcontract.controller;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.ejianc.foundation.outcontract.vo.*;
import com.ejianc.foundation.util.ExcelUtilManySheet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEquipmentRentEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractSubcontractUnitPriceEntity;
import com.ejianc.foundation.outcontract.bean.RecordOutcontractEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractEquipmentRentService;
import com.ejianc.foundation.outcontract.service.IOutcontractMaterialService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractSubcontractUnitPriceService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;

/**
 * 分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outcontract")
public class OutcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String LABOROUTCONTRACT_BILL_CODE = "ZJKJ-LABOROUTCONTRACT";//劳务分包
    private static final String MAJOROUTCONTRACT_BILL_CODE = "ZJKJ-MAJOROUTCONTRACT";//专业分包
    private static final String MATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-MATERIALOUTCONTRACT";//物资采购
    private static final String EQUIPMENTOUTCONTRACT_BILL_CODE = "ZJKJ-EQUIPMENTOUTCONTRACT";//机械租赁
    private static final String TURNOVERMATERIALOUTCONTRACT_BILL_CODE = "ZJKJ-TURNOVERMATERIALOUTCONTRACT";//周转材租赁
    private static final String DESIGNOUTCONTRACT_BILL_CODE = "ZJKJ-DESIGNOUTCONTRACT";//设计勘察
    private static final String CONSULTANCYOUTCONTRACT_BILL_CODE = "ZJKJ-CONSULTANCYOUTCONTRACT";//咨询服务
    private static final String OTHEROUTCONTRACT = "ZJKJ-OTHEROUTCONTRACT";//其它合同
    private static final String TOPICPAYOUTCONTRACT = "ZJKJ-TOPICPAYOUTCONTRACT";//课题支出类合同编码规则

    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IOutcontractService service;

    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;

    @Autowired
    private IOutcontractMaterialService outcontractMaterialService;

    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;

    @Autowired
    private IRecordOutcontractService recordOutcontractService;

    @Autowired
    private SessionManager sessionManager;
	@Autowired
	private IRoleApi roleApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutcontractVO> saveOrUpdate(@RequestBody OutcontractVO saveOrUpdateVO) {
    	OutcontractEntity entity = BeanMapper.map(saveOrUpdateVO, OutcontractEntity.class);
    	if(StringUtils.isNotBlank(entity.getBillCode())){
			entity.setBillCode(entity.getBillCode().trim());
    		QueryWrapper<OutcontractEntity> queryWrapper = new QueryWrapper<>();
    		queryWrapper.eq("dr", 0);
    		queryWrapper.eq("bill_code", entity.getBillCode());
    		if(entity.getId() != null){
    			queryWrapper.ne("id", entity.getId());
    		}
        	List<OutcontractEntity> codeExit = service.list(queryWrapper);
        	if(codeExit!=null&&codeExit.size()>0){
        		throw new BusinessException("编码重复，请重新输入");
        	}
    	}
    	if((entity.getId() == null || entity.getId() == 0)&&StringUtils.isBlank(entity.getBillCode())){
    		String code = "";
    		if("劳务分包".equals(saveOrUpdateVO.getType())){
    			code = LABOROUTCONTRACT_BILL_CODE;
    		}else if("专业分包".equals(saveOrUpdateVO.getType())){
    			code = MAJOROUTCONTRACT_BILL_CODE;
    		}else if("物资采购".equals(saveOrUpdateVO.getType())){
    			code = MATERIALOUTCONTRACT_BILL_CODE;
    		}else if("机械租赁".equals(saveOrUpdateVO.getType())){
    			code = EQUIPMENTOUTCONTRACT_BILL_CODE;
    		}else if("周转材租赁".equals(saveOrUpdateVO.getType())){
    			code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
    		}else if("设计勘察".equals(saveOrUpdateVO.getType())){
    			code = DESIGNOUTCONTRACT_BILL_CODE;
    		}else if("咨询服务".equals(saveOrUpdateVO.getType())){
    			code = CONSULTANCYOUTCONTRACT_BILL_CODE;
    		}else if("其它合同".equals(saveOrUpdateVO.getType())){
    			code = OTHEROUTCONTRACT;
    		}else if("课题支出类合同".equals(saveOrUpdateVO.getType())){
    			code = TOPICPAYOUTCONTRACT;
    		}
    		entity.setUserDeptId(sessionManager.getUserContext().getDeptId());
            BillCodeParam billCodeParam = BillCodeParam.build(code,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
		if(StringUtils.isBlank(entity.getBillCode())){
			throw new BusinessException("合同编码不能为空");
		}
		if(entity.getId() == null || entity.getId() == 0) {
			String code = "";
			entity.setChangeState("1");//未变更
			entity.setFileState("0");//未归档
		}
    	//处理子表数据
        // 供方信息
    	if(saveOrUpdateVO.getOutcontractSupplierList()!=null&&saveOrUpdateVO.getOutcontractSupplierList().size()>0){
    		OutcontractSupplierVO outcontractSupplierVO = saveOrUpdateVO.getOutcontractSupplierList().get(0);
    		entity.setSupplierName(outcontractSupplierVO.getSupplierName());// 分供商名称
    		entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());// 纳税人类型
    		entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());// 统一社会信用代码
    		entity.setSupplierBank(outcontractSupplierVO.getSupplierBank()); // 开户行
    		entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());; // 开户行账号
    		entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser()); // 联系人
    		entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress()); // 联系人地址
    		entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone()); // 联系人电话
    		entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail()); // 联系人邮箱
    		entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal()); // 法定代表人
    		entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone()); // 供方电话
    	}else{
    		entity.setSupplierName(null);// 分供商名称
    		entity.setSupplierTaxPayerType(null);// 纳税人类型
    		entity.setSupplierSocialCreditCode(null);// 统一社会信用代码
    		entity.setSupplierBank(null); // 开户行
    		entity.setSupplierBankAccount(null);; // 开户行账号
    		entity.setSupplierContactUser(null); // 联系人
    		entity.setSupplierContactUserAddress(null); // 联系人地址
    		entity.setSupplierContactUserPhone(null); // 联系人电话
    		entity.setSupplierContactUserEmail(null); // 联系人邮箱
    		entity.setSupplierLegal(null); // 法定代表人
    		entity.setSupplierTelephone(null); // 供方电话
    	}

		if("劳务分包".equals(saveOrUpdateVO.getType()) || "专业分包".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getOutcontractSubcontractTotalPriceList()!=null && saveOrUpdateVO.getOutcontractSubcontractTotalPriceList().size()>0){
				BigDecimal subcontractTotalAmount = new BigDecimal(0);
				for(OutcontractSubcontractTotalPriceVO item : saveOrUpdateVO.getOutcontractSubcontractTotalPriceList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractTotalAmount = subcontractTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractTotalAmount = subcontractTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractTotalAmount(subcontractTotalAmount);
			}
			if(saveOrUpdateVO.getOutcontractSubcontractUnitPriceList()!=null&&saveOrUpdateVO.getOutcontractSubcontractUnitPriceList().size()>0){
				List<OutcontractSubcontractUnitPriceVO> list = createTreeData(saveOrUpdateVO.getOutcontractSubcontractUnitPriceList());
				BigDecimal subcontractUnitTotalAmount = new BigDecimal(0);
				for(OutcontractSubcontractUnitPriceVO item : list){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractUnitTotalAmount = subcontractUnitTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractUnitTotalAmount(subcontractUnitTotalAmount);
			}
			if(entity.getSubcontractTotalAmount()!=null&&entity.getSubcontractUnitTotalAmount()!=null){
				entity.setSubcontractTotalAmount(entity.getSubcontractTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				entity.setSubcontractUnitTotalAmount(entity.getSubcontractUnitTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				if(entity.getSubcontractTotalAmount().compareTo(entity.getSubcontractUnitTotalAmount())!=0){
					logger.info("分包工程总价汇总表合计金额-------------"+entity.getSubcontractTotalAmount());
					logger.info("分包工程综合单价计价表合计金额-------------"+entity.getSubcontractUnitTotalAmount());
					throw new BusinessException("分包工程总价汇总表合计金额("+entity.getSubcontractTotalAmount()+")与分包工程综合单价计价表合计金额("+entity.getSubcontractUnitTotalAmount()+")不一致，请修改后再保存");
				}
			}
			entity.setContractPrice(entity.getSubcontractTotalAmount());
		}else if("物资采购".equals(saveOrUpdateVO.getType()) || "周转材租赁".equals(saveOrUpdateVO.getType())
				|| "其它合同".equals(saveOrUpdateVO.getType()) || "课题支出类合同".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getOutcontractMaterialList()!=null&&saveOrUpdateVO.getOutcontractMaterialList().size()>0){
				BigDecimal contractPriceTotalAmount = new BigDecimal(0);
				for(OutcontractMaterialVO item : saveOrUpdateVO.getOutcontractMaterialList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						contractPriceTotalAmount = contractPriceTotalAmount.add(item.getTotalPrice());
					}
				}
				entity.setContractPriceTotalAmount(contractPriceTotalAmount);
				entity.setContractPrice(contractPriceTotalAmount);
			}
		}else if("机械租赁".equals(saveOrUpdateVO.getType())){
			BigDecimal leaseItemTotalAmount = new BigDecimal(0);
			BigDecimal rentTotalAmount = new BigDecimal(0);
			BigDecimal contractPrice = new BigDecimal(0);
			if(saveOrUpdateVO.getOutcontractEquipmentLeaseItemList()!=null&&saveOrUpdateVO.getOutcontractEquipmentLeaseItemList().size()>0){
				for(OutcontractEquipmentLeaseItemVO item : saveOrUpdateVO.getOutcontractEquipmentLeaseItemList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						leaseItemTotalAmount = leaseItemTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			if(saveOrUpdateVO.getOutcontractEquipmentRentList()!=null&&saveOrUpdateVO.getOutcontractEquipmentRentList().size()>0){
				for(OutcontractEquipmentRentVO item : saveOrUpdateVO.getOutcontractEquipmentRentList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						rentTotalAmount = rentTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			entity.setLeaseItemTotalAmount(leaseItemTotalAmount);
			entity.setRentTotalAmount(rentTotalAmount);
			contractPrice = leaseItemTotalAmount.add(rentTotalAmount);
			entity.setContractPrice(contractPrice);
		}
		service.saveOrUpdate(entity, false);
    	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
    	vo.setOutcontractSupplierList(saveOrUpdateVO.getOutcontractSupplierList());
		if(vo.getOutcontractSubcontractUnitPriceList()!=null&&vo.getOutcontractSubcontractUnitPriceList().size()>0){
			vo.setOutcontractSubcontractUnitPriceList(createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
		}
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutcontractVO> queryDetail(Long id) {
    	OutcontractEntity entity = service.selectById(id);
    	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);

    	List<OutcontractSupplierVO> outcontractSupplierList = new ArrayList<>();
    	OutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, OutcontractSupplierVO.class);
    	outcontractSupplierVO.setRowState("add");
    	outcontractSupplierList.add(outcontractSupplierVO);
		vo.setOutcontractSupplierList(outcontractSupplierList);

		if(vo.getOutcontractSubcontractUnitPriceList()!=null&&vo.getOutcontractSubcontractUnitPriceList().size()>0){
			vo.setOutcontractSubcontractUnitPriceList(createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
		}
		//当前单据变更过则显示变更记录
    	if(!"1".equals(vo.getChangeState())){
    		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("outcontract_id", vo.getId());
        	List<RecordOutcontractEntity> records = recordOutcontractService.list(queryWrapper);
        	if(records!=null&&records.size()>0){
        		vo.setRecordOutcontractList(BeanMapper.mapList(records, RecordOutcontractVO.class));
        	}
    	}
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutcontractVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
		fuzzyFields.add("supplierName");
		fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
		fuzzyFields.add("subcontractingContent");
		fuzzyFields.add("agentDeptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
        	for(RoleVO roleVO : roleResponse.getData()){
        		if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
        			userSearchFlag = true;
        			break;
        		}
        	}
        }
        if(userSearchFlag){
        	param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
        }else{
	        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
	        UserContext userContextCache =sessionManager.getUserContext();
	        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
	        String authOrgIds = userContextCache.getAuthOrgIds();
	        List<OrgVO> orgVOList = null;
	        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
	            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
	        }else {//pc端查询
	            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
	        }
	        //普通组织 id
	        List<Long> commonOrgIds = new ArrayList<>();
	        //项目部 id
	        List<Long> departmentIds = new ArrayList<>();
	        orgVOList.stream().forEach(org -> {
	            if(5 == org.getOrgType()) {
	                //项目部
	                departmentIds.add(org.getId());
	            } else {
	                //普通组织
	                commonOrgIds.add(org.getId());
	            }
	        });
	        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
	            /** 要求主表有orgId字段，保存单据所属组织 */
	            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
	        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
	            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
	            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
	        }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //预付款
        if(param.getParams()!=null&&param.getParams().get("advanceCharge")!=null){
        	if("有预付款".equals(param.getParams().get("advanceCharge").getValue())){
        		param.getParams().put("advanceCharge", new Parameter(QueryParam.NE,null));
        	}else{
        		param.getParams().put("advanceCharge", new Parameter(QueryParam.EQ,null));
        	}
        }
        //进度付款条件
//        if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
//        	if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
//        		param.getParams().put("monthlyPayment", new Parameter(QueryParam.GT,0));
//        	}
//        	if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
//        		param.getParams().put("nodePayment", new Parameter(QueryParam.GT,0));
//        	}
//        	param.getParams().remove("progressPaymentTerms");
//        }

//		70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
		if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
			if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
				param.getParams().put("monthlyPayment", new Parameter(QueryParam.GT,0));
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
				param.getParams().put("nodePayment", new Parameter(QueryParam.GT,0));
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70以下")){
	            ComplexParam c1 = new ComplexParam();
	            c1.setLogic(ComplexParam.AND);
	            ComplexParam c11 = new ComplexParam();
	            c11.setLogic(ComplexParam.OR);
	            c11.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 70));
	            c1.getComplexParams().add(c11);
	            ComplexParam c12 = new ComplexParam();
	            c12.setLogic(ComplexParam.OR);
	            c12.getParams().put("nodePayment", new Parameter(QueryParam.LT, 70));
	            c1.getComplexParams().add(c12);
	            param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70-75")){
	            ComplexParam c1 = new ComplexParam();
	            c1.setLogic(ComplexParam.AND);

	            //月度付款----（monthlyPayment>=70 and monthlyPayment <75）
	            ComplexParam c11 = new ComplexParam();
	            c11.setLogic(ComplexParam.OR);
	            ComplexParam c111 = new ComplexParam();
	            c111.setLogic(ComplexParam.AND);
	            c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 70));
	            c11.getComplexParams().add(c111);
	            ComplexParam c112 = new ComplexParam();
	            c112.setLogic(ComplexParam.AND);
	            c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 75));
	            c11.getComplexParams().add(c112);
	            c1.getComplexParams().add(c11);

	            //节点付款----（monthlyPayment>=70 and monthlyPayment <75）
	            ComplexParam c12 = new ComplexParam();
	            c12.setLogic(ComplexParam.OR);
	            ComplexParam c121 = new ComplexParam();
	            c121.setLogic(ComplexParam.AND);
	            c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 70));
	            c12.getComplexParams().add(c121);
	            ComplexParam c122 = new ComplexParam();
	            c122.setLogic(ComplexParam.AND);
	            c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 75));
	            c12.getComplexParams().add(c122);
	            c1.getComplexParams().add(c12);

	            param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("75-80")){
	            ComplexParam c1 = new ComplexParam();
	            c1.setLogic(ComplexParam.AND);

	            //月度付款----（monthlyPayment>=70 and monthlyPayment <75）
	            ComplexParam c11 = new ComplexParam();
	            c11.setLogic(ComplexParam.OR);
	            ComplexParam c111 = new ComplexParam();
	            c111.setLogic(ComplexParam.AND);
	            c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 75));
	            c11.getComplexParams().add(c111);
	            ComplexParam c112 = new ComplexParam();
	            c112.setLogic(ComplexParam.AND);
	            c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 80));
	            c11.getComplexParams().add(c112);
	            c1.getComplexParams().add(c11);

	            //节点付款----（monthlyPayment>=70 and monthlyPayment <75）
	            ComplexParam c12 = new ComplexParam();
	            c12.setLogic(ComplexParam.OR);
	            ComplexParam c121 = new ComplexParam();
	            c121.setLogic(ComplexParam.AND);
	            c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 75));
	            c12.getComplexParams().add(c121);
	            ComplexParam c122 = new ComplexParam();
	            c122.setLogic(ComplexParam.AND);
	            c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 80));
	            c12.getComplexParams().add(c122);
	            c1.getComplexParams().add(c12);

	            param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("80以上")){
	            ComplexParam c1 = new ComplexParam();
	            c1.setLogic(ComplexParam.AND);
	            ComplexParam c11 = new ComplexParam();
	            c11.setLogic(ComplexParam.OR);
	            c11.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 80));
	            c1.getComplexParams().add(c11);
	            ComplexParam c12 = new ComplexParam();
	            c12.setLogic(ComplexParam.OR);
	            c12.getParams().put("nodePayment", new Parameter(QueryParam.GE, 80));
	            c1.getComplexParams().add(c12);
	            param.getComplexParams().add(c1);
			}
			if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款") &&
					param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
				param.getParams().remove("monthlyPayment");
				param.getParams().remove("nodePayment");
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				c11.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 0));
				c1.getComplexParams().add(c11);
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				c12.getParams().put("nodePayment", new Parameter(QueryParam.GE, 0));
				c1.getComplexParams().add(c12);
				param.getComplexParams().add(c1);
			}
        	param.getParams().remove("progressPaymentTerms");
		}
		//是否有项目
		if(param.getParams()!=null&&param.getParams().get("hasProject")!=null){
			if("是".equals(param.getParams().get("hasProject").getValue())){
				param.getParams().put("projectId", new Parameter(QueryParam.NE,null));
			}else if("否".equals(param.getParams().get("hasProject").getValue())){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ,null));
			}
			param.getParams().remove("hasProject");
		}
		//履约状态
		if(param.getParams()!=null&&param.getParams().get("performanceStatus")!=null){
			if("无".equals(param.getParams().get("performanceStatus").getValue())){
				String sql = "( (performance_status = '') or (performance_status is null) )";
				param.getParams().put("performanceStatus", new Parameter(QueryParam.SQL,sql));
			}
		}
        IPage<OutcontractEntity> page = service.queryPage(param,false);
        IPage<OutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
		fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("signUnitName");
        fuzzyFields.add("buildUnitName");
        fuzzyFields.add("pricingForm");
        fuzzyFields.add("subcontractingContent");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
        	for(RoleVO roleVO : roleResponse.getData()){
        		if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
        			userSearchFlag = true;
        			break;
        		}
        	}
        }
        if(userSearchFlag){
        	param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
        }else{
	        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
	        UserContext userContextCache =sessionManager.getUserContext();
	        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
	        String authOrgIds = userContextCache.getAuthOrgIds();
	        List<OrgVO> orgVOList = null;
	        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
	            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
	        }else {//pc端查询
	            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
	        }
	        //普通组织 id
	        List<Long> commonOrgIds = new ArrayList<>();
	        //项目部 id
	        List<Long> departmentIds = new ArrayList<>();
	        orgVOList.stream().forEach(org -> {
	            if(5 == org.getOrgType()) {
	                //项目部
	                departmentIds.add(org.getId());
	            } else {
	                //普通组织
	                commonOrgIds.add(org.getId());
	            }
	        });
	        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
	            /** 要求主表有orgId字段，保存单据所属组织 */
	            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
	        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
	            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
	            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
	        }
	        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        //预付款
        if(param.getParams()!=null&&param.getParams().get("advanceCharge")!=null){
        	if("有预付款".equals(param.getParams().get("advanceCharge").getValue())){
        		param.getParams().put("advanceCharge", new Parameter(QueryParam.NE,null));
        	}else{
        		param.getParams().put("advanceCharge", new Parameter(QueryParam.EQ,null));
        	}
        }
        //进度付款条件
        if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
			if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
				param.getParams().put("monthlyPayment", new Parameter(QueryParam.GT,0));
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
				param.getParams().put("nodePayment", new Parameter(QueryParam.GT,0));
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70以下")){
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				c11.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 70));
				c1.getComplexParams().add(c11);
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				c12.getParams().put("nodePayment", new Parameter(QueryParam.LT, 70));
				c1.getComplexParams().add(c12);
				param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70-75")){
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);

				//月度付款----（monthlyPayment>=70 and monthlyPayment <75）
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				ComplexParam c111 = new ComplexParam();
				c111.setLogic(ComplexParam.AND);
				c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 70));
				c11.getComplexParams().add(c111);
				ComplexParam c112 = new ComplexParam();
				c112.setLogic(ComplexParam.AND);
				c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 75));
				c11.getComplexParams().add(c112);
				c1.getComplexParams().add(c11);

				//节点付款----（monthlyPayment>=70 and monthlyPayment <75）
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				ComplexParam c121 = new ComplexParam();
				c121.setLogic(ComplexParam.AND);
				c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 70));
				c12.getComplexParams().add(c121);
				ComplexParam c122 = new ComplexParam();
				c122.setLogic(ComplexParam.AND);
				c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 75));
				c12.getComplexParams().add(c122);
				c1.getComplexParams().add(c12);

				param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("75-80")){
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);

				//月度付款----（monthlyPayment>=70 and monthlyPayment <75）
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				ComplexParam c111 = new ComplexParam();
				c111.setLogic(ComplexParam.AND);
				c111.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 75));
				c11.getComplexParams().add(c111);
				ComplexParam c112 = new ComplexParam();
				c112.setLogic(ComplexParam.AND);
				c112.getParams().put("monthlyPayment", new Parameter(QueryParam.LT, 80));
				c11.getComplexParams().add(c112);
				c1.getComplexParams().add(c11);

				//节点付款----（monthlyPayment>=70 and monthlyPayment <75）
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				ComplexParam c121 = new ComplexParam();
				c121.setLogic(ComplexParam.AND);
				c121.getParams().put("nodePayment", new Parameter(QueryParam.GE, 75));
				c12.getComplexParams().add(c121);
				ComplexParam c122 = new ComplexParam();
				c122.setLogic(ComplexParam.AND);
				c122.getParams().put("nodePayment", new Parameter(QueryParam.LT, 80));
				c12.getComplexParams().add(c122);
				c1.getComplexParams().add(c12);

				param.getComplexParams().add(c1);
			}else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("80以上")){
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				c11.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 80));
				c1.getComplexParams().add(c11);
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				c12.getParams().put("nodePayment", new Parameter(QueryParam.GE, 80));
				c1.getComplexParams().add(c12);
				param.getComplexParams().add(c1);
			}
			if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款") &&
					param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
				param.getParams().remove("monthlyPayment");
				param.getParams().remove("nodePayment");
				ComplexParam c1 = new ComplexParam();
				c1.setLogic(ComplexParam.AND);
				ComplexParam c11 = new ComplexParam();
				c11.setLogic(ComplexParam.OR);
				c11.getParams().put("monthlyPayment", new Parameter(QueryParam.GE, 0));
				c1.getComplexParams().add(c11);
				ComplexParam c12 = new ComplexParam();
				c12.setLogic(ComplexParam.OR);
				c12.getParams().put("nodePayment", new Parameter(QueryParam.GE, 0));
				c1.getComplexParams().add(c12);
				param.getComplexParams().add(c1);
			}
			param.getParams().remove("progressPaymentTerms");
        }

		//履约状态
		if(param.getParams()!=null&&param.getParams().get("performanceStatus")!=null){
			if("无".equals(param.getParams().get("performanceStatus").getValue())){
				String sql = "( (performance_status = '') or (performance_status is null) )";
				param.getParams().put("performanceStatus", new Parameter(QueryParam.SQL,sql));
			}
		}
		//是否有项目
		if(param.getParams()!=null&&param.getParams().get("hasProject")!=null){
			if("是".equals(param.getParams().get("hasProject").getValue())){
				param.getParams().put("projectId", new Parameter(QueryParam.NE,null));
			}else if("否".equals(param.getParams().get("hasProject").getValue())){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ,null));
			}
			param.getParams().remove("hasProject");
		}
        List<OutcontractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OutcontractVO> vos = new ArrayList<>();
        String type = "";
        String templateName = "承包合同信息";
        String exportXlsx = "outcontract-export.xlsx";
        if(param.getParams()!=null&&param.getParams().get("type")!=null){
        	type = param.getParams().get("type").getValue().toString();
        }
		if("劳务分包".equals(type)){
			templateName = "劳务分包合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}else if("专业分包".equals(type)){
			templateName = "专业分包合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}else if("物资采购".equals(type)){
			templateName = "物资采购合同信息";
			exportXlsx = "outcontract-export1.xlsx";
		}else if("机械租赁".equals(type)){
			templateName = "机械租赁合同信息";
			exportXlsx = "outcontract-export1.xlsx";
		}else if("周转材租赁".equals(type)){
			templateName = "周转材租赁合同信息";
			exportXlsx = "outcontract-export1.xlsx";
		}else if("设计勘察".equals(type)){
			templateName = "设计勘察合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}else if("咨询服务".equals(type)){
			templateName = "咨询服务合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}else if("其它合同".equals(type)){
			templateName = "其它合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}else if("课题支出类合同".equals(type)){
			templateName = "课题支出类合同信息";
			exportXlsx = "outcontract-export.xlsx";
		}
        for(OutcontractEntity entity : list){
        	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
        	if(vo.getSignDate()!=null){
        		vo.setSignDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSignDate()));
        	}
        	if(vo.getChangeState()!=null){
        		if("1".equals(vo.getChangeState())){
        			vo.setChangeStateName("未变更");
        		}else if("2".equals(vo.getChangeState())){
        			vo.setChangeStateName("变更中");
        		}else if("3".equals(vo.getChangeState())){
        			vo.setChangeStateName("已变更");
        		}
        	}
        	vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        	vos.add(vo);
        }
        beans.put("templateName", templateName);
        beans.put("records", vos);
        ExcelExport.getInstance().export(exportXlsx, beans, response);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutcontractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutcontractVO>> refOutcontractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {

        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");

        param.getOrderMap().put("createTime", QueryParam.DESC);

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);

        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
            	param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.get("type")!=null){
				param.getParams().put("type", new Parameter(QueryParam.IN, _con.get("type")));
            }
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        IPage<OutcontractEntity> page = service.queryPage(param,false);
        IPage<OutcontractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description saveintegratedCode 保存一体化编码
     */
    @RequestMapping(value = "/saveintegratedCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutcontractVO> saveintegratedCode(@RequestBody OutcontractVO saveorUpdateVO) {
    	OutcontractEntity entity = service.selectById(saveorUpdateVO.getId());
    	entity.setIntegratedCode(saveorUpdateVO.getIntegratedCode());
    	service.saveOrUpdate(entity, false);
    	OutcontractVO vo = BeanMapper.map(entity, OutcontractVO.class);
    	vo.setOutcontractSupplierList(saveorUpdateVO.getOutcontractSupplierList());
		if(vo.getOutcontractSubcontractUnitPriceList()!=null&&vo.getOutcontractSubcontractUnitPriceList().size()>0){
			vo.setOutcontractSubcontractUnitPriceList(createTreeData(vo.getOutcontractSubcontractUnitPriceList()));
		}
		return CommonResponse.success("保存一体化编码成功", vo);
    }


	public static List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
		List<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(OutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}

        for(int i =0; i<list.size(); i++) {
        	OutcontractSubcontractUnitPriceVO item = list.get(i);
        	String parentId = (item.getPid() != null) ? item.getPid().toString():"";
        	OutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OutcontractSubcontractUnitPriceVO> child = (List<OutcontractSubcontractUnitPriceVO>) parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }

        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }

		return resp;
	}

    /**
     * @Description 根据合同查询清单子表内容
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/querySubUnitPriceListByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutcontractSubcontractUnitPriceVO>> querySubUnitPriceListByContractId(@RequestParam Long contractId) {
    	QueryWrapper<OutcontractSubcontractUnitPriceEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("outcontract_id", contractId);
    	queryWrapper.eq("dr", 0);
		List<OutcontractSubcontractUnitPriceEntity> list = outcontractSubcontractUnitPriceService.list(queryWrapper);
		List<OutcontractSubcontractUnitPriceVO> result = new ArrayList<>();
		if(list!=null&&list.size()>0){
			result = createTreeData(BeanMapper.mapList(list, OutcontractSubcontractUnitPriceVO.class));
		}
        return CommonResponse.success("查询数据成功！",result);
    }

    /**
     * @Description 根据合同查询清单子表内容
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/queryOutcontractMaterialByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutcontractMaterialVO>> queryOutcontractMaterialByContractId(@RequestParam Long contractId) {
    	QueryParam param = new QueryParam();
    	param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, contractId));
        List<OutcontractMaterialEntity> entitys = outcontractMaterialService.queryList(param);
        List<OutcontractMaterialVO> list = BeanMapper.mapList(entitys, OutcontractMaterialVO.class);
        return CommonResponse.success("查询数据成功！",list);
    }

    /**
     * @Description 参照---物资（周转材）合同价
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutcontractMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutcontractMaterialVO>> refOutcontractMaterialList(@RequestParam Integer pageNumber,
    		@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");

        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("contractId")!=null){
            	param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
        }
        IPage<OutcontractMaterialEntity> page = outcontractMaterialService.queryPage(param,false);
        IPage<OutcontractMaterialVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractMaterialVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description 参照---设备租金明细表
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOutcontractEquipmentRentList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutcontractEquipmentRentVO>> refOutcontractEquipmentRentList(@RequestParam Integer pageNumber,
    		@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {

        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentSpec");
        fuzzyFields.add("equipmentUnit");

        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("contractId")!=null){
            	param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
        }
        IPage<OutcontractEquipmentRentEntity> page = outcontractEquipmentRentService.queryPage(param,false);
        IPage<OutcontractEquipmentRentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutcontractEquipmentRentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

	/**
	 * excel导入
	 *
	 * @param request
	 * @return
	 */
	@SuppressWarnings({ "deprecation", "unchecked" })
	@RequestMapping(value = "/excelImportContract", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImportContract(HttpServletRequest request, HttpServletResponse response) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		Long tenantId = InvocationInfoProxy.getTenantid();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }

		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			//只读第一页（sheet）
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {

				Map<String,Long> orgMap = new HashMap<>();

				for(int i=0;i<result.size();i++) {
					OutcontractEntity outcontractVO = new OutcontractEntity();
					try{
						outcontractVO.setChangeState("1");
						outcontractVO.setBillState(1);
						List<String> datas = result.get(i);

						outcontractVO.setType(datas.get(0));//类型
			    		String code = "";
			    		if("劳务分包".equals(datas.get(0))){
			    			code = LABOROUTCONTRACT_BILL_CODE;
			    		}else if("专业分包".equals(datas.get(0))){
			    			code = MAJOROUTCONTRACT_BILL_CODE;
			    		}else if("物资采购".equals(datas.get(0))){
			    			code = MATERIALOUTCONTRACT_BILL_CODE;
			    		}else if("机械租赁".equals(datas.get(0))){
			    			code = EQUIPMENTOUTCONTRACT_BILL_CODE;
			    		}else if("周转材租赁".equals(datas.get(0))){
			    			code = TURNOVERMATERIALOUTCONTRACT_BILL_CODE;
			    		}else if("设计勘察".equals(datas.get(0))){
			    			code = DESIGNOUTCONTRACT_BILL_CODE;
			    		}else if("咨询服务".equals(datas.get(0))){
			    			code = CONSULTANCYOUTCONTRACT_BILL_CODE;
			    		}else if("其它合同".equals(datas.get(0))){
			    			code = OTHEROUTCONTRACT;
			    		}

						if(StringUtils.isNotEmpty(datas.get(1))){
							outcontractVO.setBillCode(datas.get(1));//合同编号
						}else{
				            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(code, InvocationInfoProxy.getTenantid());
				            if(billCode.isSuccess()) {
				            	outcontractVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				            }
						}

						outcontractVO.setIntegratedCode(datas.get(2));//一体化编号

						if(StringUtils.isEmpty(datas.get(3))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：项目名称不能为空！");
//							continue;
						}else{
							outcontractVO.setProjectName(datas.get(3));
							Map<String,Object> param = new HashMap<>();
							param.put("projectName", datas.get(3));
							CommonResponse<ProjectVO> project = zjkjProjectApi.queryDetailByparam(param);
							if(project.isSuccess()&&project.getData()!=null){
								outcontractVO.setProjectId(project.getData().getId());
								outcontractVO.setOrgId(project.getData().getOrgId());
								outcontractVO.setOrgName(project.getData().getOrgName());//所属组织(等同实施单位)
								outcontractVO.setProjectDepartmentId(project.getData().getProjectDepartmentId());
							}else{
								logger.info("项目未获取到,data:{},    msg:{}",project.getData(),project.getMsg());
								errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：项目未获取到！");
								continue;
							}
						}

						outcontractVO.setContractName(datas.get(4));//合同名称

						if(StringUtils.isEmpty(datas.get(4))){
							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：供方单位不能为空！");
							continue;
						}else{
							outcontractVO.setSupplierName(datas.get(5));//供方单位
							Map<String, Object> params = new HashMap<>();
							params.put("name", datas.get(5));
							params.put("tenantId", tenantId);

							CommonResponse<SupplierVO> supplier = shareSupplierApi.findOneByName(datas.get(5), tenantId);
							if(supplier.isSuccess()&&supplier.getData()!=null){
								outcontractVO.setSupplier(supplier.getData().getId());//供方单位
								outcontractVO.setSupplierName(supplier.getData().getName());//分供商名称
								outcontractVO.setSupplierTaxPayerType(supplier.getData().getTaxPayerType());//纳税人类型
								if(StringUtils.isNotEmpty(datas.get(6))){
									outcontractVO.setSupplierSocialCreditCode(datas.get(6));//统一社会信用代码
								}else{
									outcontractVO.setSupplierSocialCreditCode(supplier.getData().getSocialCreditCode());//统一社会信用代码
								}

								outcontractVO.setSupplierBank(supplier.getData().getBankName());//开户行
								outcontractVO.setSupplierBankAccount(supplier.getData().getBankAccount());//开户行账号
								outcontractVO.setSupplierContactUser(supplier.getData().getLegal());// 联系人
								outcontractVO.setSupplierContactUserAddress(supplier.getData().getArea());//联系人地址
								outcontractVO.setSupplierContactUserPhone(supplier.getData().getTelephone());//联系人电话
//								outcontractVO.setSupplierContactUserEmail(supplier.getData().getId());//联系人邮箱
								outcontractVO.setSupplierLegal(supplier.getData().getLegal());//法定代表人
//								outcontractVO.setSupplierTelephone(supplier.getData().getId());//供方电话

							}else{
								logger.info("供方单位未获取到-----------》名称:{}, msg:{}",datas.get(5),supplier.getMsg());
								errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：供方单位未获取到！");
								continue;
							}
						}

						outcontractVO.setSubcontractStatus(datas.get(7));//分包状态
						if(StringUtils.isNotEmpty(datas.get(8))){
							logger.info("签约日期：------------->"+datas.get(8));
							if(datas.get(8).contains("-")){
								outcontractVO.setSignDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(8)));//签约日期
							}else{
								outcontractVO.setSignDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(8)));//签约日期
							}
						}

						if(StringUtils.isEmpty(datas.get(9))){
//							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：签约单位不能为空！");
//							continue;
						}else{
							outcontractVO.setSignUnitName(datas.get(9));//签约单位
							if(orgMap.get(datas.get(9))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(9), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									outcontractVO.setSignUnit(orgVO.getData().getId());//签约单位
									orgMap.put(datas.get(9), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：签约单位未获取到！");
									continue;
								}
							}else{
								outcontractVO.setSignUnit(orgMap.get(datas.get(9)));//签约单位
							}
						}

						if(StringUtils.isEmpty(datas.get(10))){
//							errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：实施单位不能为空！");
//							continue;
						}else{
							outcontractVO.setBuildUnitName(datas.get(10));//实施单位
							if(orgMap.get(datas.get(10))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(10), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									outcontractVO.setBuildUnit(orgVO.getData().getId());//实施单位
									orgMap.put(datas.get(10), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：实施单位未获取到！");
									continue;
								}
							}else{
								outcontractVO.setBuildUnit(orgMap.get(datas.get(10)));//实施单位
							}
						}
						outcontractVO.setBuildArea(StringUtils.isNotBlank(datas.get(11))?new BigDecimal(datas.get(11)):null);//建筑面积（平米）

						outcontractVO.setSubcontractingContent(datas.get(12));//分包内容
						if(StringUtils.isNotEmpty(datas.get(13))){
							outcontractVO.setLaborSubcontracteMode(datas.get(13));//劳务分包方式
						}
						if(StringUtils.isNotEmpty(datas.get(14))){
							outcontractVO.setLaborSubcontracteMode(datas.get(14));//分包方式
						}

						outcontractVO.setContractPrice(StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null);//合同额（元）
						outcontractVO.setContractAreaUnitPrice(StringUtils.isNotBlank(datas.get(16))?new BigDecimal(datas.get(16)):null);//合同建筑面积单价（元/平米）

						outcontractVO.setPricingForm(datas.get(17));//计价形式
						outcontractVO.setAdvanceCharge(datas.get(18));//预付款
						outcontractVO.setMonthlyPayment(StringUtils.isNotBlank(datas.get(19))?new BigDecimal(datas.get(19)):null);//	月度付款
						outcontractVO.setNodePayment(StringUtils.isNotBlank(datas.get(20))?new BigDecimal(datas.get(20)):null);//节点付款
						outcontractVO.setPaymentProportion(StringUtils.isNotBlank(datas.get(21))?new BigDecimal(datas.get(21)):null);//付款比例

						outcontractVO.setAfterCompletionPayment(datas.get(22));//竣工后付款
						outcontractVO.setBalancePayment(datas.get(23));//尾款
						outcontractVO.setWarrantyDeposit(datas.get(24));//保修金
						outcontractVO.setPerformanceStatus(datas.get(25));//履约状态
						if(StringUtils.isNotEmpty(datas.get(26))){
							logger.info("进场日期：------------->"+datas.get(26));
							if(datas.get(26).contains("-")){
								outcontractVO.setMobilizationDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(26)));//进场日期
							}else{
								outcontractVO.setMobilizationDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(26)));//进场日期
							}
						}
						if(StringUtils.isNotEmpty(datas.get(27))){
							logger.info("退场日期：------------->"+datas.get(27));
							if(datas.get(27).contains("-")){
								outcontractVO.setExitDate(new SimpleDateFormat("yyyy-MM-dd").parse(datas.get(27)));//退场日期
							}else{
								outcontractVO.setExitDate(new SimpleDateFormat("yyyy/MM/dd").parse(datas.get(27)));//退场日期
							}
						}
						outcontractVO.setAdoptText(datas.get(28));//采用文本
						outcontractVO.setQualityStandard(datas.get(29));//质量标准
						outcontractVO.setRemark(datas.get(30));//备注

						if(StringUtils.isNotEmpty(datas.get(31))){
							outcontractVO.setOrgName(datas.get(31));//所属组织
							if(orgMap.get(datas.get(31))==null){
								CommonResponse<OrgVO> orgVO = iOrgApi.findByNameAndTenantId(datas.get(31), InvocationInfoProxy.getTenantid());
								if(orgVO.isSuccess()&&orgVO.getData()!=null){
									outcontractVO.setOrgId(orgVO.getData().getId());//所属组织
									orgMap.put(datas.get(31), orgVO.getData().getId());
								}else{
									errorList.add("第"+i+"行数据：" + datas.toString()+"导入失败，原因：所属组织未获取到！");
									continue;
								}
							}else{
								outcontractVO.setOrgId(orgMap.get(datas.get(18)));//所属组织
							}
						}else{
						}
						service.saveOrUpdate(outcontractVO, false);
					}catch(Exception e){
						errorList.add("第"+i+"行数据：" + "导入失败，原因：" + e.getMessage());
						logger.error("导入异常-------------》{}",e);
					}

				}
			}
			if(errorList.size() > 0) {

				errorList.add("导入成功："+(result.size() - errorList.size() - 1)+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}

	/**
	 * @Description saveOrUpdate 修改履约状态
	 */
	@GetMapping(value = "/changePerformanceStatus")
	@ResponseBody
	public CommonResponse<String> changePerformanceStatus(@RequestParam(value = "id") Long id ,@RequestParam(value = "performanceStatus") String performanceStatus ) {

		return service.changePerformanceStatus(id,performanceStatus);
	}

	/**
	 * @Description saveOrUpdate 修改进出场日期
	 */
	@GetMapping(value = "/changeDate")
	@ResponseBody
	public CommonResponse<String> changeDate(@RequestParam(value = "id") Long id ,@RequestParam(value = "type") String type ,@RequestParam(value = "date") Date date ) {

		return service.changeDate(id,type,date);
	}

	/**
	 * @Description saveOrUpdate 归档
	 */
	@RequestMapping(value = "/file", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> file(@RequestBody OutcontractVO outcontractVO){
		return service.file(outcontractVO);
	}

	/**
	 * @Description 参照---供应商
	 * @Return void
	 */
	@RequestMapping(value = "/refSupplierList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<OutcontractSupplierVO>> refSupplierList(@RequestParam Integer pageNumber,
		@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {

		Map<String,Object> params = new HashMap<>();
		long startLine = (pageNumber < 1 ? 0 : pageNumber -  1) * pageSize;
		params.put("startLine", startLine);
		params.put("pageIndex", pageNumber);
		params.put("pageSize", pageSize);
		params.put("searchText", searchText);
		params.put("tenantId", InvocationInfoProxy.getTenantid());

		if(StringUtils.isNotEmpty(condition)){
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("projectId")!=null){
				params.put("projectId", _con.get("projectId"));
			}
			if(_con.get("contractId")!=null){
				params.put("contractId", _con.get("contractId"));
			}
			if(_con.get("type")!=null){
				String[] types = _con.getString("type").split(",");
				params.put("type", new ArrayList<>(Arrays.asList(types)));
			}
		}
		IPage<OutcontractSupplierVO> page = service.refSupplierList(params);

		return CommonResponse.success("查询参照数据成功！",page);
	}

}
