package com.ejianc.foundation.outcontract.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.*;
import com.ejianc.foundation.outcontract.service.*;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.util.ExcelUtilManySheet;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.RecordOutcontractVO;

/**
 * 记录分供方合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("recordOutcontract")
public class RecordOutcontractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IRecordOutcontractService service;
    @Autowired
    private IChangeOutcontractService changeService;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOutcontractSubcontractUnitPriceService outcontractSubcontractUnitPriceService;

    @Autowired
    private IOutcontractMaterialService outcontractMaterialService;

    @Autowired
    private IOutcontractEquipmentRentService outcontractEquipmentRentService;

    @Autowired
    private IChangeOutcontractSubcontractUnitPriceService outcontractChangeSubcontractUnitPriceService;

    @Autowired
    private IChangeOutcontractMaterialService outcontractChangeMaterialService;

    @Autowired
    private IChangeOutcontractEquipmentRentService outcontractChangeEquipmentRentService;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecordOutcontractVO> queryDetail(Long id) {
    	RecordOutcontractEntity entity = service.selectById(id);
    	RecordOutcontractVO vo = BeanMapper.map(entity, RecordOutcontractVO.class);
    	List<RecordOutcontractSupplierVO> recordOutcontractSupplierList = new ArrayList<>();
    	RecordOutcontractSupplierVO outcontractSupplierVO = BeanMapper.map(entity, RecordOutcontractSupplierVO.class);
    	outcontractSupplierVO.setRowState("add");
    	recordOutcontractSupplierList.add(outcontractSupplierVO);
		vo.setRecordOutcontractSupplierList(recordOutcontractSupplierList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RecordOutcontractVO>> queryList(@RequestBody QueryParam param) {
        Map<String,Object> params = new HashMap<>();
        long startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() -  1) * param.getPageSize();
        params.put("startLine", startLine);
        params.put("pageIndex", param.getPageIndex());
        params.put("pageSize", param.getPageSize());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params = this.dealParam(params, param);
        IPage<RecordOutcontractVO> page = service.queryAllList(params);

        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params = this.dealParam(params, param);
        IPage<RecordOutcontractVO> page = service.queryAllList(params);
        List<RecordOutcontractVO> list = page.getRecords();
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        for(RecordOutcontractVO vo : list){
            if(vo.getSignDate()!=null){
                vo.setSignDateShow(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSignDate()));
            }
            if(vo.getChangeState()!=null){
                if("1".equals(vo.getChangeState())){
                    vo.setChangeStateName("未变更");
                }else if("2".equals(vo.getChangeState())){
                    vo.setChangeStateName("变更中");
                }else if("3".equals(vo.getChangeState())){
                    vo.setChangeStateName("已变更");
                }
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("alloutcontract-export.xlsx", beans, response);
    }

    private Map<String,Object> dealParam(Map<String, Object> params, QueryParam param){
        if(StringUtils.isNotBlank(param.getSearchText())){
            params.put("searchText", param.getSearchText());
        }
        if(param.getOrderMap()!=null&&param.getOrderMap().size()>0){
            String sql = " order by ";
            for(String key : param.getOrderMap().keySet()){
                sql += ( " d." +key + " " + param.getOrderMap().get(key) + " ");
            }
            params.put("ordersql", sql);
        }
        boolean userSearchFlag = false;
        //判断当前用户是否是个性查询
        CommonResponse<List<RoleVO>> roleResponse = roleApi.queryRoleByUserId(InvocationInfoProxy.getUserid());
        if(roleResponse.isSuccess()&&roleResponse.getData()!=null){
            for(RoleVO roleVO : roleResponse.getData()){
                if("ZJKJ-CONTRSCT-SEARCH-USER".equals(roleVO.getCode())){
                    userSearchFlag = true;
                    break;
                }
            }
        }
        if(userSearchFlag){
//            param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getUserCode()));
            params.put("createUserCode", sessionManager.getUserContext().getUserCode());
        }else{
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                params.put("orgIds", commonOrgIds);
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                params.put("projectDepartmentIds", departmentIds);
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //承包类型
        if(param.getParams()!=null&&param.getParams().get("type")!=null){
            String[] type = param.getParams().get("type").getValue().toString().split(",");
            params.put("type", Arrays.asList(type));
        }
        //项目名称
        if(param.getParams()!=null&&param.getParams().get("projectId")!=null){
            params.put("projectId", param.getParams().get("projectId").getValue());
        }
        //发包人
        if(param.getParams()!=null&&param.getParams().get("supplier")!=null){
            params.put("supplier", param.getParams().get("supplier").getValue());
        }
        //实施单位
        if(param.getParams()!=null&&param.getParams().get("buildUnit")!=null){
            params.put("buildUnit", param.getParams().get("buildUnit").getValue());
        }
        //签约单位
        if(param.getParams()!=null&&param.getParams().get("signUnit")!=null){
            params.put("signUnit", param.getParams().get("signUnit").getValue());
        }
        //计价形式
        if(param.getParams()!=null&&param.getParams().get("pricingForm")!=null){
            String[] pricingForm = param.getParams().get("pricingForm").getValue().toString().split(",");
            params.put("pricingForm", Arrays.asList(pricingForm));
        }
        //签约日期
        if(param.getParams()!=null&&param.getParams().get("signDate")!=null){
            String[] signDate = param.getParams().get("signDate").getValue().toString().split(",");
            String sql = "( sign_date BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("signDate", sql);
            String sql1 = "( supplementary_sign_time BETWEEN '"+ signDate[0] +"' and  '"+ signDate[1] +"')";
            params.put("supplementarySignTime", sql1);
        }
        //补充签订时间
//        if(param.getParams()!=null&&param.getParams().get("supplementarySignTime")!=null){
//            String[] supplementarySignTime = param.getParams().get("supplementarySignTime").getValue().toString().split(",");
//            String sql = "( d.supplementarySignTime BETWEEN '"+ supplementarySignTime[0] +"' and  '"+ supplementarySignTime[1] +"')";
//            params.put("supplementarySignTime", sql);
//        }
        //预付款
        if(param.getParams()!=null&&param.getParams().get("advanceCharge")!=null){
            if("有预付款".equals(param.getParams().get("advanceCharge").getValue())){
                String sql = "( d.advanceCharge is not null)";
                params.put("advancePaymentProportion", sql);
            }else{
                String sql = "( d.advanceCharge is null )";
                params.put("advancePaymentProportion", sql);
            }
        }
//		70%以下、70%（含）-75%、75%（含）-80%、80%(含）以上
        if(param.getParams()!=null&&param.getParams().get("progressPaymentTerms")!=null){
            if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("月度付款")){
                String sql = "( d.monthlyPayment > 0)";
                params.put("monthlyPayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("节点付款")){
                String sql = "( d.nodePayment > 0)";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70以下")){
                String sql = "( d.nodePayment < 70 or d.monthlyPayment < 70 )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("70-75")){
                String sql = "( (d.nodePayment >= 70 and d.nodePayment < 75) or (d.monthlyPayment >= 70 and d.monthlyPayment <75) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("75-80")){
                String sql = "( (d.nodePayment >= 75 and d.nodePayment < 80) or (d.monthlyPayment >= 75 and d.monthlyPayment <80) )";
                params.put("nodePayment", sql);
            }else if(param.getParams().get("progressPaymentTerms").getValue().toString().contains("80以上")){
                String sql = "( d.nodePayment >= 80 or d.monthlyPayment >= 80 )";
                params.put("nodePayment", sql);
            }
            param.getParams().remove("progressPaymentTerms");
        }
        //履约状态
        if(param.getParams()!=null&&param.getParams().get("performanceStatus")!=null){
            params.put("performanceStatus", param.getParams().get("performanceStatus").getValue());
        }
        if(param.getParams()!=null&&param.getParams().get("supplementary")!=null){
            params.put("supplementary", param.getParams().get("supplementary").getValue());
        }
        //提交时间
        if(param.getParams()!=null&&param.getParams().get("submitDate")!=null){
            String[] supplementarySignTime = param.getParams().get("submitDate").getValue().toString().split(",");
            String sql = "( d.submitDate BETWEEN '"+ supplementarySignTime[0] +"' and  '"+ supplementarySignTime[1] +"')";
            params.put("submitDate", sql);
        }
        //审批通过时间
        if(param.getParams()!=null&&param.getParams().get("passedDate")!=null){
            String[] supplementarySignTime = param.getParams().get("passedDate").getValue().toString().split(",");
            String sql = "( d.passedDate BETWEEN '"+ supplementarySignTime[0] +"' and  '"+ supplementarySignTime[1] +"')";
            params.put("passedDate", sql);
        }

        //项目分类
        if(param.getParams()!=null&&param.getParams().get("projectClassify")!=null){
            CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
            List<String> noExitProjectName = new ArrayList<>();
            if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
                defdocResponse.getData().forEach(item -> {
                    noExitProjectName.add(item.getName());
                });
            }
            String projectClassify = param.getParams().get("projectClassify").getValue().toString();
            //虚拟--virtually
            if(projectClassify.contains("virtually") && projectClassify.contains("physical") && projectClassify.contains("noproject")){
                //全部
            }else if(projectClassify.contains("physical") && projectClassify.contains("noproject")){
                //非虚拟+空
                if(noExitProjectName!=null && noExitProjectName.size()>0){
                    String sql = " and (d.projectName not in ("+'"'+String.join(('"'+","+'"'),noExitProjectName)+'"'+") or d.projectId is null)";
                    params.put("projectClassify", sql);
                }else{
                    //没有值，说明数据只有非虚拟+空，所以不需要单独写逻辑
                }
            }else if(projectClassify.contains("virtually") && projectClassify.contains("noproject")){
                //虚拟+空
                if(noExitProjectName!=null && noExitProjectName.size()>0){
                    String sql = " and (d.projectName in ("+'"'+String.join(('"'+","+'"'),noExitProjectName)+'"'+") or d.projectId is null)";
                    params.put("projectClassify", sql);
                }else{
                    String sql = "and d.projectId is null";
                    params.put("projectClassify", sql);
                }
            }else if(projectClassify.contains("virtually") && projectClassify.contains("physical")){
                //虚拟+非虚拟
                String sql = "and d.projectId is not null";
                params.put("projectClassify", sql);
            }else if(projectClassify.contains("virtually")){
                String sql = " and d.projectName in ("+'"'+String.join(('"'+","+'"'),noExitProjectName)+'"'+")";
                params.put("projectClassify", sql);
            }else if(projectClassify.contains("physical")){
                if(noExitProjectName!=null && noExitProjectName.size()>0){
                    String sql = " and d.projectName not in ("+'"'+String.join(('"'+","+'"'),noExitProjectName)+'"'+")";
                    params.put("projectClassify", sql);
                }
            }else if(projectClassify.contains("noproject")){
                String sql = "and d.projectId is null";
                params.put("projectClassify", sql);
            }
        }
        return params;
    }

    /**
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExportList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportList(@RequestBody List<RecordOutcontractVO> vos, HttpServletResponse response){
        //获取导出的数据
        if(vos==null){
            throw new BusinessException("请选择要导出的数据");
        }
        if(vos.size()>10){
            throw new BusinessException("最多导出10条数据，请重新选择");
        }

        List<String> sheetsName = new ArrayList<>();
        List<String> titleNames = new ArrayList<>();
        List<List<List<Object>>> datas = new ArrayList<>();
        for(RecordOutcontractVO vo : vos){
            List<List<Object>> data = new ArrayList<>();
            String contractName = vo.getContractName();
            if (!"合同".equals(vo.getBooktype())) {
                contractName += "-补充协议";
                switch (vo.getType()){
                    case "劳务分包":
                    case "专业分包":
                        titleNames.add("分包工程综合单价计价表");
                        QueryWrapper<ChangeOutcontractSubcontractUnitPriceEntity> childWrapper1 = new QueryWrapper<>();
                        childWrapper1.eq("change_outcontract_id", vo.getId());
                        childWrapper1.eq("dr", 0);
                        childWrapper1.orderByAsc("list_code");
                        List<ChangeOutcontractSubcontractUnitPriceEntity> childList1 = outcontractChangeSubcontractUnitPriceService.list(childWrapper1);
                        List<Object> child1 = new ArrayList<>();
                        child1.add("清单编号");child1.add("项目");child1.add("工作内容");child1.add("项目特征");child1.add("单位");
                        child1.add("工程量");child1.add("综合单价");child1.add("合计");child1.add("人工费");child1.add("主材费");
                        child1.add("材料损耗");child1.add("辅材费");child1.add("机械费");child1.add("管理费");child1.add("利润");
                        child1.add("规费");child1.add("税金");child1.add("主材品牌");child1.add("备注");
                        data.add(child1);
                        if(childList1!=null && childList1.size()>0){
                            for(ChangeOutcontractSubcontractUnitPriceEntity childEntity : childList1){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getListCode());
                                childValue.add(childEntity.getProject());
                                childValue.add(childEntity.getJobContent());
                                childValue.add(childEntity.getProjectCharacteristic());
                                childValue.add(childEntity.getUnit());
                                childValue.add(childEntity.getEngineeringQuantity());
                                childValue.add(childEntity.getComprehensiveUnitPrice());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getLaborCost());
                                childValue.add(childEntity.getMainMaterialCost());
                                childValue.add(childEntity.getMaterialLoss());
                                childValue.add(childEntity.getAuxiliaryMaterialCost());
                                childValue.add(childEntity.getMachineryCost());
                                childValue.add(childEntity.getManagementCost());
                                childValue.add(childEntity.getProfit());
                                childValue.add(childEntity.getPaidGovernmentCost());
                                childValue.add(childEntity.getTax());
                                childValue.add(childEntity.getMainMaterialBrand());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "物资采购":
                        titleNames.add("物资采购--物资");
                        QueryWrapper<ChangeOutcontractMaterialEntity> childWrapper2 = new QueryWrapper<>();
                        childWrapper2.eq("change_outcontract_id", vo.getId());
                        childWrapper2.eq("dr", 0);
                        List<ChangeOutcontractMaterialEntity> childList2 = outcontractChangeMaterialService.list(childWrapper2);
                        List<Object> child2 = new ArrayList<>();
                        child2.add("编码");
                        child2.add("标的名称");
                        child2.add("强度等级");
                        child2.add("规格型号");
                        child2.add("品牌商标");
                        child2.add("计量单位");
                        child2.add("暂定数量");
                        child2.add("不含税单价");
                        child2.add("税金（%）");
                        child2.add("含税单价");
                        child2.add("合价");
                        data.add(child2);
                        if(childList2!=null && childList2.size()>0){
                            for(ChangeOutcontractMaterialEntity childEntity : childList2){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialCode());
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getStrengthGrade());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getBrandTrademark());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getTotalPrice());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "机械租赁":
                        titleNames.add("租金明细表");
                        QueryWrapper<ChangeOutcontractEquipmentRentEntity> childWrapper3 = new QueryWrapper<>();
                        childWrapper3.eq("change_outcontract_id", vo.getId());
                        childWrapper3.eq("dr", 0);
                        List<ChangeOutcontractEquipmentRentEntity> childList3 = outcontractChangeEquipmentRentService.list(childWrapper3);
                        List<Object> child3 = new ArrayList<>();
                        child3.add("设备编码");
                        child3.add("设备名称");
                        child3.add("规格");
                        child3.add("不含税单价（元）");
                        child3.add("含税单价（元）");
                        child3.add("单位");
                        child3.add("台数");
                        child3.add("租赁期（月）");
                        child3.add("税率（%）");
                        child3.add("合价");
                        data.add(child3);
                        if(childList3!=null && childList3.size()>0){
                            for(ChangeOutcontractEquipmentRentEntity childEntity : childList3){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getEquipmentCode());
                                childValue.add(childEntity.getEquipmentName());
                                childValue.add(childEntity.getEquipmentSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getEquipmentUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getLeaseTerm());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "周转材租赁":
                        titleNames.add("周转材租赁--物资");
                        QueryWrapper<ChangeOutcontractMaterialEntity> childWrapper4 = new QueryWrapper<>();
                        childWrapper4.eq("change_outcontract_id", vo.getId());
                        childWrapper4.eq("dr", 0);
                        List<ChangeOutcontractMaterialEntity> childList4 = outcontractChangeMaterialService.list(childWrapper4);
                        List<Object> child4 = new ArrayList<>();
                        child4.add("物资编码");
                        child4.add("物料名称");
                        child4.add("规格");
                        child4.add("不含税单价（元）");
                        child4.add("含税单价（元）");
                        child4.add("单位");
                        child4.add("数量");
                        child4.add("租赁期（天）");
                        child4.add("税率（%）");
                        child4.add("合计");
                        child4.add("备注");
                        data.add(child4);
                        if(childList4!=null && childList4.size()>0){
                            for(ChangeOutcontractMaterialEntity childEntity : childList4){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialCode());
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getLeaseTerm());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "设计勘察":
                        titleNames.add("设计勘察暂无数据");
                        break;
                    case "咨询服务":
                        titleNames.add("咨询服务暂无数据");
                        break;
                    case "其它合同":
                        titleNames.add("其它支出合同--合同价");
                        QueryWrapper<ChangeOutcontractMaterialEntity> childWrapper5 = new QueryWrapper<>();
                        childWrapper5.eq("change_outcontract_id", vo.getId());
                        childWrapper5.eq("dr", 0);
                        List<ChangeOutcontractMaterialEntity> childList5 = outcontractChangeMaterialService.list(childWrapper5);
                        List<Object> child5 = new ArrayList<>();
                        child5.add("名称");
                        child5.add("规格");
                        child5.add("不含税单价（元）");
                        child5.add("含税单价（元）");
                        child5.add("单位");
                        child5.add("数量");
                        child5.add("税金（%）");
                        child5.add("金额（元）");
                        child5.add("备注");
                        data.add(child5);
                        if(childList5!=null && childList5.size()>0){
                            for(ChangeOutcontractMaterialEntity childEntity : childList5){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "课题支出类合同":
                        titleNames.add("课题支出--合同价");
                        QueryWrapper<ChangeOutcontractMaterialEntity> childWrapper6 = new QueryWrapper<>();
                        childWrapper6.eq("change_outcontract_id", vo.getId());
                        childWrapper6.eq("dr", 0);
                        List<ChangeOutcontractMaterialEntity> childList6 = outcontractChangeMaterialService.list(childWrapper6);
                        List<Object> child6 = new ArrayList<>();
                        child6.add("名称");
                        child6.add("规格");
                        child6.add("不含税单价（元）");
                        child6.add("含税单价（元）");
                        child6.add("单位");
                        child6.add("数量");
                        child6.add("税金（%）");
                        child6.add("金额（元）");
                        child6.add("备注");
                        data.add(child6);
                        if(childList6!=null && childList6.size()>0){
                            for(ChangeOutcontractMaterialEntity childEntity : childList6){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                }
            }else{
                switch (vo.getType()){
                    case "劳务分包":
                    case "专业分包":
                        titleNames.add("分包工程综合单价计价表");
                        QueryWrapper<OutcontractSubcontractUnitPriceEntity> childWrapper1 = new QueryWrapper<>();
                        childWrapper1.eq("outcontract_id", vo.getId());
                        childWrapper1.eq("dr", 0);
                        childWrapper1.orderByAsc("list_code");
                        List<OutcontractSubcontractUnitPriceEntity> childList1 = outcontractSubcontractUnitPriceService.list(childWrapper1);
                        List<Object> child1 = new ArrayList<>();
                        child1.add("清单编号");child1.add("项目");child1.add("工作内容");child1.add("项目特征");child1.add("单位");
                        child1.add("工程量");child1.add("综合单价");child1.add("合计");child1.add("人工费");child1.add("主材费");
                        child1.add("材料损耗");child1.add("辅材费");child1.add("机械费");child1.add("管理费");child1.add("利润");
                        child1.add("规费");child1.add("税金");child1.add("主材品牌");child1.add("备注");
                        data.add(child1);
                        if(childList1!=null && childList1.size()>0){
                            for(OutcontractSubcontractUnitPriceEntity childEntity : childList1){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getListCode());
                                childValue.add(childEntity.getProject());
                                childValue.add(childEntity.getJobContent());
                                childValue.add(childEntity.getProjectCharacteristic());
                                childValue.add(childEntity.getUnit());
                                childValue.add(childEntity.getEngineeringQuantity());
                                childValue.add(childEntity.getComprehensiveUnitPrice());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getLaborCost());
                                childValue.add(childEntity.getMainMaterialCost());
                                childValue.add(childEntity.getMaterialLoss());
                                childValue.add(childEntity.getAuxiliaryMaterialCost());
                                childValue.add(childEntity.getMachineryCost());
                                childValue.add(childEntity.getManagementCost());
                                childValue.add(childEntity.getProfit());
                                childValue.add(childEntity.getPaidGovernmentCost());
                                childValue.add(childEntity.getTax());
                                childValue.add(childEntity.getMainMaterialBrand());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "物资采购":
                        titleNames.add("物资采购--物资");
                        QueryWrapper<OutcontractMaterialEntity> childWrapper2 = new QueryWrapper<>();
                        childWrapper2.eq("outcontract_id", vo.getId());
                        childWrapper2.eq("dr", 0);
                        List<OutcontractMaterialEntity> childList2 = outcontractMaterialService.list(childWrapper2);
                        List<Object> child2 = new ArrayList<>();
                        child2.add("编码");
                        child2.add("标的名称");
                        child2.add("强度等级");
                        child2.add("规格型号");
                        child2.add("品牌商标");
                        child2.add("计量单位");
                        child2.add("暂定数量");
                        child2.add("不含税单价");
                        child2.add("税金（%）");
                        child2.add("含税单价");
                        child2.add("合价");
                        data.add(child2);
                        if(childList2!=null && childList2.size()>0){
                            for(OutcontractMaterialEntity childEntity : childList2){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialCode());
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getStrengthGrade());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getBrandTrademark());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getTotalPrice());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "机械租赁":
                        titleNames.add("租金明细表");
                        QueryWrapper<OutcontractEquipmentRentEntity> childWrapper3 = new QueryWrapper<>();
                        childWrapper3.eq("outcontract_id", vo.getId());
                        childWrapper3.eq("dr", 0);
                        List<OutcontractEquipmentRentEntity> childList3 = outcontractEquipmentRentService.list(childWrapper3);
                        List<Object> child3 = new ArrayList<>();
                        child3.add("设备编码");
                        child3.add("设备名称");
                        child3.add("规格");
                        child3.add("不含税单价（元）");
                        child3.add("含税单价（元）");
                        child3.add("单位");
                        child3.add("台数");
                        child3.add("租赁期（月）");
                        child3.add("税率（%）");
                        child3.add("合价");
                        data.add(child3);
                        if(childList3!=null && childList3.size()>0){
                            for(OutcontractEquipmentRentEntity childEntity : childList3){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getEquipmentCode());
                                childValue.add(childEntity.getEquipmentName());
                                childValue.add(childEntity.getEquipmentSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getEquipmentUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getLeaseTerm());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "周转材租赁":
                        titleNames.add("周转材租赁--物资");
                        QueryWrapper<OutcontractMaterialEntity> childWrapper4 = new QueryWrapper<>();
                        childWrapper4.eq("outcontract_id", vo.getId());
                        childWrapper4.eq("dr", 0);
                        List<OutcontractMaterialEntity> childList4 = outcontractMaterialService.list(childWrapper4);
                        List<Object> child4 = new ArrayList<>();
                        child4.add("物资编码");
                        child4.add("物料名称");
                        child4.add("规格");
                        child4.add("不含税单价（元）");
                        child4.add("含税单价（元）");
                        child4.add("单位");
                        child4.add("数量");
                        child4.add("租赁期（天）");
                        child4.add("税率（%）");
                        child4.add("合计");
                        child4.add("备注");
                        data.add(child4);
                        if(childList4!=null && childList4.size()>0){
                            for(OutcontractMaterialEntity childEntity : childList4){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialCode());
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getLeaseTerm());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "设计勘察":
                        titleNames.add("设计勘察暂无数据");
                        break;
                    case "咨询服务":
                        titleNames.add("咨询服务暂无数据");
                        break;
                    case "其它合同":
                        titleNames.add("其它支出合同--合同价");
                        QueryWrapper<OutcontractMaterialEntity> childWrapper5 = new QueryWrapper<>();
                        childWrapper5.eq("outcontract_id", vo.getId());
                        childWrapper5.eq("dr", 0);
                        List<OutcontractMaterialEntity> childList5 = outcontractMaterialService.list(childWrapper5);
                        List<Object> child5 = new ArrayList<>();
                        child5.add("名称");
                        child5.add("规格");
                        child5.add("不含税单价（元）");
                        child5.add("含税单价（元）");
                        child5.add("单位");
                        child5.add("数量");
                        child5.add("税金（%）");
                        child5.add("金额（元）");
                        child5.add("备注");
                        data.add(child5);
                        if(childList5!=null && childList5.size()>0){
                            for(OutcontractMaterialEntity childEntity : childList5){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                    case "课题支出类合同":
                        titleNames.add("课题支出--合同价");
                        QueryWrapper<OutcontractMaterialEntity> childWrapper6 = new QueryWrapper<>();
                        childWrapper6.eq("outcontract_id", vo.getId());
                        childWrapper6.eq("dr", 0);
                        List<OutcontractMaterialEntity> childList6 = outcontractMaterialService.list(childWrapper6);
                        List<Object> child6 = new ArrayList<>();
                        child6.add("名称");
                        child6.add("规格");
                        child6.add("不含税单价（元）");
                        child6.add("含税单价（元）");
                        child6.add("单位");
                        child6.add("数量");
                        child6.add("税金（%）");
                        child6.add("金额（元）");
                        child6.add("备注");
                        data.add(child6);
                        if(childList6!=null && childList6.size()>0){
                            for(OutcontractMaterialEntity childEntity : childList6){
                                List<Object> childValue = new ArrayList<>();
                                childValue.add(childEntity.getMaterialName());
                                childValue.add(childEntity.getMaterialSpec());
                                childValue.add(childEntity.getUntaxUnitPrice());
                                childValue.add(childEntity.getTaxUnitPrice());
                                childValue.add(childEntity.getMaterialUnit());
                                childValue.add(childEntity.getQuantity());
                                childValue.add(childEntity.getTaxRate());
                                childValue.add(childEntity.getTotalPrice());
                                childValue.add(childEntity.getRemark());
                                data.add(childValue);
                            }
                        }
                        break;
                }
            }
            if(sheetsName.contains(contractName)){
                sheetsName.add(contractName + "-" + (sheetsName.size()+1));
            }else{
                sheetsName.add(contractName);
            }
            datas.add(data);
        }

        ExcelUtilManySheet.exportSheets(sheetsName, titleNames, datas, response);
    }
}
