package com.ejianc.business.panhuo.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;


/**
 * 资产表
 * 
 * @author generator
 * 
 */
public class GoodsDetailsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 资产编号
    private Long seller; // 发布人
    private String sellerName; // 发布人名称
    private Long toolId; // 机具主键
    private String mainimgPath; // 资产主图URL
    private Long projectId; // 项目主键
    private Long orgId; // 组织主键
    private String projectName; // 项目名称
    private String orgName; // 组织名称
    private String spec; // 规格型号
    private String shelfType; // 资产类型
    private Long materialId; // 物资主键
    private java.lang.String materialCode; // 物资编号
    private String materialName; // 物资名称
    private Long materialTypeId; // 物资类别
    private String materialTypeName; // 物资类别名称
    private String sourceId; // 物资来源ID
    private Long systemId; // 所属系统ID
    private java.math.BigDecimal originalprice; // 原价
    private java.math.BigDecimal discount; // 折扣
    private String unit; // 单位
    private java.math.BigDecimal price; // 单价
    private java.math.BigDecimal nums; // 数量
    private java.math.BigDecimal sellNums; // 已成交数量
    private java.math.BigDecimal preNums; // 预定中数量
    private java.math.BigDecimal rotatableNums; // 可周转数量(上架-已成交-预定中)
    private java.math.BigDecimal remainingNums; // 剩余数量(上架-已成交)
    private String isPack; // 0-是  1-否
    private Long addressId; // 地址主键
    private String addressName; // 出售项目
    private java.lang.String projectAddress; // 项目地址
    private String address; // 详细地址
    private String firstLocation; // 所在地一级区域
    private String secondLocation; // 所在地二级区域
    private String thirdLocation; // 所在地三级区域
    private String fourthLocation; // 所在地四级区域
    private String location; // 所在地末级区域
    private String phone; // 联系方式
    private String name; // 联系人
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date shelfTime; // 上架时间
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date lowerTime; // 下架时间
    private Integer lowerType; // 下架类型0-手动下架，1-售罄下架，2-到期下架
    private Long lower; // 下架人
    private String details; // 资产详情
    private Integer status; // 资产状态0-在售，1-下架，2-暂存
    private String labelName; // 标签名称

    private int type; // 上架类型 0-手动上架，1-周转上架

    private java.lang.Long orderId; // 订单主键

    private int otherNums; // 项目其他在售数量

    private java.lang.Integer isCollect; // 是否收藏
    private java.lang.Long collectId; // 收藏主键

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    // 标签子表
    private List<LabeldetailVO> labels = new ArrayList<>();

    // 图片子表
    private List<ImgdetailVO> imgsPath = new ArrayList<>();

    // 项目其他在售资产
    private List<GoodsVO> othersGoods = new ArrayList<>();

    // 周转记录
    private List<GoodsToolVO> toolDetails = new ArrayList<>();

    public List<LabeldetailVO> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailVO> labels) {
        this.labels = labels;
    }

    public List<ImgdetailVO> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailVO> imgsPath) {
        this.imgsPath = imgsPath;
    }

    public List<GoodsToolVO> getToolDetails() {
        return toolDetails;
    }

    public void setToolDetails(List<GoodsToolVO> toolDetails) {
        this.toolDetails = toolDetails;
    }

    public List<GoodsVO> getOthersGoods() {
        return othersGoods;
    }

    public void setOthersGoods(List<GoodsVO> othersGoods) {
        this.othersGoods = othersGoods;
    }

    public int getOtherNums() {
        return otherNums;
    }

    public void setOtherNums(int otherNums) {
        this.otherNums = otherNums;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Integer getIsCollect() {
        return isCollect;
    }

    public void setIsCollect(Integer isCollect) {
        this.isCollect = isCollect;
    }

    public Long getCollectId() {
        return collectId;
    }

    public void setCollectId(Long collectId) {
        this.collectId = collectId;
    }

    /**
     * 资产编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 资产编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布人
     */
    public Long getSeller() {
        return seller;
    }

    /**
     * 发布人
     */
    public void setSeller(Long seller) {
        this.seller = seller;
    }
    /**
     * 发布人名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * 发布人名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 机具主键
     */
    public Long getToolId() {
        return toolId;
    }

    /**
     * 机具主键
     */
    public void setToolId(Long toolId) {
        this.toolId = toolId;
    }
    /**
     * 资产主图URL
     */
    public String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 项目主键
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
     */
    public String getShelfType() {
        return shelfType;
    }

    /**
     * 资产类型
     */
    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }
    /**
     * 物资主键
     */
    @ReferSerialTransfer(referCode="Material001")
    public java.lang.Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    @ReferDeserialTransfer
    public void setMaterialId(java.lang.Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资来源ID
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 物资来源ID
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 所属系统ID
     */
    public Long getSystemId() {
        return systemId;
    }

    /**
     * 所属系统ID
     */
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    /**
     * 原价
     */
    public java.math.BigDecimal getOriginalprice() {
        return originalprice;
    }

    /**
     * 原价
     */
    public void setOriginalprice(java.math.BigDecimal originalprice) {
        this.originalprice = originalprice;
    }
    /**
     * 折扣
     */
    public java.math.BigDecimal getDiscount() {
        return discount;
    }

    /**
     * 折扣
     */
    public void setDiscount(java.math.BigDecimal discount) {
        this.discount = discount;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNums() {
        return nums;
    }

    /**
     * 数量
     */
    public void setNums(java.math.BigDecimal nums) {
        this.nums = nums;
    }
    /**
     * 已成交数量
     */
    public java.math.BigDecimal getSellNums() {
        return sellNums;
    }

    /**
     * 已成交数量
     */
    public void setSellNums(java.math.BigDecimal sellNums) {
        this.sellNums = sellNums;
    }
    /**
     * 预定中数量
     */
    public java.math.BigDecimal getPreNums() {
        return preNums;
    }

    /**
     * 预定中数量
     */
    public void setPreNums(java.math.BigDecimal preNums) {
        this.preNums = preNums;
    }
    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public java.math.BigDecimal getRotatableNums() {
        return rotatableNums;
    }

    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public void setRotatableNums(java.math.BigDecimal rotatableNums) {
        this.rotatableNums = rotatableNums;
    }
    /**
     * 剩余数量(上架-已成交)
     */
    public java.math.BigDecimal getRemainingNums() {
        return remainingNums;
    }

    /**
     * 剩余数量(上架-已成交)
     */
    public void setRemainingNums(java.math.BigDecimal remainingNums) {
        this.remainingNums = remainingNums;
    }
    /**
     * 0-是  1-否
     */
    public String getIsPack() {
        return isPack;
    }

    /**
     * 0-是  1-否
     */
    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }
    /**
     * 地址主键
     */
    public Long getAddressId() {
        return addressId;
    }

    /**
     * 地址主键
     */
    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }
    /**
     * 出售项目
     */
    public String getAddressName() {
        return addressName;
    }

    /**
     * 出售项目
     */
    public void setAddressName(String addressName) {
        this.addressName = addressName;
    }
    /**
     * 详细地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 所在地一级区域
     */
    public String getFirstLocation() {
        return firstLocation;
    }

    /**
     * 所在地一级区域
     */
    public void setFirstLocation(String firstLocation) {
        this.firstLocation = firstLocation;
    }
    /**
     * 所在地二级区域
     */
    public String getSecondLocation() {
        return secondLocation;
    }

    /**
     * 所在地二级区域
     */
    public void setSecondLocation(String secondLocation) {
        this.secondLocation = secondLocation;
    }
    /**
     * 所在地三级区域
     */
    public String getThirdLocation() {
        return thirdLocation;
    }

    /**
     * 所在地三级区域
     */
    public void setThirdLocation(String thirdLocation) {
        this.thirdLocation = thirdLocation;
    }
    /**
     * 所在地四级区域
     */
    public String getFourthLocation() {
        return fourthLocation;
    }

    /**
     * 所在地四级区域
     */
    public void setFourthLocation(String fourthLocation) {
        this.fourthLocation = fourthLocation;
    }
    /**
     * 所在地末级区域
     */
    public String getLocation() {
        return location;
    }

    /**
     * 所在地末级区域
     */
    public void setLocation(String location) {
        this.location = location;
    }
    /**
     * 联系方式
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 联系方式
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 联系人
     */
    public String getName() {
        return name;
    }

    /**
     * 联系人
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 上架时间
     */
    public java.util.Date getShelfTime() {
        return shelfTime;
    }

    /**
     * 上架时间
     */
    public void setShelfTime(java.util.Date shelfTime) {
        this.shelfTime = shelfTime;
    }
    /**
     * 下架时间
     */
    public java.util.Date getLowerTime() {
        return lowerTime;
    }

    /**
     * 下架时间
     */
    public void setLowerTime(java.util.Date lowerTime) {
        this.lowerTime = lowerTime;
    }
    /**
     * 下架类型0-手动下架，1-售罄下架，2-到期下架
     */
    public Integer getLowerType() {
        return lowerType;
    }

    /**
     * 下架类型0-手动下架，1-售罄下架，2-到期下架
     */
    public void setLowerType(Integer lowerType) {
        this.lowerType = lowerType;
    }
    /**
     * 下架人
     */
    public Long getLower() {
        return lower;
    }

    /**
     * 下架人
     */
    public void setLower(Long lower) {
        this.lower = lower;
    }
    /**
     * 资产详情
     */
    public String getDetails() {
        return details;
    }

    /**
     * 资产详情
     */
    public void setDetails(String details) {
        this.details = details;
    }
    /**
     * 资产状态0-在售，1-下架，2-暂存
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 资产状态0-在售，1-下架，2-暂存
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 标签名称
     */
    public String getLabelName() {
        return labelName;
    }

    /**
     * 标签名称
     */
    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
    
}
