package com.ejianc.business.panhuo.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_wbuy")
public class WbuyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 求购编号
    @TableField(value="buyer")
    private java.lang.Long buyer; // 求购人
    @TableField(value="buyer_name")
    private java.lang.String buyerName; // 求购人名称
    @TableField(value="mainimg_path")
    private java.lang.String mainimgPath; // 资产主图URL
    @TableField(value="title")
    private java.lang.String title; // 求购标题
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="end_date")
    private java.util.Date endDate; // 需求截止日期
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目主键
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织主键
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="address_id")
    private java.lang.Long addressId; // 地址主键
    @TableField(value="address_name")
    private java.lang.String addressName; // 详细地址
    @TableField(value="phone")
    private java.lang.String phone; // 联系方式
    @TableField(value="name")
    private java.lang.String name; // 联系人
    @TableField(value="lon")
    private java.lang.Double lon; // 经度
    @TableField(value="lat")
    private java.lang.Double lat; // 纬度
    @TableField(value="first_location")
    private java.lang.String firstLocation; // 所在地一级区域
    @TableField(value="second_location")
    private java.lang.String secondLocation; // 所在地二级区域
    @TableField(value="third_location")
    private java.lang.String thirdLocation; // 所在地三级区域
    @TableField(value="fourth_location")
    private java.lang.String fourthLocation; // 所属城市
    @TableField(value="location")
    private java.lang.String location; // 所在地末级区域
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="buy_time")
    private java.util.Date buyTime; // 求购发布时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="endbuy_time")
    private java.util.Date endbuyTime; // 停止求购时间
    @TableField(value="status")
    private java.lang.Integer status; // 求购状态(0-求购中,1-已关闭，2-暂存)
    @TableField(value="close_type")
    private java.lang.Integer closeType; // 关闭类型0-手动关闭,1-到期关闭
    @TableField(value="closer")
    private java.lang.Long closer; // 关闭人
    @TableField(value="note")
    private java.lang.String note; // 求购说明
    @TableField(value="label_name")
    private java.lang.String labelName; // 标签名称


    // 标签子表
    @TableField(exist = false)
    @SubEntity(serviceName="labeldetailService",pidName = "sourceId")
    private List<LabeldetailEntity> labels = new ArrayList<>();

    // 图片子表
    @TableField(exist = false)
    @SubEntity(serviceName="imgdetailService",pidName = "sourceId")
    private List<ImgdetailEntity> imgsPath = new ArrayList<>();

    // 求购物资子表
    @TableField(exist = false)
    @SubEntity(serviceName="categoryService",pidName = "wbuyId")
    private List<CategoryEntity> materialDetails = new ArrayList<>();

    public List<LabeldetailEntity> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailEntity> labels) {
        this.labels = labels;
    }

    public List<ImgdetailEntity> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailEntity> imgsPath) {
        this.imgsPath = imgsPath;
    }

    public List<CategoryEntity> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<CategoryEntity> materialDetails) {
        this.materialDetails = materialDetails;
    }

    public Double getLon() {
        return lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    /**
     * 求购编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 求购编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 求购人
     */
    public java.lang.Long getBuyer() {
        return buyer;
    }

    /**
     * 求购人
     */
    public void setBuyer(java.lang.Long buyer) {
        this.buyer = buyer;
    }
    /**
     * 求购人名称
     */
    public java.lang.String getBuyerName() {
        return buyerName;
    }

    /**
     * 求购人名称
     */
    public void setBuyerName(java.lang.String buyerName) {
        this.buyerName = buyerName;
    }
    /**
     * 资产主图URL
     */
    public java.lang.String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(java.lang.String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 求购标题
     */
    public java.lang.String getTitle() {
        return title;
    }

    /**
     * 求购标题
     */
    public void setTitle(java.lang.String title) {
        this.title = title;
    }
    /**
     * 需求截止日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 需求截止日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 项目主键
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织主键
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 地址主键
     */
    public java.lang.Long getAddressId() {
        return addressId;
    }

    /**
     * 地址主键
     */
    public void setAddressId(java.lang.Long addressId) {
        this.addressId = addressId;
    }
    /**
     * 详细地址
     */
    public java.lang.String getAddressName() {
        return addressName;
    }

    /**
     * 详细地址
     */
    public void setAddressName(java.lang.String addressName) {
        this.addressName = addressName;
    }
    /**
     * 联系方式
     */
    public java.lang.String getPhone() {
        return phone;
    }

    /**
     * 联系方式
     */
    public void setPhone(java.lang.String phone) {
        this.phone = phone;
    }
    /**
     * 联系人
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 联系人
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 所在地一级区域
     */
    public java.lang.String getFirstLocation() {
        return firstLocation;
    }

    /**
     * 所在地一级区域
     */
    public void setFirstLocation(java.lang.String firstLocation) {
        this.firstLocation = firstLocation;
    }
    /**
     * 所在地二级区域
     */
    public java.lang.String getSecondLocation() {
        return secondLocation;
    }

    /**
     * 所在地二级区域
     */
    public void setSecondLocation(java.lang.String secondLocation) {
        this.secondLocation = secondLocation;
    }
    /**
     * 所在地三级区域
     */
    public java.lang.String getThirdLocation() {
        return thirdLocation;
    }

    /**
     * 所在地三级区域
     */
    public void setThirdLocation(java.lang.String thirdLocation) {
        this.thirdLocation = thirdLocation;
    }
    /**
     * 所属城市
     */
    public java.lang.String getFourthLocation() {
        return fourthLocation;
    }

    /**
     * 所属城市
     */
    public void setFourthLocation(java.lang.String fourthLocation) {
        this.fourthLocation = fourthLocation;
    }
    /**
     * 所在地末级区域
     */
    public java.lang.String getLocation() {
        return location;
    }

    /**
     * 所在地末级区域
     */
    public void setLocation(java.lang.String location) {
        this.location = location;
    }
    /**
     * 求购发布时间
     */
    public java.util.Date getBuyTime() {
        return buyTime;
    }

    /**
     * 求购发布时间
     */
    public void setBuyTime(java.util.Date buyTime) {
        this.buyTime = buyTime;
    }
    /**
     * 停止求购时间
     */
    public java.util.Date getEndbuyTime() {
        return endbuyTime;
    }

    /**
     * 停止求购时间
     */
    public void setEndbuyTime(java.util.Date endbuyTime) {
        this.endbuyTime = endbuyTime;
    }
    /**
     * 求购状态(0-求购中,1-已关闭，2-暂存)
     */
    public java.lang.Integer getStatus() {
        return status;
    }

    /**
     * 求购状态(0-求购中,1-已关闭，2-暂存)
     */
    public void setStatus(java.lang.Integer status) {
        this.status = status;
    }
    /**
     * 关闭类型0-手动关闭,1-到期关闭
     */
    public java.lang.Integer getCloseType() {
        return closeType;
    }

    /**
     * 关闭类型0-手动关闭,1-到期关闭
     */
    public void setCloseType(java.lang.Integer closeType) {
        this.closeType = closeType;
    }
    /**
     * 关闭人
     */
    public java.lang.Long getCloser() {
        return closer;
    }

    /**
     * 关闭人
     */
    public void setCloser(java.lang.Long closer) {
        this.closer = closer;
    }
    /**
     * 求购说明
     */
    public java.lang.String getNote() {
        return note;
    }

    /**
     * 求购说明
     */
    public void setNote(java.lang.String note) {
        this.note = note;
    }
    /**
     * 标签名称
     */
    public java.lang.String getLabelName() {
        return labelName;
    }

    /**
     * 标签名称
     */
    public void setLabelName(java.lang.String labelName) {
        this.labelName = labelName;
    }
    
}
