/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"goods"})
public class GoodsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService service;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ICollectService collectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveGoods(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List list = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)list.get(0))).getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        vo.setId(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        if (CollectionUtils.isNotEmpty((Collection)vo.getImgsPath())) {
            vo.getImgsPath().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        param.getParams().put("remainingNums", new Parameter("gt", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        if (null != lon && null != lat) {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<GoodsEntity> list = this.service.queryGoods(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", (Object)BeanMapper.mapList(list, GoodsVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        } else {
            IPage page = this.service.queryPage(param, false);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            res.put("records", (Object)page.getRecords());
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryGoodsDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryGoodsDetail(id));
    }

    @RequestMapping(value={"/queryOtherGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)1));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)2));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter("eq", (Object)saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listOrder = this.orderService.queryList(queryParam, false);
        if (null != listOrder && listOrder.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8ba2\u5355,\u4e0d\u5141\u8bb8\u4e0b\u67b6");
        }
        entity.setStatus(1);
        entity.setLowerType(0);
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        this.service.saveOrUpdate((Object)entity, false);
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/shelfGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String day = request.getParameter("day");
        this.logger.debug("\u53c2\u6570----" + day);
        if (StringUtils.isNotEmpty((CharSequence)day)) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.gt(GoodsEntity::getShelfTime, (Object)DateFormater.getInstance().setDay(Integer.parseInt(day)));
            lambdachange.eq(GoodsEntity::getStatus, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter("eq", (Object)entity.getId()));
                    queryParam.getParams().put("type", new Parameter("eq", (Object)0));
                    List listOrder = this.orderService.queryList(queryParam, false);
                    if (null == listOrder || listOrder.size() <= 0) {
                        this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u4e0b\u67b6----");
                        entity.setStatus(1);
                        entity.setLowerType(2);
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                    }
                });
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }
}

