/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private static final String PANHUO_DD = "PANHUO_DD";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IGoodsService goodsService;

    @Override
    public OrderVO saveOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        OrderEntity orderEntity = (OrderEntity)((Object)BeanMapper.map((Object)vo, OrderEntity.class));
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        if (null != vo && StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_DD, tenantId);
            if (billCode.isSuccess()) {
                orderEntity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
        BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
        goodsEntity.setPreNums(preNums.add(vo.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.subtract(vo.getOrdernums()));
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        super.saveOrUpdate((Object)orderEntity, false);
        OrderVO resvo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        return resvo;
    }

    @Override
    public String confirmerOrder(OrderVO vo) {
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        OrderEntity orderEntity = (OrderEntity)((Object)super.getById((Serializable)vo.getId()));
        BigDecimal nums = goodsEntity.getNums() == null ? BigDecimal.ZERO : goodsEntity.getNums();
        BigDecimal sellNums = goodsEntity.getSellNums() == null ? BigDecimal.ZERO : goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
        BigDecimal remainingNums = goodsEntity.getRemainingNums() == null ? BigDecimal.ZERO : goodsEntity.getRemainingNums();
        goodsEntity.setSellNums(sellNums.add(vo.getNums()));
        goodsEntity.setPreNums(preNums.subtract(orderEntity.getOrdernums()));
        goodsEntity.setRotatableNums(nums.subtract(goodsEntity.getSellNums()).subtract(goodsEntity.getPreNums()));
        goodsEntity.setRemainingNums(nums.subtract(goodsEntity.getSellNums()));
        if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId, (Object)vo.getGoodsId());
            lambdachange.eq(OrderEntity::getType, (Object)0);
            lambdachange.ne(BaseEntity::getId, (Object)vo.getId());
            int num = super.count((Wrapper)lambdachange);
            if (num <= 0) {
                goodsEntity.setStatus(1);
                goodsEntity.setLowerType(1);
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }
        }
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        orderEntity.setConfirmer(vo.getConfirmer());
        orderEntity.setConfirmName(vo.getConfirmName());
        orderEntity.setPrice(vo.getPrice());
        orderEntity.setNums(vo.getNums());
        orderEntity.setMny(vo.getMny());
        orderEntity.setDealrTime(DateFormater.getCurrentDate());
        orderEntity.setType(1);
        super.saveOrUpdate((Object)orderEntity, false);
        return "success";
    }
}

