/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private static final String PANHUO_ZC = "PANHUO_ZC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IImgdetailService imgdetailService;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;

    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        List list;
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (vo.getId() != null && vo.getId() > 0L) {
            list = vo.getImgsPath();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                entity.setMainimgPath(((ImgdetailVO)list.get(0)).getThumpath());
            }
            QueryWrapper imgWrapper = new QueryWrapper();
            imgWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.imgdetailService.remove((Wrapper)imgWrapper);
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
        } else {
            if (0 == vo.getStatus()) {
                entity.setShelfTime(DateFormater.getCurrentDate());
            }
            if ("1".equals(vo.getShelfType())) {
                long toolId = System.currentTimeMillis();
                entity.setToolId(toolId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = vo.getImgsPath()))) {
                entity.setMainimgPath(((ImgdetailVO)list.get(0)).getThumpath());
            }
        }
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsDetailsVO vo = (GoodsDetailsVO)BeanMapper.map((Object)((Object)entity), GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange.ne(BaseEntity::getId, (Object)id);
        int nums = super.count((Wrapper)lambdachange);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
            vo.setOtherNums(nums);
        }
        if ("1".equals(entity.getShelfType())) {
            ArrayList<GoodsToolVO> listtools = new ArrayList<GoodsToolVO>();
            GoodsToolVO toolVO = (GoodsToolVO)BeanMapper.map((Object)((Object)entity), GoodsToolVO.class);
            toolVO.setDealrTime(entity.getShelfTime());
            toolVO.setName("\u91c7\u8d2d\u5165\u5e93");
            listtools.add(toolVO);
            if (1 == entity.getStatus() && 1 == entity.getLowerType()) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
                queryParam.getParams().put("tool_id", new Parameter("eq", (Object)entity.getToolId()));
                queryParam.getParams().put("type", new Parameter("eq", (Object)1));
                queryParam.getOrderMap().put("dealr_time", "desc");
                List listOrder = this.orderService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)listOrder)) {
                    List tools = BeanMapper.mapList((Iterable)listOrder, GoodsToolVO.class);
                    tools.forEach(e -> e.setName("\u5468\u8f6c\u5165\u5e93"));
                    listtools.addAll(tools);
                }
            }
            vo.setToolDetails(listtools);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listc = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listc)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((GoodsEntity)((Object)list.get(0))).getId());
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((GoodsMapper)this.baseMapper).getGoods(pages, queryWrapper, lon, lat);
    }
}

