/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"wbuy"})
public class WbuyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWbuyService service;
    @Autowired
    private ICollectService collectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WbuyVO> saveOrUpdate(@RequestBody WbuyVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveWbuy(saveorUpdateVO));
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WbuyVO> updateStatus(@RequestBody WbuyVO saveorUpdateVO) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setStatus(1);
        entity.setCloseType(0);
        entity.setEndbuyTime(DateFormater.getCurrentDate());
        entity.setCloser(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)entity, false);
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WbuyVO> queryDetail(Long id) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(id));
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)1));
        List list = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)list.get(0))).getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WbuyVO> queryCopyDetail(Long id) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(id));
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        vo.setId(null);
        vo.setCloser(null);
        vo.setCloseType(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        if (CollectionUtils.isNotEmpty((Collection)vo.getImgsPath())) {
            vo.getImgsPath().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getMaterialDetails())) {
            vo.getMaterialDetails().forEach(e -> {
                e.setWbuyId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WbuyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        if (null != lon && null != lat) {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<WbuyEntity> list = this.service.queryWbuy(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", (Object)BeanMapper.mapList(list, WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        } else {
            IPage page = this.service.queryPage(param, false);
            res.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryWbuyIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryWbuyEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)1));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryWbuyTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyTemp(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)2));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/shelfWbuy"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse shelfWbuy(HttpServletRequest request) {
        this.logger.debug("\u5f00\u59cb----");
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.lt(WbuyEntity::getEndDate, (Object)DateFormater.getInstance((Date)new Date()).format("yyyy-MM-dd"));
        lambdachange.eq(WbuyEntity::getStatus, (Object)0);
        List list = this.service.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
            list.forEach(e -> {
                e.setStatus(1);
                e.setCloser(99999L);
                e.setCloseType(1);
                e.setEndbuyTime(DateFormater.getCurrentDate());
            });
            this.service.updateBatchById(list);
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }
}

