/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"goods"})
public class GoodsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService service;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveGoods(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setToolId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        if (CollectionUtils.isNotEmpty((Collection)vo.getImgsPath())) {
            vo.getImgsPath().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        param.getParams().put("rotatableNums", new Parameter("gt", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        if (null != lon && null != lat) {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<GoodsEntity> list = this.service.queryGoods(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", (Object)BeanMapper.mapList(list, GoodsVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        } else {
            IPage page = this.service.queryPage(param, false);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            res.put("records", (Object)page.getRecords());
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryGoodsDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryGoodsDetail(id));
    }

    @RequestMapping(value={"/queryOtherGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        param.getParams().put("rotatableNums", new Parameter("gt", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        CommonResponse childOrgResp;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && 0 == Integer.parseInt(isMyGoods.getValue().toString())) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        }
        if (!(childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        CommonResponse childOrgResp;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)1));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && 0 == Integer.parseInt(isMyGoods.getValue().toString())) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        }
        if (!(childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryGoodsTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        CommonResponse childOrgResp;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)2));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && 0 == Integer.parseInt(isMyGoods.getValue().toString())) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        }
        if (!(childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter("eq", (Object)saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listOrder = this.orderService.queryList(queryParam, false);
        if (null != listOrder && listOrder.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8ba2\u5355,\u4e0d\u5141\u8bb8\u4e0b\u67b6\uff01");
        }
        entity.setStatus(1);
        entity.setLowerType(0);
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        this.service.saveOrUpdate((Object)entity, false);
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
    }

    @RequestMapping(value={"/shelfGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String day = request.getParameter("day");
        this.logger.debug("\u53c2\u6570----" + day);
        if (StringUtils.isNotEmpty((CharSequence)day)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - Integer.parseInt(day));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, (Object)df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                HashMap map = new HashMap();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter("eq", (Object)entity.getId()));
                    queryParam.getParams().put("type", new Parameter("eq", (Object)0));
                    List listOrder = this.orderService.queryList(queryParam, false);
                    if (null == listOrder || listOrder.size() <= 0) {
                        this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u4e0b\u67b6----");
                        entity.setStatus(1);
                        entity.setLowerType(2);
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                        if (map.containsKey(entity.getSeller())) {
                            ((List)map.get(entity.getSeller())).add(entity);
                        } else {
                            ArrayList<GoodsEntity> listGoods = new ArrayList<GoodsEntity>();
                            listGoods.add((GoodsEntity)((Object)entity));
                            map.put(entity.getSeller(), listGoods);
                        }
                    }
                });
                for (Map.Entry entry : map.entrySet()) {
                    ArrayList<String> messageType = new ArrayList<String>();
                    messageType.add("sys");
                    ArrayList<String> sender = new ArrayList<String>();
                    sender.add(entry.getKey() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender);
                    String formurl = "https://www.baidu.com/";
                    String subject = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u4ef6\u4eca\u65e5\u5230\u671f\u81ea\u52a8\u4e0b\u67b6";
                    String content = "\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u4ef6\u4eca\u65e5\u5230\u671f\u81ea\u52a8\u4e0b\u67b6\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content);
                }
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

