/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"allot"})
public class AllotController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotService service;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllotVO> saveOrUpdate(@RequestBody AllotVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveAllot(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllotVO> queryDetail(Long id) {
        AllotEntity entity = (AllotEntity)((Object)this.service.selectById(id));
        AllotVO vo = (AllotVO)BeanMapper.map((Object)((Object)entity), AllotVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AllotVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sellOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("buyOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotVO.class));
        List listExport = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            listExport = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("allotExport.xlsx", beans, response);
    }
}

