/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.mapper.CollectMapper;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.business.panhuo.vo.WorkVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="collectService")
public class CollectServiceImpl
extends BaseServiceImpl<CollectMapper, CollectEntity>
implements ICollectService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IWbuyService wbuyService;

    @Override
    public List<GoodsVO> queryMyCollectGoods(Page pages, QueryWrapper queryWrapper, String userId) {
        return ((CollectMapper)this.baseMapper).getMyCollectGoods(pages, queryWrapper, userId);
    }

    @Override
    public List<WbuyVO> queryMyCollectWbuy(Page pages, QueryWrapper queryWrapper, String userId) {
        return ((CollectMapper)this.baseMapper).getMyCollectWbuy(pages, queryWrapper, userId);
    }

    @Override
    public WorkVO queryNums() {
        WorkVO workVO = new WorkVO();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        QueryWrapper goodsWrapper = new QueryWrapper();
        goodsWrapper.eq((Object)"tenant_id", (Object)tenantId);
        goodsWrapper.eq((Object)"user_id", (Object)userId);
        goodsWrapper.eq((Object)"type", (Object)0);
        int zcNums = super.count((Wrapper)goodsWrapper);
        workVO.setZcNums(Integer.valueOf(zcNums));
        QueryWrapper wbuyWrapper = new QueryWrapper();
        wbuyWrapper.eq((Object)"tenant_id", (Object)tenantId);
        wbuyWrapper.eq((Object)"user_id", (Object)userId);
        wbuyWrapper.eq((Object)"type", (Object)1);
        int qgNums = super.count((Wrapper)wbuyWrapper);
        workVO.setQgNums(Integer.valueOf(qgNums));
        QueryWrapper addressWrapper = new QueryWrapper();
        addressWrapper.eq((Object)"tenant_id", (Object)tenantId);
        addressWrapper.eq((Object)"user_id", (Object)userId);
        int addressNums = this.addressService.count((Wrapper)addressWrapper);
        workVO.setAddressNums(Integer.valueOf(addressNums));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(userId);
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        QueryWrapper buyIngWrapper = new QueryWrapper();
        buyIngWrapper.eq((Object)"tenant_id", (Object)tenantId);
        buyIngWrapper.eq((Object)"type", (Object)0);
        if (CollectionUtils.isNotEmpty(childIds)) {
            buyIngWrapper.in((Object)"buy_org", childIds);
        }
        int buyIngNums = this.orderService.count((Wrapper)buyIngWrapper);
        workVO.setBuyIngNums(Integer.valueOf(buyIngNums));
        QueryWrapper sellIngWrapper = new QueryWrapper();
        sellIngWrapper.eq((Object)"tenant_id", (Object)tenantId);
        sellIngWrapper.eq((Object)"type", (Object)0);
        if (CollectionUtils.isNotEmpty(childIds)) {
            sellIngWrapper.in((Object)"sell_org", childIds);
        }
        int sellIngNums = this.orderService.count((Wrapper)sellIngWrapper);
        workVO.setSellIngNums(Integer.valueOf(sellIngNums));
        QueryWrapper goodsTempWrapper = new QueryWrapper();
        goodsTempWrapper.eq((Object)"tenant_id", (Object)tenantId);
        goodsTempWrapper.eq((Object)"status", (Object)2);
        if (CollectionUtils.isNotEmpty(childIds)) {
            goodsTempWrapper.in((Object)"org_id", childIds);
        }
        int goodsNums = this.goodsService.count((Wrapper)goodsTempWrapper);
        workVO.setGoodsNums(Integer.valueOf(goodsNums));
        QueryWrapper wbuyTempWrapper = new QueryWrapper();
        wbuyTempWrapper.eq((Object)"tenant_id", (Object)tenantId);
        wbuyTempWrapper.eq((Object)"status", (Object)2);
        if (CollectionUtils.isNotEmpty(childIds)) {
            wbuyTempWrapper.in((Object)"org_id", childIds);
        }
        int wbuyNums = this.wbuyService.count((Wrapper)wbuyTempWrapper);
        workVO.setWbuyNums(Integer.valueOf(wbuyNums));
        return workVO;
    }

    @Override
    @Transactional
    public CollectEntity queryCollectTest() {
        Long pkId = IdWorker.getId();
        CollectEntity entity = new CollectEntity();
        entity.setId(pkId);
        entity.setType(1);
        entity.setCollectId(378578041230078022L);
        entity.setUserId(InvocationInfoProxy.getUserid());
        super.save((Object)entity);
        CollectEntity uniqueBean = (CollectEntity)((Object)super.getById((Serializable)pkId));
        return uniqueBean;
    }
}

