/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private static final String PANHUO_ZC = "PANHUO_ZC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IGoodsService servicel;

    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (vo.getId() != null && vo.getId() > 0L) {
            List<LabeldetailEntity> listlb = entity.getLabels();
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        if ("1".equals(vo.getShelfType()) && (null == vo.getToolId() || vo.getToolId() <= 0L)) {
            long toolId = System.currentTimeMillis();
            entity.setToolId(toolId);
            entity.setType(0);
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsDetailsVO vo = (GoodsDetailsVO)BeanMapper.map((Object)((Object)entity), GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange.gt(GoodsEntity::getRotatableNums, (Object)0);
        int nums = super.count((Wrapper)lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.gt(GoodsEntity::getRotatableNums, (Object)0);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
        }
        if ("1".equals(entity.getShelfType())) {
            LambdaQueryWrapper lambdachange3 = Wrappers.lambdaQuery();
            lambdachange3.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdachange3.eq(GoodsEntity::getToolId, (Object)entity.getToolId());
            lambdachange3.orderBy(false, true, (Object[])new SFunction[]{GoodsEntity::getShelfTime});
            List listgoods = super.list((Wrapper)lambdachange3);
            ArrayList<GoodsToolVO> listtools = new ArrayList<GoodsToolVO>();
            GoodsToolVO toolVO = (GoodsToolVO)BeanMapper.map(listgoods.get(0), GoodsToolVO.class);
            toolVO.setDealrTime(((GoodsEntity)((Object)listgoods.get(0))).getShelfTime());
            toolVO.setName("\u8d44\u4ea7\u4e0a\u67b6");
            listtools.add(toolVO);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("tool_id", new Parameter("eq", (Object)entity.getToolId()));
            queryParam.getParams().put("type", new Parameter("eq", (Object)1));
            queryParam.getOrderMap().put("dealr_time", "asc");
            List listOrder = this.orderService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)listOrder)) {
                listOrder.forEach(e -> {
                    GoodsToolVO toolVo = new GoodsToolVO();
                    toolVo.setName("\u5468\u8f6c\u5165\u5e93");
                    toolVo.setProjectName(e.getBuyProjectName());
                    toolVo.setDealrTime(e.getDealrTime());
                    toolVo.setToolId(e.getToolId());
                    listtools.add(toolVo);
                });
            }
            vo.setToolDetails(listtools);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listc = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listc)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)listc.get(0))).getId());
        } else {
            vo.setIsCollect(Integer.valueOf(0));
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((GoodsMapper)this.baseMapper).getGoods(pages, queryWrapper, lon, lat);
    }

    @Override
    public ReportVO orgStatistics(Long orgId) {
        ReportVO goodsNumsIngVo;
        CommonResponse orgListResp;
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        if (null == orgId || orgId <= 0L) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ReportVO resVO = new ReportVO();
        ReportVO pronumsVo = ((GoodsMapper)this.baseMapper).getPronums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != pronumsVo) {
            resVO.setProNums(pronumsVo.getProNums() == null ? BigDecimal.ZERO : pronumsVo.getProNums());
        } else {
            resVO.setProNums(BigDecimal.ZERO);
        }
        ReportVO goodsNumsVo = ((GoodsMapper)this.baseMapper).getGoodsnums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != goodsNumsVo) {
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsAmount());
            if (null != goodsNumsVo.getShelfTime()) {
                int days = (int)((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / 86400000L);
                resVO.setDays(days);
            }
        } else {
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }
        if (null != (goodsNumsIngVo = ((GoodsMapper)this.baseMapper).getGoodsnumsIng(InvocationInfoProxy.getTenantid(), commonOrgIds))) {
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfAmount());
        } else {
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }
        ReportVO OrdernumsVo = ((GoodsMapper)this.baseMapper).getOrdernums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != OrdernumsVo) {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        } else {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        }
        return resVO;
    }

    @Override
    public List<ReportVO> periodStatistics(List<Long> commonOrgIds) {
        return ((GoodsMapper)this.baseMapper).getPeriodStatistics(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }

    @Override
    public List<ReportVO> proportion(List<Long> commonOrgIds, int type) {
        if (type == 0) {
            return ((GoodsMapper)this.baseMapper).getGoodsProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        if (1 == type) {
            return ((GoodsMapper)this.baseMapper).getGoodsIngProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
        }
        return ((GoodsMapper)this.baseMapper).getProportion(InvocationInfoProxy.getTenantid(), commonOrgIds);
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> queryIdleGoods(String range, String dateIn, Long orgId) {
        BigDecimal estimationMny = new BigDecimal(0);
        BigDecimal yearEstimationMny = new BigDecimal(0);
        BigDecimal utilizeMny = new BigDecimal(0);
        BigDecimal turnoverRate = new BigDecimal(0);
        BigDecimal shelfNum = new BigDecimal(0);
        BigDecimal shelfProject = new BigDecimal(0);
        BigDecimal yiBai = new BigDecimal(100);
        ReportVO res = this.servicel.orgStatistics(orgId);
        shelfProject = res.getProNums();
        shelfNum = res.getGoodsNums();
        estimationMny = res.getGoodsAmount();
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List<ReportVO> reportVOS = this.servicel.proportion(commonOrgIds, 2);
        for (ReportVO reportVO : reportVOS) {
            utilizeMny = utilizeMny.add(reportVO.getOrderAmount());
        }
        if (!estimationMny.equals(BigDecimal.ZERO)) {
            turnoverRate = utilizeMny.divide(estimationMny, 4, 4).multiply(yiBai);
        }
        ReportVO resVO = new ReportVO();
        ReportVO goodsNumsVo = ((GoodsMapper)this.baseMapper).getYearGoodsnums(InvocationInfoProxy.getTenantid(), commonOrgIds);
        if (null != goodsNumsVo) {
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsAmount());
        } else {
            resVO.setGoodsAmount(BigDecimal.ZERO);
        }
        yearEstimationMny = resVO.getGoodsAmount();
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("estimationMny", estimationMny);
        map.put("yearEstimationMny", yearEstimationMny);
        map.put("utilizeMny", utilizeMny);
        map.put("turnoverRate", turnoverRate);
        map.put("shelfNum", shelfNum);
        map.put("shelfProject", shelfProject);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }
}

