/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.LableEntity;
import com.ejianc.business.panhuo.bean.PutawayDetailEntity;
import com.ejianc.business.panhuo.bean.PutawayEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.ILableService;
import com.ejianc.business.panhuo.service.IPutawayService;
import com.ejianc.business.panhuo.vo.LableUIVO;
import com.ejianc.business.store.api.IIdleManageApi;
import com.ejianc.business.store.vo.IdleFlowVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="putaway")
public class PutawayBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IPutawayService putawayService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String PANHUO_ZC = "PANHUO_ZC";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ILableService lableService;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private IIdleManageApi idleManageApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PutawayEntity putawayEntity = (PutawayEntity)((Object)this.putawayService.selectById(billId));
        List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
        ArrayList<IdleFlowVO> idleFlowVOList = new ArrayList<IdleFlowVO>();
        if (CollectionUtils.isNotEmpty(putawayDetailList)) {
            CommonResponse stringCommonResponse;
            for (PutawayDetailEntity putawayDetailEntity : putawayDetailList) {
                if (putawayDetailEntity.getSourceType() == null || !putawayDetailEntity.getSourceType().equals("\u4ed3\u5e93")) continue;
                IdleFlowVO idleFlowVO = this.getIdleFlowVO(putawayEntity, putawayDetailEntity, 0);
                idleFlowVOList.add(idleFlowVO);
            }
            if (CollectionUtils.isNotEmpty(idleFlowVOList) && !(stringCommonResponse = this.idleManageApi.inOutStore(idleFlowVOList)).isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse = this.idleManageApi.inOutStoreRollback(billId);
        if (!stringCommonResponse.isSuccess()) {
            return CommonResponse.error((String)stringCommonResponse.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PutawayEntity putawayEntity = (PutawayEntity)((Object)this.putawayService.selectById(billId));
        List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
        if (CollectionUtils.isNotEmpty(putawayDetailList)) {
            CommonResponse stringCommonResponse;
            List data;
            ArrayList<IdleFlowVO> idleFlowVOList = new ArrayList<IdleFlowVO>();
            ArrayList<LabeldetailEntity> lableDetailEntityNewList = new ArrayList<LabeldetailEntity>();
            ArrayList<GoodsEntity> goodsEntityArrayList = new ArrayList<GoodsEntity>();
            ArrayList<LableUIVO> lableUIVOArrayList = new ArrayList<LableUIVO>();
            List lableEntityList = this.lableService.list();
            Map<Object, Object> lableMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)lableEntityList)) {
                lableMap = lableEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            }
            List attachIds = putawayDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            Map<Object, Object> attacMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
            }
            Date date = new Date();
            for (PutawayDetailEntity putawayDetailEntity : putawayDetailList) {
                String labelIds;
                GoodsEntity goodsEntity = new GoodsEntity();
                goodsEntity.setId(IdWorker.getId());
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                goodsEntity.setBillCode((String)billCode.getData());
                goodsEntity.setSellerName(putawayEntity.getSellerName());
                goodsEntity.setSeller(putawayEntity.getSeller());
                if ("1".equals(putawayDetailEntity.getShelfType())) {
                    goodsEntity.setToolId(IdWorker.getId());
                    goodsEntity.setType(0);
                }
                if (attacMap.containsKey(putawayDetailEntity.getId())) {
                    List attachmentVOList = (List)attacMap.get(putawayDetailEntity.getId());
                    AttachmentVO attachmentVO = (AttachmentVO)attachmentVOList.stream().findFirst().get();
                    goodsEntity.setMainimgPath(attachmentVO.getImgServerPath() + attachmentVO.getFilePath());
                }
                goodsEntity.setProjectId(putawayEntity.getProjectId());
                goodsEntity.setProjectName(putawayEntity.getProjectName());
                goodsEntity.setOrgId(putawayEntity.getOrgId());
                goodsEntity.setOrgName(putawayEntity.getOrgName());
                goodsEntity.setSpec(putawayDetailEntity.getSpec());
                goodsEntity.setShelfType(putawayDetailEntity.getShelfType());
                goodsEntity.setMaterialId(putawayDetailEntity.getMaterialId());
                goodsEntity.setMaterialCode(putawayDetailEntity.getMaterialCode());
                goodsEntity.setMaterialName(putawayDetailEntity.getMaterialName());
                goodsEntity.setMaterialTypeId(putawayDetailEntity.getMaterialTypeId());
                goodsEntity.setMaterialTypeName(putawayDetailEntity.getMaterialTypeName());
                goodsEntity.setSourceId(putawayDetailEntity.getSourceId());
                goodsEntity.setSystemId(putawayDetailEntity.getSystemId());
                goodsEntity.setOriginalprice(putawayDetailEntity.getOriginalprice());
                goodsEntity.setDiscount(putawayDetailEntity.getDiscount());
                goodsEntity.setUnit(putawayDetailEntity.getUnit());
                goodsEntity.setPrice(putawayDetailEntity.getPrice());
                goodsEntity.setNums(putawayDetailEntity.getRotatableNums());
                goodsEntity.setRemainingNums(putawayDetailEntity.getRotatableNums());
                goodsEntity.setShelfMny(putawayDetailEntity.getShelfMny());
                goodsEntity.setIsPack(putawayDetailEntity.getIsPack());
                goodsEntity.setAddress(putawayEntity.getAddress());
                goodsEntity.setAddressId(putawayEntity.getAddressId());
                goodsEntity.setAddressName(putawayEntity.getAddressName());
                goodsEntity.setAddress(putawayEntity.getAddress());
                goodsEntity.setProjectAddress(putawayEntity.getProjectAddress());
                goodsEntity.setLon(putawayEntity.getLon());
                goodsEntity.setLat(putawayEntity.getLat());
                goodsEntity.setFirstLocation(putawayEntity.getFirstLocation());
                goodsEntity.setSecondLocation(putawayEntity.getSecondLocation());
                goodsEntity.setThirdLocation(putawayEntity.getThirdLocation());
                goodsEntity.setFourthLocation(putawayEntity.getFourthLocation());
                goodsEntity.setLocation(putawayEntity.getLocation());
                goodsEntity.setPhone(putawayEntity.getPhone());
                goodsEntity.setName(putawayEntity.getName());
                goodsEntity.setShelfTime(date);
                goodsEntity.setDetails(putawayDetailEntity.getDetails());
                goodsEntity.setStatus(0);
                goodsEntity.setLabelName(putawayDetailEntity.getLabelName());
                goodsEntity.setPutawayId(putawayEntity.getId());
                goodsEntity.setPutawayDetailId(putawayDetailEntity.getId());
                goodsEntity.setRotatableNums(putawayDetailEntity.getRotatableNums());
                goodsEntity.setStoreId(putawayDetailEntity.getStoreId());
                goodsEntity.setStoreName(putawayDetailEntity.getStoreName());
                goodsEntity.setSourceType(putawayDetailEntity.getSourceType());
                if (state == 1 && putawayDetailEntity.getSourceType() != null && putawayDetailEntity.getSourceType().equals("\u4ed3\u5e93")) {
                    IdleFlowVO idleFlowVO = this.getIdleFlowVO(putawayEntity, putawayDetailEntity, 0);
                    idleFlowVOList.add(idleFlowVO);
                }
                if ((labelIds = putawayDetailEntity.getLabelIds()) != null) {
                    String[] split = labelIds.split(",");
                    List<String> labIds = Arrays.asList(split);
                    for (String id : labIds) {
                        Long lableId = Long.parseLong(id);
                        if (!lableMap.containsKey(lableId)) continue;
                        LableEntity lableEntity = (LableEntity)((Object)lableMap.get(lableId));
                        LabeldetailEntity labeldetailEntity = new LabeldetailEntity();
                        labeldetailEntity.setId(IdWorker.getId());
                        labeldetailEntity.setSourceId(goodsEntity.getId());
                        labeldetailEntity.setType(0);
                        labeldetailEntity.setLabelId(lableEntity.getId());
                        labeldetailEntity.setName(lableEntity.getName());
                        labeldetailEntity.setColour(lableEntity.getColour());
                        lableDetailEntityNewList.add(labeldetailEntity);
                        LableUIVO lableUIVO = new LableUIVO();
                        lableUIVO.setUitype("EJCTagItem");
                        lableUIVO.setUititle(lableEntity.getName());
                        lableUIVO.setText(lableEntity.getName());
                        lableUIVO.setValue(lableEntity.getId().toString());
                        lableUIVO.setColour(lableEntity.getColour());
                        lableUIVO.setLabelId(lableEntity.getId().toString());
                        lableUIVO.setName(lableEntity.getName());
                        lableUIVO.setType("0");
                        lableUIVOArrayList.add(lableUIVO);
                    }
                }
                goodsEntity.setLabelName(JSONObject.toJSONString(lableUIVOArrayList));
                goodsEntityArrayList.add(goodsEntity);
            }
            if (CollectionUtils.isNotEmpty(goodsEntityArrayList)) {
                this.goodsService.saveBatch(goodsEntityArrayList);
            }
            if (CollectionUtils.isNotEmpty(lableDetailEntityNewList)) {
                this.labeldetailService.saveBatch(lableDetailEntityNewList);
            }
            if (CollectionUtils.isNotEmpty(idleFlowVOList) && !(stringCommonResponse = this.idleManageApi.inOutStore(idleFlowVOList)).isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\uff0c\u53ef\u4ee5\u4ece\u8d27\u67b6\u4e0b\u67b6\u6750\u6599!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public IdleFlowVO getIdleFlowVO(PutawayEntity putawayEntity, PutawayDetailEntity putawayDetailEntity, Integer type) {
        IdleFlowVO idleFlowVO = new IdleFlowVO();
        idleFlowVO.setStoreId(putawayDetailEntity.getStoreId());
        idleFlowVO.setStoreName(putawayDetailEntity.getStoreName());
        idleFlowVO.setSourceBillTypeName("\u6750\u6599\u4e0a\u67b6");
        idleFlowVO.setSourceBillTypeCode("EJCBT202312000010");
        idleFlowVO.setProjectId(putawayEntity.getProjectId());
        idleFlowVO.setProjectName(putawayEntity.getProjectName());
        idleFlowVO.setOrgId(putawayEntity.getOrgId());
        idleFlowVO.setOrgName(putawayEntity.getOrgName());
        idleFlowVO.setMaterialCategoryId(putawayDetailEntity.getMaterialTypeId());
        idleFlowVO.setMaterialCategoryName(putawayDetailEntity.getMaterialTypeName());
        idleFlowVO.setMaterialCategoryCode(putawayDetailEntity.getMaterialTypeCode());
        idleFlowVO.setMaterialId(putawayDetailEntity.getMaterialId());
        idleFlowVO.setMaterialName(putawayDetailEntity.getMaterialName());
        idleFlowVO.setMaterialCode(putawayDetailEntity.getMaterialCode());
        idleFlowVO.setMaterialSpec(putawayDetailEntity.getSpec());
        idleFlowVO.setMaterialUnitId(putawayDetailEntity.getUnitId());
        idleFlowVO.setMaterialUnitName(putawayDetailEntity.getUnit());
        if (type == 0) {
            idleFlowVO.setNum(putawayDetailEntity.getRotatableNums());
        } else {
            idleFlowVO.setNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)putawayDetailEntity.getRotatableNums()));
        }
        idleFlowVO.setSourceId(putawayEntity.getId());
        idleFlowVO.setSourceDetailId(putawayDetailEntity.getId());
        idleFlowVO.setSourceBillCode(putawayEntity.getBillCode());
        idleFlowVO.setSourceBillDate(putawayEntity.getCreateTime());
        idleFlowVO.setSourceBillRemark(putawayEntity.getMemo());
        idleFlowVO.setRowState(putawayEntity.getRowState());
        return idleFlowVO;
    }
}

