package com.ejianc.foundation.print.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.mapper.BusinessObjectMapper;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service("businessObjectService")
public class BusinessObjectServiceImpl extends BaseServiceImpl<BusinessObjectMapper, BusinessObjectEntity> implements IBusinessObjectService {

    @Override
    public BusinessObjectEntity queryDetail(Long id) {
        return baseMapper.selectById(id);
    }

    @Override
    public BusinessObjectEntity getByCode(String code, Long tenantid) {
        QueryWrapper<BusinessObjectEntity> q = new QueryWrapper<>();
        q.eq("code", code);
        q.eq("tenant_id", tenantid);
        return baseMapper.selectOne(q);
    }

    @Override
    public BusinessObjectEntity getByEntityIdAndProjectId(Long entityId, Long projectId) {
        QueryWrapper<BusinessObjectEntity> q = new QueryWrapper<>();
        q.eq("entity_id", entityId);
        q.eq("project_id", projectId);
        return baseMapper.selectOne(q);
    }
}
