/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.INumberService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.print.vo.NumberVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commonPrint/"})
public class DataPrintController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private ICustomTableApi customTableApi;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private INumberService numberService;
    @Value(value="${oms.tenantid}")
    private Long OMS_TENANTID;

    @GetMapping(value={"printDetail"})
    public CommonResponse<JSONObject> printDetail(@RequestParam(value="id") Long id, @RequestParam(value="billType") String billType, @RequestParam(value="allApprove", required=false) Boolean allApprove, HttpServletRequest req) {
        CommonResponse printData = new CommonResponse();
        if (billType.contains("CFS")) {
            JSONObject resp = new JSONObject();
            CommonResponse data = this.customTableApi.queryPrintDetail(billType, id);
            if (data.isSuccess()) {
                resp.put(billType, data.getData());
                return CommonResponse.success((Object)resp);
            }
            return CommonResponse.error((String)data.getMsg());
        }
        CommonResponse billTypeVo = this.billTypeApi.getByCode(billType);
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)billType);
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse data = new CommonResponse();
        printData = allApprove != null && allApprove != false ? this.mdApi.queryCommonPrintDataAllApprove(((BillTypeVO)billTypeVo.getData()).getMetadataId(), id) : this.mdApi.queryCommonPrintData(((BillTypeVO)billTypeVo.getData()).getMetadataId(), id);
        this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010{}\u3011,\u5355\u636eId-\u3010{}\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\uff1a{}", new Object[]{billType, id, JSONObject.toJSONString((Object)printData)});
        if (!printData.isSuccess()) {
            return CommonResponse.error((String)("\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010" + billType + "\u3011,\u5355\u636eId-\u3010" + id + "\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u5931\u8d25\uff01"));
        }
        return this.handleData((CommonResponse<JSONObject>)printData, (BillTypeVO)billTypeVo.getData(), req.getHeader("authority"));
    }

    @PostMapping(value={"printBatch"})
    public CommonResponse<JSONArray> printBatch(@RequestBody Map<String, String> params, HttpServletRequest req) {
        if (params == null) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01");
        }
        String billIds = params.get("billIds");
        String detailUrl = params.get("detailUrl");
        if (StringUtils.isEmpty((String)billIds)) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01billIds\u4e3a\u7a7a\uff01");
        }
        String billType = params.get("billType");
        String templateId = params.get("templateId");
        String templateCode = params.get("templateCode");
        if (StringUtils.isEmpty((String)billIds)) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff01billType\u4e3a\u7a7a\uff01");
        }
        Boolean allApprove = params.get("allApprove") == null ? null : Boolean.valueOf(Boolean.parseBoolean(params.get("allApprove")));
        CommonResponse billTypeVo = this.billTypeApi.getByCode(billType);
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)billType);
            return CommonResponse.error((String)"\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONArray array = new JSONArray();
        for (String s : billIds.split(",")) {
            Long id = Long.parseLong(s);
            CommonResponse<NumberVO> commonResponse = this.numberService.printNumer(Long.parseLong(templateId), templateCode, id);
            if (StringUtils.isEmpty((String)detailUrl)) {
                Object printData = allApprove != null && allApprove != false ? this.mdApi.queryCommonPrintDataAllApprove(((BillTypeVO)billTypeVo.getData()).getMetadataId(), id) : this.mdApi.queryCommonPrintData(((BillTypeVO)billTypeVo.getData()).getMetadataId(), id);
                if (!printData.isSuccess()) {
                    this.logger.error("\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25,\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010" + billType + "\u3011,\u5355\u636eId-\u3010" + id + "\u3011\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u5931\u8d25\uff01");
                    continue;
                }
                if ((printData = this.handleData((CommonResponse<JSONObject>)printData, (BillTypeVO)billTypeVo.getData(), req.getHeader("authority"))).isSuccess()) {
                    Set keys = ((JSONObject)printData.getData()).keySet();
                    for (String key : keys) {
                        ((JSONObject)printData.getData()).getJSONObject(key).put("printNumber", (Object)("\u5df2\u6253\u5370" + ((NumberVO)commonResponse.getData()).getNumber() + "\u6b21"));
                    }
                    array.add(printData.getData());
                    continue;
                }
                this.logger.error("\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25,\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010" + billType + "\u3011,\u5355\u636eId-\u3010" + id + "\u3011 \u5904\u7406\u5355\u636e\u8be6\u60c5\u5931\u8d25\uff01");
                continue;
            }
            params.remove("billIds");
            String reqUrl = detailUrl.contains("http") ? detailUrl : this.environmentTools.getBaseHost() + (detailUrl.startsWith("/") ? detailUrl.substring(1) : detailUrl);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("authority", req.getHeader("authority"));
            params.put("id", s);
            try {
                String result = HttpTookit.get(reqUrl, params, header);
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)result, CommonResponse.class);
                if (resp.isSuccess()) {
                    Set keys = ((JSONObject)resp.getData()).keySet();
                    for (String key : keys) {
                        ((JSONObject)resp.getData()).getJSONObject(key).put("printNumber", (Object)("\u5df2\u6253\u5370" + ((NumberVO)commonResponse.getData()).getNumber() + "\u6b21"));
                    }
                    array.add(resp.getData());
                    continue;
                }
                this.logger.error("\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25,\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010" + billType + "\u3011,\u5355\u636eId-\u3010" + id + "\u3011,\u81ea\u5b9a\u4e49\u6253\u5370\u6570\u636e\u63a5\u53e3-\u3010" + reqUrl + "\u3011\u67e5\u8be2\u5355\u636e\u6253\u5370\u6570\u636e\u5931\u8d25\uff01{}", (Object)resp.getMsg());
            }
            catch (IOException | GeneralSecurityException e) {
                this.logger.error("\u6279\u91cf\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25,\u6839\u636e\u5355\u636e\u7c7b\u578b-\u3010" + billType + "\u3011,\u5355\u636eId-\u3010" + id + "\u3011,\u81ea\u5b9a\u4e49\u6253\u5370\u6570\u636e\u63a5\u53e3-\u3010" + reqUrl + "\u3011\u67e5\u8be2\u5355\u636e\u6253\u5370\u6570\u636e\u5931\u8d25\uff01\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return CommonResponse.success((Object)array);
    }

    private CommonResponse<JSONObject> handleData(CommonResponse<JSONObject> printData, BillTypeVO billType, String authority) {
        if (printData.isSuccess()) {
            QueryWrapper templateQuery = new QueryWrapper();
            templateQuery.eq((Object)"bill_type_code", (Object)billType.getBillCode());
            List tempLsit = this.templateService.list((Wrapper)templateQuery);
            this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\uff1a{}", (Object)JSONObject.toJSONString((Object)tempLsit));
            TemplateEntity template = (TemplateEntity)((Object)tempLsit.get(0));
            String boKey = template.getBoCode().substring(template.getBoCode().lastIndexOf(".") + 1);
            JSONObject data = (JSONObject)printData.getData();
            if (null == data.get((Object)boKey)) {
                JSONObject newData = new JSONObject();
                CommonResponse mdRefer = this.mdApi.queryMetadataById(billType.getMetadataId());
                if (mdRefer.isSuccess()) {
                    String key = ((MdReferVO)mdRefer.getData()).getEntityName().replace("Entity", "");
                    for (String k : data.keySet()) {
                        if (key.equals(k)) {
                            newData.put(boKey, data.get((Object)k));
                            continue;
                        }
                        newData.put(k, data.get((Object)k));
                    }
                    printData.setData((Object)newData);
                }
            }
            if (StringUtils.isNotBlank((String)template.getDataHandleUrl())) {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("authority", authority);
                String reqUrl = (template.getDataHandleUrl().indexOf("http") < 0 ? this.environmentTools.getBaseHost() : "") + (template.getDataHandleUrl().startsWith("/") ? template.getDataHandleUrl().substring(0) : template.getDataHandleUrl());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("detailJson", JSONObject.toJSONString((Object)printData.getData()));
                params.put("billType", billType.getBillCode());
                try {
                    this.logger.info("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}", (Object)reqUrl, (Object)JSONObject.toJSONString(params));
                    String result = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(params), header);
                    this.logger.info("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}, \u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(params), result});
                    CommonResponse resp = (CommonResponse)BeanMapper.map((Object)result, CommonResponse.class);
                    if (resp.isSuccess()) {
                        resp.setData((Object)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data")));
                    }
                    return resp;
                }
                catch (Exception e) {
                    this.logger.error("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}, \u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                    return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u6253\u5370\u8be6\u60c5\u5904\u7406\u5931\u8d25\uff01");
                }
            }
        }
        return printData;
    }

    @GetMapping(value={"printDetailData"})
    public CommonResponse<JSONObject> printDetailForData(@RequestParam(value="boId") Long boId, @RequestParam(value="billId") Long billId, HttpServletRequest req) {
        BusinessObjectEntity bo = (BusinessObjectEntity)((Object)this.businessObjectService.selectById(boId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bo_code", (Object)bo.getCode());
        List templateList = this.templateService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6253\u5370\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateEntity t = (TemplateEntity)((Object)templateList.get(0));
        CommonResponse billTypeVo = this.billTypeApi.getByCode(t.getBillTypeCode());
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)t.getBillTypeCode());
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse printData = this.mdApi.queryCommonPrintDetail(((BillTypeVO)billTypeVo.getData()).getMetadataId(), billId);
        return this.handleData((CommonResponse<JSONObject>)printData, (BillTypeVO)billTypeVo.getData(), req.getHeader("authority"));
    }
}

