package com.ejianc.business.prjfinance.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 借款利息结算
 * 
 * @author generator
 * 
 */
public class PrjLoanInterestVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private java.math.BigDecimal currentInterest; // 本期利息
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date handleDate; // 办理日期
    private Long handleUserId; // 经办人id
    private String handleUserName; // 经办人姓名
    private String memo; // 备注
    private String billStateName;
    private List<PrjLoanInterestSubVO> loanInterestSubEntities = new ArrayList<>();
    private BigDecimal totalLoanBalance;

    /**
     * 所属组织Id
     */
    private Long orgId;

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 本期利息
     */
    public java.math.BigDecimal getCurrentInterest() {
        return currentInterest;
    }

    /**
     * 本期利息
     */
    public void setCurrentInterest(java.math.BigDecimal currentInterest) {
        this.currentInterest = currentInterest;
    }
    /**
     * 办理日期
     */
    public java.util.Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理日期
     */
    public void setHandleDate(java.util.Date handleDate) {
        this.handleDate = handleDate;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getHandleUserId() {
        return handleUserId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setHandleUserId(Long handleUserId) {
        this.handleUserId = handleUserId;
    }
    /**
     * 经办人姓名
     */
    public String getHandleUserName() {
        return handleUserName;
    }

    /**
     * 经办人姓名
     */
    public void setHandleUserName(String handleUserName) {
        this.handleUserName = handleUserName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<PrjLoanInterestSubVO> getLoanInterestSubEntities() {
        return loanInterestSubEntities;
    }

    public void setLoanInterestSubEntities(List<PrjLoanInterestSubVO> loanInterestSubEntities) {
        this.loanInterestSubEntities = loanInterestSubEntities;
    }

    public BigDecimal getTotalLoanBalance() {
        return totalLoanBalance;
    }

    public void setTotalLoanBalance(BigDecimal totalLoanBalance) {
        this.totalLoanBalance = totalLoanBalance;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }


}
