package com.ejianc.business.prjfinance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prjfinance.hystrix.PrjRiskMarginHystrix;
import com.ejianc.business.prjfinance.vo.RiskMarginTransVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/7/29 13:44
 */
@FeignClient(name = "ejc-prjfinance-web", url = "${common.env.feign-client-url}", path="ejc-prjfinance-web", fallback = PrjRiskMarginHystrix.class)
public interface IPrjRiskMarginApi {

    @PostMapping(value = "/api/riskMargin/generateByRecRecord")
    public CommonResponse<Object> generateByRecRecord(@RequestBody RiskMarginTransVO saveVO);

    /**
     * 根据项目Id查询对应的
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/riskMargin/getPrjFinanceData")
    public CommonResponse<Map> getPrjFinanceData(@RequestParam Long projectId);

    /**
     * 根据sourceId删除对应的保证金单据
     *
     * @param sourceIds
     * @return
     */
    @PostMapping(value = "/api/riskMargin/delBySourceIds")
    public CommonResponse<JSONObject> delBySourceIds(@RequestBody List<Long> sourceIds);

}
