package com.ejianc.business.prjfinance.vo;

import java.math.BigDecimal;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 项目还款子表
 * 
 * @author generator
 * 
 */
public class ReturnMoneySubVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long loanId; // 借款单id
    private String code; // 借款单号
    private String name; // 借款单主题
    private BigDecimal loanMoney; // 借款金额
    private BigDecimal loanBalance; // 借款结余
    private BigDecimal returnMny; // 本期还款金额
    private String memo; // 备注
    private Long projectId; // 项目id
    private Long pid; // 主表id
    

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 借款单id
     */
    public Long getLoanId() {
        return loanId;
    }

    /**
     * 借款单id
     */
    public void setLoanId(Long loanId) {
        this.loanId = loanId;
    }
    /**
     * 借款单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 借款单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 借款单主题
     */
    public String getName() {
        return name;
    }

    /**
     * 借款单主题
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 借款金额
     */
    public BigDecimal getLoanMoney() {
        return loanMoney;
    }

    /**
     * 借款金额
     */
    public void setLoanMoney(BigDecimal loanMoney) {
        this.loanMoney = loanMoney;
    }
    /**
     * 借款结余
     */
    public BigDecimal getLoanBalance() {
        return loanBalance;
    }

    /**
     * 借款结余
     */
    public void setLoanBalance(BigDecimal loanBalance) {
        this.loanBalance = loanBalance;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
