package com.ejianc.business.projectDutyLetter.controller;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.projectDutyLetter.bean.ProjectDutyLetterEntity;
import com.ejianc.business.projectDutyLetter.service.IProjectDutyLetterService;
import com.ejianc.business.projectDutyLetter.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.business.projectDutyLetter.vo.ProjectDutyLetterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * @Author liyongjia
 * @Date 2021/5/11
 * @Description ProjectCapitalSetController
 */

@Controller
@RequestMapping("/projectCapitalSet/")
public class ProjectDutyLetterController {    
	private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterController.class);

    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return 
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> saveOrUpdate(@RequestBody ProjectDutyLetterVO vo) {
    	//检验项目是否唯一，若存在则不能新增
    	checkProject(vo);
        ProjectDutyLetterEntity entity = BeanMapper.map(vo, ProjectDutyLetterEntity.class);
		
        projectDutyLetterService.saveOrUpdate(entity,false);
        ProjectDutyLetterVO backVo = BeanMapper.map(entity, ProjectDutyLetterVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }
    
    public void checkProject(ProjectDutyLetterVO vo) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ,vo.getProjectId()));
		if(vo.getId()!=null){
			queryParam.getParams().put("id", new Parameter(QueryParam.NE,vo.getId()));
		}
		List<ProjectDutyLetterEntity> list = projectDutyLetterService.queryList(queryParam, false);
		if(list!=null&&list.size()>0){
			//已存在，不允许修改
			throw new BusinessException("项目已存在，请重新选择项目");
		}
    }
    
    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return 
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterEntity entity = projectDutyLetterService.selectById(id);
        ProjectDutyLetterVO vo = BeanMapper.map(entity, ProjectDutyLetterVO.class);
        CommonResponse<JSONObject> inAndOut = iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if(inAndOut.isSuccess()){
			JSONObject dataresultIncoemAndExpend = inAndOut.getData();
			if(dataresultIncoemAndExpend.get("incomeTaxRate")!=null){
				dataresultIncoemAndExpend.put("incomeTaxRate", dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
			}
        	if(vo.getProjectDutyLetterCostList()!=null&&vo.getProjectDutyLetterCostList().size()>0){
        		List<ProjectDutyLetterCostlistVO> list = vo.getProjectDutyLetterCostList();
        		BigDecimal otherMoney = new BigDecimal(0);
        		for(ProjectDutyLetterCostlistVO cost : list){
    				if(cost.getFormula()!=null){
    					String evalq = cost.getFormula();
    					for (String key : dataresultIncoemAndExpend.keySet()) {
    						String value = "0";
                            value = dataresultIncoemAndExpend.getString(key)!=null?dataresultIncoemAndExpend.getString(key):"0";
                            evalq = evalq.replaceAll(key, value);
                        }
    					
    					ScriptEngineManager manager = new ScriptEngineManager();
    					ScriptEngine se = manager.getEngineByName("js");
    					BigDecimal money = new BigDecimal(0);
						try {
							money = new BigDecimal( (Double) se.eval(evalq));
						} catch (ScriptException e) {
							e.printStackTrace();
						}
    					if("delete".equals(cost.getAddOrDelete())){
    						money = new BigDecimal(0).subtract(money);
    					}
						cost.setAmount(money);
						otherMoney = otherMoney.add(money);
    				}else{
						cost.setAmount(new BigDecimal(0));
    				}
        		}
        	}
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author liyongjia
     * @Date 2021/5/11 查询详情
     * @Description queryList
     * @Param [id]
     * @Return IPage<ProjectDutyLetterVO>
     */
    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectDutyLetterVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 数据隔离 本下 */
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,orgIds));
        IPage<ProjectDutyLetterEntity> page = projectDutyLetterService.queryPage(param,false);
        IPage<ProjectDutyLetterVO> voPage = null;
        if(page!=null){
            voPage = new Page<>();
            voPage.setCurrent(page.getCurrent());
            voPage.setPages(page.getPages());
            voPage.setTotal(page.getTotal());
            voPage.setSize(param.getPageSize());
            voPage.setRecords(BeanMapper.mapList(page.getRecords(),ProjectDutyLetterVO.class));
        }
        return CommonResponse.success("查询列表数据成功！",voPage);
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterVO> vos) {
    	projectDutyLetterService.removeByIds(vos.stream().map(ProjectDutyLetterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
