/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.prjfinance.bean.PrjAdvancePaymentEntity;
import com.ejianc.business.prjfinance.service.IPrjAdvancePaymentService;
import com.ejianc.business.prjfinance.vo.PrjAdvancePaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/prjAdvancePay/"})
public class PrjAdvancePayController {
    @Autowired
    private IPrjAdvancePaymentService prjAdvancePaymentService;
    @Autowired
    private IOrgApi orgApi;
    private final String BILL_CODE_RULE = "PRJ_ADVANCE_PAYMENT_01";
    @Autowired
    private IBillCodeApi billCodeApi;

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("applySubject");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter("in", childIds));
        IPage pageData = this.prjAdvancePaymentService.queryPage(queryParam, false);
        resp.put("total", (Object)pageData.getTotal());
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("pages", (Object)pageData.getPages());
        resp.put("records", (Object)pageData.getRecords());
        Map<String, BigDecimal> sumAmt = this.prjAdvancePaymentService.sumPrjAdvancePayInfo(queryParam);
        resp.put("totalAdvancePayAmt", (Object)sumAmt.get("totalAdvancePayAmt"));
        resp.put("totalBackAmt", (Object)sumAmt.get("totalBackAmt"));
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<PrjAdvancePaymentVO> saveOrUpdate(@RequestBody PrjAdvancePaymentVO vo) {
        if ("2".equals(vo.getBillType())) {
            Map<String, BigDecimal> info = this.prjAdvancePaymentService.getTotalPrjAdvancePayInfo(vo.getProjectId());
            if (vo.getAmount().compareTo(info.get("remremainingRefundableAmt")) > 0) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u91d1\u989d\u3002");
            }
        }
        PrjAdvancePaymentEntity saveEntity = null;
        if (null == vo.getId()) {
            saveEntity = (PrjAdvancePaymentEntity)((Object)BeanMapper.map((Object)vo, PrjAdvancePaymentEntity.class));
            CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode("PRJ_ADVANCE_PAYMENT_01", InvocationInfoProxy.getTenantid());
            if (!billCodeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\u3002");
            }
            saveEntity.setBillCode((String)billCodeResp.getData());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        } else {
            saveEntity = (PrjAdvancePaymentEntity)((Object)this.prjAdvancePaymentService.selectById(vo.getId()));
            saveEntity.setProjectId(vo.getProjectId());
            saveEntity.setProjectName(vo.getProjectName());
            saveEntity.setAmount(vo.getAmount());
            saveEntity.setHandlingDate(vo.getHandlingDate());
            saveEntity.setSubject(vo.getSubject());
            saveEntity.setOperatorId(vo.getOperatorId());
            saveEntity.setOperatorName(vo.getOperatorName());
            saveEntity.setOrgId(vo.getOrgId());
            saveEntity.setOrgName(vo.getOrgName());
        }
        this.prjAdvancePaymentService.saveOrUpdate((Object)saveEntity, false);
        PrjAdvancePaymentVO resp = (PrjAdvancePaymentVO)BeanMapper.map((Object)((Object)saveEntity), PrjAdvancePaymentVO.class);
        resp.setTotalAdvancePayAmt(vo.getTotalAdvancePayAmt());
        resp.setTotalBackAmt(vo.getTotalBackAmt());
        resp.setRemanentAdvancePayAmt(vo.getRemanentAdvancePayAmt());
        resp.setRemremainingRefundableAmt(vo.getRemremainingRefundableAmt());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<PrjAdvancePaymentVO> queryDetail(@RequestParam(value="id") Long id) {
        PrjAdvancePaymentVO resp = null;
        PrjAdvancePaymentEntity entity = (PrjAdvancePaymentEntity)((Object)this.prjAdvancePaymentService.selectById(id));
        if (null != entity) {
            resp = (PrjAdvancePaymentVO)BeanMapper.map((Object)((Object)entity), PrjAdvancePaymentVO.class);
            Map<String, BigDecimal> info = this.prjAdvancePaymentService.getTotalPrjAdvancePayInfo(resp.getProjectId());
            resp.setTotalAdvancePayAmt(info.get("totalAdvancePayAmt"));
            resp.setTotalBackAmt(info.get("totalBackAmt"));
            resp.setRemanentAdvancePayAmt(info.get("remanentAdvancePayAmt"));
            resp.setRemremainingRefundableAmt(info.get("remremainingRefundableAmt"));
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<PrjAdvancePaymentVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.prjAdvancePaymentService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"getPrjAdvancePayInfo"})
    public CommonResponse<Map<String, BigDecimal>> getProjectCashDepositInfo(@RequestParam(value="projectId") Long projectId) {
        Map<String, BigDecimal> resp = this.prjAdvancePaymentService.getTotalPrjAdvancePayInfo(projectId);
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("applySubject");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryParam.getParams().put("orgId", new Parameter("in", childIds));
        IPage pageData = this.prjAdvancePaymentService.queryPage(queryParam, false);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            pageData.getRecords().forEach(risk -> {
                PrjAdvancePaymentVO r = (PrjAdvancePaymentVO)BeanMapper.map((Object)risk, PrjAdvancePaymentVO.class);
                r.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)r.getBillState()).getDescription());
                r.setBillType("1".equals(r.getBillType()) ? "\u6536\u6b3e\u767b\u8bb0" : "\u9000\u6b3e\u7533\u8bf7");
                voList.add(r);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("prjAdvancePay-export.xlsx", beans, response);
    }
}

