/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.projectDutyLetter.controller;

import com.ejianc.business.prjfinance.projectDutyLetter.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/projectDutyLetterChange/"})
public class ProjectDutyLetterChangeController {
    private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterChangeController.class);
    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ProjectDutyLetterChangeVO> save(@RequestBody ProjectDutyLetterChangeVO projectDutyLetterChangeVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_id", new Parameter("eq", (Object)projectDutyLetterChangeVO.getBillId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)projectDutyLetterChangeVO.getId()));
        List list = this.projectDutyLetterChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u8d23\u4efb\u4e66\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u53d8\u66f4\u8bb0\u5f55\uff01");
        }
        this.codeCheck(projectDutyLetterChangeVO.getBillId(), projectDutyLetterChangeVO.getBillCode());
        ProjectDutyLetterChangeVO resp = this.projectDutyLetterChangeService.save(projectDutyLetterChangeVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    public void codeCheck(Long id, String billCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billCode", new Parameter("eq", (Object)billCode));
        queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        List list = this.projectDutyLetterService.queryList(queryParam, false);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ProjectDutyLetterChangeVO> detail(@RequestParam(value="id") Long id) {
        Object vo = null;
        ProjectDutyLetterChangeEntity e = (ProjectDutyLetterChangeEntity)((Object)this.projectDutyLetterChangeService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterChangeVO> vos) {
        this.projectDutyLetterChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

