/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.projectDutyLetter.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.projectDutyLetter.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectDutyLetter/"})
public class ProjectDutyLetterController {
    private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterController.class);
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> saveOrUpdate(@RequestBody ProjectDutyLetterVO vo) {
        this.checkProject(vo);
        ProjectDutyLetterEntity entity = (ProjectDutyLetterEntity)((Object)BeanMapper.map((Object)vo, ProjectDutyLetterEntity.class));
        this.projectDutyLetterService.saveOrUpdate((Object)entity, false);
        ProjectDutyLetterVO backVo = (ProjectDutyLetterVO)BeanMapper.map((Object)((Object)entity), ProjectDutyLetterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    public void checkProject(ProjectDutyLetterVO vo) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if ((list = this.projectDutyLetterService.queryList(queryParam, false)) != null && list.size() > 0) {
            throw new BusinessException("\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee");
        }
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectDutyLetterVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterEntity entity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(id));
        ProjectDutyLetterVO vo = (ProjectDutyLetterVO)BeanMapper.map((Object)((Object)entity), ProjectDutyLetterVO.class);
        CommonResponse inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectDutyLetterCostList() != null && vo.getProjectDutyLetterCostList().size() > 0) {
                List list = vo.getProjectDutyLetterCostList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectDutyLetterCostlistVO cost : list) {
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectDutyLetterVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
        IPage page = this.projectDutyLetterService.queryPage(param, false);
        Page voPage = null;
        if (page != null) {
            voPage = new Page();
            voPage.setCurrent(page.getCurrent());
            voPage.setPages(page.getPages());
            voPage.setTotal(page.getTotal());
            voPage.setSize((long)param.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectDutyLetterVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", voPage);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectDutyLetterVO> vos) {
        this.projectDutyLetterService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

