/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.projectDutyLetter.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.prjfinance.projectDutyLetter.bean.ProjectDutyLetterRecordEntity;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterRecordCostlistVO;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectDutyLetterRecord/"})
public class ProjectDutyLetterRecordController {
    private static Logger logger = LoggerFactory.getLogger(ProjectDutyLetterRecordController.class);
    @Autowired
    IProjectDutyLetterRecordService projectDutyLetterRecordService;
    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectDutyLetterRecordVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectDutyLetterRecordEntity entity = (ProjectDutyLetterRecordEntity)((Object)this.projectDutyLetterRecordService.selectById(id));
        ProjectDutyLetterRecordVO vo = (ProjectDutyLetterRecordVO)BeanMapper.map((Object)((Object)entity), ProjectDutyLetterRecordVO.class);
        CommonResponse inAndOut = this.iProjectBoardApi.queryIncoemAndExpendByProjectId(vo.getProjectId());
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectDutyLetterRecordCostList() != null && vo.getProjectDutyLetterRecordCostList().size() > 0) {
                List list = vo.getProjectDutyLetterRecordCostList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectDutyLetterRecordCostlistVO cost : list) {
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectDutyLetterRecordVO>> queryList(Long id) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("billId", new Parameter("eq", (Object)id));
        IPage page = this.projectDutyLetterRecordService.queryPage(param, false);
        Page voPage = null;
        if (page != null) {
            voPage = new Page();
            voPage.setCurrent(page.getCurrent());
            voPage.setPages(page.getPages());
            voPage.setTotal(page.getTotal());
            voPage.setSize((long)param.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectDutyLetterRecordVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", voPage);
    }
}

