/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.projectDutyLetter.service.impl;

import com.ejianc.business.prjfinance.projectDutyLetter.bean.ProjectDutyLetterChangeEntity;
import com.ejianc.business.prjfinance.projectDutyLetter.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.projectDutyLetter.mapper.ProjectDutyLetterChangeMapper;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.projectDutyLetter.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.projectDutyLetter.vo.ProjectDutyLetterChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectDutyLetterChangeService")
public class ProjectDutyLetterChangeService
extends BaseServiceImpl<ProjectDutyLetterChangeMapper, ProjectDutyLetterChangeEntity>
implements IProjectDutyLetterChangeService {
    private final String DEFAULT_RULE_CODE = "materialContract";
    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectDutyLetterRecordService projectDutyLetterRecordService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public ProjectDutyLetterChangeVO save(ProjectDutyLetterChangeVO projectDutyLetterChangeVO) {
        ProjectDutyLetterEntity contract = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(projectDutyLetterChangeVO.getBillId()));
        ProjectDutyLetterChangeEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        if (StringUtils.isBlank((CharSequence)projectDutyLetterChangeVO.getBillCode())) {
            projectDutyLetterChangeVO.setBillCode(this.getAutoCode());
        }
        if (null == projectDutyLetterChangeVO.getId()) {
            projectDutyLetterChangeVO.setId(Long.valueOf(IdWorker.getId()));
            projectDutyLetterChangeVO.setCreateUserName(userContext.getUserName());
        }
        saveEntity = (ProjectDutyLetterChangeEntity)((Object)BeanMapper.map((Object)projectDutyLetterChangeVO, ProjectDutyLetterChangeEntity.class));
        super.saveOrUpdate((Object)saveEntity, false);
        this.projectDutyLetterService.saveOrUpdate((Object)contract, false);
        return (ProjectDutyLetterChangeVO)BeanMapper.map((Object)((Object)saveEntity), ProjectDutyLetterChangeVO.class);
    }

    private String getAutoCode() {
        String code = null;
        while (StringUtils.isBlank(code)) {
            CommonResponse resp = this.billCodeApi.getCodeBatchByRuleCode("materialContract", InvocationInfoProxy.getTenantid());
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u53d8\u66f4\u4fe1\u606f\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            }
            boolean checkResult = this.codeCheck((String)resp.getData());
            if (!checkResult) continue;
            code = (String)resp.getData();
        }
        return code;
    }

    public boolean codeCheck(String billCode) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billCode", new Parameter("eq", (Object)billCode));
        List list = this.projectDutyLetterService.queryList(queryParam, false);
        return list == null || list.size() <= 0;
    }

    @Override
    public void deleteById(Long id, boolean b) {
        ProjectDutyLetterChangeEntity e = (ProjectDutyLetterChangeEntity)((Object)super.selectById((Serializable)id));
        if (!BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u53ea\u80fd\u5220\u9664\u81ea\u7531\u6001\u7684\u53d8\u66f4\u6570\u636e\uff01");
        }
        Integer changeState = ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_UNCHANGED;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_id", new Parameter("eq", (Object)e.getBillId()));
        List changeRecords = this.projectDutyLetterRecordService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)changeRecords)) {
            changeState = ProjectDutyLetterChangeVO.DUTYLETTER_CHANGE_STATE_CHANGED;
        }
        ProjectDutyLetterEntity contract = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(e.getBillId()));
        this.projectDutyLetterService.saveOrUpdate((Object)contract, false);
        super.removeById((Serializable)id, false);
    }
}

