package com.ejianc.business.prjfinance.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 质安罚款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjfinance_quality_safety_penalty")
public class PrjQualitySafetyPenaltyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 主题
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="penalty_mny")
    private java.math.BigDecimal penaltyMny; // 罚款金额
    @TableField(value="deal_date")
    private java.util.Date dealDate; // 办理日期
    @TableField(value="deal_person_id")
    private Long dealPersonId; // 经办人id
    @TableField(value="deal_person")
    private String dealPerson; // 经办人
    @TableField(value="total_penalty_mny")
    private java.math.BigDecimal totalPenaltyMny; // 累计罚款金额
    @TableField(value="memo")
    private String memo; // 罚款事由
    
    
    

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 主题
     */
    public String getName() {
        return name;
    }

    /**
     * 主题
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 罚款金额
     */
    public java.math.BigDecimal getPenaltyMny() {
        return penaltyMny;
    }

    /**
     * 罚款金额
     */
    public void setPenaltyMny(java.math.BigDecimal penaltyMny) {
        this.penaltyMny = penaltyMny;
    }
    /**
     * 办理日期
     */
    public java.util.Date getDealDate() {
        return dealDate;
    }

    /**
     * 办理日期
     */
    public void setDealDate(java.util.Date dealDate) {
        this.dealDate = dealDate;
    }
    /**
     * 经办人id
     */
    public Long getDealPersonId() {
        return dealPersonId;
    }

    /**
     * 经办人id
     */
    public void setDealPersonId(Long dealPersonId) {
        this.dealPersonId = dealPersonId;
    }
    /**
     * 经办人
     */
    public String getDealPerson() {
        return dealPerson;
    }

    /**
     * 经办人
     */
    public void setDealPerson(String dealPerson) {
        this.dealPerson = dealPerson;
    }
    /**
     * 累计罚款金额
     */
    public java.math.BigDecimal getTotalPenaltyMny() {
        return totalPenaltyMny;
    }

    /**
     * 累计罚款金额
     */
    public void setTotalPenaltyMny(java.math.BigDecimal totalPenaltyMny) {
        this.totalPenaltyMny = totalPenaltyMny;
    }
    /**
     * 罚款事由
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 罚款事由
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
