package com.ejianc.business.prjfinance.controller;

import java.io.Serializable;

import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.prjfinance.bean.PrjQualitySafetyPenaltyEntity;
import com.ejianc.business.prjfinance.service.IPrjQualitySafetyPenaltyService;
import com.ejianc.business.prjfinance.vo.PrjQualitySafetyPenaltyVO;

/**
 * 质安罚款
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("prjQualitySafetyPenalty")
public class PrjQualitySafetyPenaltyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPrjQualitySafetyPenaltyService service;

    private static final String BILL_CODE = "quality-safety-penalty-001";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> saveOrUpdate(@RequestBody PrjQualitySafetyPenaltyVO saveorUpdateVO) {

        PrjQualitySafetyPenaltyEntity entity = BeanMapper.map(saveorUpdateVO, PrjQualitySafetyPenaltyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

    	service.saveOrUpdate(entity, false);
    	PrjQualitySafetyPenaltyVO vo = BeanMapper.map(entity, PrjQualitySafetyPenaltyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjQualitySafetyPenaltyVO> queryDetail(Long id) {
    	PrjQualitySafetyPenaltyEntity entity = service.selectById(id);
    	PrjQualitySafetyPenaltyVO vo = BeanMapper.map(entity, PrjQualitySafetyPenaltyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjQualitySafetyPenaltyVO> vos) {
        service.removeByIds(vos.stream().map(PrjQualitySafetyPenaltyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrjQualitySafetyPenaltyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("name");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<PrjQualitySafetyPenaltyEntity> page = service.queryPage(param,false);
        IPage<PrjQualitySafetyPenaltyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjQualitySafetyPenaltyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 累计罚款金额
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryTotalPenaltyMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryCurrentInterest(Long projectId){
        Map<String,BigDecimal> map =service.queryTotalPenaltyMny(projectId);
        return CommonResponse.success("查询累计罚款金额成功！",map);
    }

}
