package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prjfinance.bean.PrjOtherCostEntity;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prjfinance.mapper.PrjQualitySafetyPenaltyMapper;
import com.ejianc.business.prjfinance.bean.PrjQualitySafetyPenaltyEntity;
import com.ejianc.business.prjfinance.service.IPrjQualitySafetyPenaltyService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 质安罚款
 * 
 * @author generator
 * 
 */
@Service("prjQualitySafetyPenaltyService")
public class PrjQualitySafetyPenaltyServiceImpl extends BaseServiceImpl<PrjQualitySafetyPenaltyMapper, PrjQualitySafetyPenaltyEntity> implements IPrjQualitySafetyPenaltyService{

    /**
     * 查询累计罚款金额
     * @param projectId
     * @return
     */
    public Map<String, BigDecimal> queryTotalPenaltyMny(Long projectId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryWrapper<PrjQualitySafetyPenaltyEntity> query = new QueryWrapper<>();
        query.select("  sum(penalty_mny) as totalPenaltyMny  ");
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        Map<String, Object> data = super.getMap(query);
        if(null != data) {
            resp.put("totalPenaltyMny", null != data.get("totalPenaltyMny") ? new BigDecimal(data.get("totalPenaltyMny").toString()) :  BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalPenaltyMny", BigDecimal.ZERO);
        }
        return resp;
    }
}
