/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prjfinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.prjfinance.bean.ProjectDutyLetterEntity;
import com.ejianc.business.prjfinance.bean.RiskMarginEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterChangeService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterClauseService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterRecordService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.service.IRiskMarginService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectDutyLetter")
public class ProjectDutyLetterBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String RISK_BILL_CODE_RULE = "RISK_MARGIN_01";
    @Autowired
    IProjectDutyLetterChangeService projectDutyLetterChangeService;
    @Autowired
    IProjectDutyLetterRecordService projectDutyLetterRecordService;
    @Autowired
    IProjectDutyLetterService projectDutyLetterService;
    @Autowired
    IProjectDutyLetterClauseService projectDutyLetterClauseService;
    @Autowired
    IProjectDutyLetterCostlistService projectDutyLetterCostlistService;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IRiskMarginService riskMarginService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        ProjectDutyLetterEntity dutyEntity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(billId));
        if ("bybeceived".equals(dutyEntity.getRiskMarginCollectionMethod())) {
            ArrayList<RiskMarginEntity> riskMarginList = new ArrayList<RiskMarginEntity>();
            CommonResponse receiveReturn = this.receiveManageApi.queryList(dutyEntity.getProjectId());
            if (receiveReturn.isSuccess()) {
                List receiveList = (List)receiveReturn.getData();
                BigDecimal allMoney = new BigDecimal(0);
                for (int i = receiveList.size() - 1; i >= 0; --i) {
                    ReceiveVO receiveVO = (ReceiveVO)receiveList.get(i);
                    allMoney = allMoney.add(receiveVO.getReceiveMny());
                    RiskMarginEntity entity = new RiskMarginEntity();
                    CommonResponse billCodeResp = this.billCodeApi.getCodeBatchByRuleCode("RISK_MARGIN_01", InvocationInfoProxy.getTenantid());
                    if (!billCodeResp.isSuccess()) {
                        return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\u3002");
                    }
                    entity.setBillCode((String)billCodeResp.getData());
                    entity.setBillType("1");
                    entity.setSourceType("1");
                    entity.setBillState(1);
                    entity.setProjectId(dutyEntity.getProjectId());
                    entity.setProjectName(dutyEntity.getProjectName());
                    entity.setApplySubject(DateFormatUtil.formatDate((String)"yyyy-MM", (Date)receiveVO.getConfirmTime()) + "\u6263\u4fdd\u8bc1\u91d1");
                    entity.setApplyDate(receiveVO.getConfirmTime());
                    entity.setOperatorId(receiveVO.getEmployeeId());
                    entity.setOperatorName(receiveVO.getEmployeeName());
                    entity.setOrgId(dutyEntity.getProjectDepartmentId());
                    entity.setOrgName(dutyEntity.getProjectDepartmentName());
                    entity.setSourceId(receiveVO.getId());
                    if (allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount()) == -1) {
                        entity.setApplyAmt(receiveVO.getReceiveMny());
                        riskMarginList.add(entity);
                        continue;
                    }
                    if (allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount()) == 0) {
                        entity.setApplyAmt(receiveVO.getReceiveMny());
                        riskMarginList.add(entity);
                        break;
                    }
                    if (allMoney.compareTo(dutyEntity.getRiskGuaranteeAmount()) != 1) continue;
                    BigDecimal money = receiveVO.getReceiveMny().subtract(allMoney.subtract(dutyEntity.getRiskGuaranteeAmount()));
                    entity.setApplyAmt(money);
                    riskMarginList.add(entity);
                    break;
                }
            }
            if (riskMarginList != null && riskMarginList.size() > 0) {
                this.riskMarginService.saveOrUpdateBatch(riskMarginList, riskMarginList.size(), false);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u9879\u76ee\u8d23\u4efb\u4e66\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectDutyLetterEntity dutyEntity = (ProjectDutyLetterEntity)((Object)this.projectDutyLetterService.selectById(billId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)dutyEntity.getProjectId());
        queryWrapper.eq((Object)"bill_type", (Object)"1");
        queryWrapper.eq((Object)"source_type", (Object)"1");
        queryWrapper.eq((Object)"dr", (Object)0);
        List removeList = this.riskMarginService.list((Wrapper)queryWrapper);
        this.logger.info("\u5220\u9664\u98ce\u9669\u4fdd\u8bc1\u91d1\u6570\u636e----" + removeList.toString());
        ArrayList<Long> ids = new ArrayList<Long>();
        if (removeList != null && removeList.size() > 0) {
            for (RiskMarginEntity entity : removeList) {
                ids.add(entity.getId());
            }
            this.logger.info("\u5220\u9664\u98ce\u9669\u4fdd\u8bc1\u91d1\u6570\u636e----" + ((Object)ids).toString());
            this.riskMarginService.removeByIds(ids);
            this.logger.info("\u5220\u9664\u98ce\u9669\u4fdd\u8bc1\u91d1\u6570\u636e\u6210\u529f\uff01\uff01\uff01\uff01----");
        }
        return CommonResponse.success();
    }
}

