package com.ejianc.business.prjfinance.controller.api;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.business.prjfinance.bean.ProjectDutyLetterCostlistEntity;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterCostlistService;
import com.ejianc.business.prjfinance.service.IProjectDutyLetterService;
import com.ejianc.business.prjfinance.vo.ProjectDutyLetterCostlistVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * @author liyongjia
 * @Description:
 * @date 2021/7/29 14:01
 */
@RestController
@RequestMapping("/api/projectDutyLetter/")
public class ProjectDutyLetterApi {

    @Autowired
    private IProjectDutyLetterService projectDutyLetterService;

    @Autowired
    private IProjectDutyLetterCostlistService projectDutyLetterCostlistService;

    /**
     * 根据项目Id查询对应的
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "getCostListByProjectId")
    public CommonResponse<List<ProjectDutyLetterCostlistVO>> getCostListByProjectId(@RequestParam Long projectId) {
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(projectId);
		List<ProjectDutyLetterCostlistEntity> costList = projectDutyLetterCostlistService.getCostListByProjectIds(projectIds);
		List<ProjectDutyLetterCostlistVO> back = null;
		if(costList!=null&&costList.size()>0){
			back = BeanMapper.mapList(costList, ProjectDutyLetterCostlistVO.class);
		}
		
		return CommonResponse.success(back);
    }

}
